/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.query.impl;

import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.query.ConstructTemplate;
import it.unibz.inf.ontop.query.RDF4JConstructQuery;
import it.unibz.inf.ontop.query.impl.ConstructQuerySplit;
import it.unibz.inf.ontop.query.impl.RDF4JConstructTemplate;
import it.unibz.inf.ontop.query.impl.RegularRDF4JKGQueryImpl;
import it.unibz.inf.ontop.query.resultset.GraphResultSet;
import java.util.Optional;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.MultiProjection;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.QueryRoot;
import org.eclipse.rdf4j.query.algebra.Reduced;
import org.eclipse.rdf4j.query.algebra.Slice;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.UnaryTupleOperator;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;

class RDF4JConstructQueryImpl
extends RegularRDF4JKGQueryImpl<GraphResultSet>
implements RDF4JConstructQuery {
    private final ConstructTemplate template;

    RDF4JConstructQueryImpl(String queryString, ParsedQuery parsedQuery, BindingSet bindings) {
        this(RDF4JConstructQueryImpl.split(parsedQuery), queryString, bindings);
    }

    RDF4JConstructQueryImpl(ConstructQuerySplit split, String queryString, BindingSet bindings) {
        this(split.getConstructTemplate(), (ParsedQuery)split.getSelectParsedQuery(), queryString, bindings);
    }

    private RDF4JConstructQueryImpl(ConstructTemplate template, ParsedQuery selectParsedQuery, String queryString, BindingSet bindings) {
        super(selectParsedQuery, queryString, bindings);
        this.template = template;
    }

    @Override
    public ConstructTemplate getConstructTemplate() {
        return this.template;
    }

    @Override
    public RDF4JConstructQuery newBindings(BindingSet newBindings) {
        return new RDF4JConstructQueryImpl(this.template, this.parsedQuery, this.getOriginalString(), newBindings);
    }

    private static ConstructQuerySplit split(ParsedQuery parsedQuery) {
        TupleExpr root = parsedQuery.getTupleExpr();
        TupleExpr topNonSliceExpression = RDF4JConstructQueryImpl.getFirstNonSliceExpression(root);
        UnaryTupleOperator constructionProjection = RDF4JConstructQueryImpl.getFirstProjection(topNonSliceExpression);
        Optional<Extension> constructionExtension = RDF4JConstructQueryImpl.getExtension(constructionProjection);
        ConstructTemplate constructTemplate = constructionExtension.map(e -> new RDF4JConstructTemplate(constructionProjection, (Extension)e)).orElseGet(() -> new RDF4JConstructTemplate(constructionProjection, null));
        TupleExpr selectSubTree = constructionExtension.map(UnaryTupleOperator::getArg).orElseGet(() -> ((UnaryTupleOperator)constructionProjection).getArg());
        ParsedTupleQuery selectQuery = RDF4JConstructQueryImpl.computeSelectQuery(root, selectSubTree);
        return new ConstructQuerySplit(constructTemplate, selectQuery);
    }

    private static TupleExpr getFirstNonSliceExpression(TupleExpr expr) {
        return expr instanceof Slice ? RDF4JConstructQueryImpl.getFirstNonSliceExpression(((Slice)expr).getArg()) : expr;
    }

    private static Optional<Extension> getExtension(UnaryTupleOperator proj) {
        return Optional.of(proj.getArg()).filter(t -> t instanceof Extension).map(t -> (Extension)t);
    }

    private static UnaryTupleOperator getFirstProjection(TupleExpr expr) {
        if (expr instanceof QueryRoot) {
            return RDF4JConstructQueryImpl.getFirstProjection(((QueryRoot)expr).getArg());
        }
        if (expr instanceof Projection || expr instanceof MultiProjection) {
            return (UnaryTupleOperator)expr;
        }
        if (expr instanceof Reduced) {
            return RDF4JConstructQueryImpl.getFirstProjection(((Reduced)expr).getArg());
        }
        throw new MinorOntopInternalBugException("Unexpected SPARQL query (after parsing): an instance of " + Projection.class + " or " + Reduced.class + " is expected, instead of\n" + expr);
    }

    private static ParsedTupleQuery computeSelectQuery(TupleExpr root, TupleExpr selectSubTree) {
        TupleExpr selectTree;
        if (root instanceof Slice) {
            Slice newSliceTree = (Slice)root.clone();
            newSliceTree.setArg(selectSubTree.clone());
            selectTree = newSliceTree;
        } else {
            selectTree = selectSubTree;
        }
        return new ParsedTupleQuery(selectTree);
    }
}

