/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.query.impl;

import it.unibz.inf.ontop.exception.OntopInvalidKGQueryException;
import it.unibz.inf.ontop.exception.OntopUnsupportedKGQueryException;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.query.KGQuery;
import it.unibz.inf.ontop.query.resultset.OBDAResultSet;
import it.unibz.inf.ontop.query.translation.KGQueryTranslator;
import it.unibz.inf.ontop.query.translation.RDF4JQueryTranslator;
import java.util.Objects;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.parser.ParsedQuery;

abstract class RDF4JKGQueryImpl<R extends OBDAResultSet>
implements KGQuery<R> {
    private final String inputQueryString;
    protected final BindingSet bindings;

    RDF4JKGQueryImpl(String inputQueryString, BindingSet bindings) {
        this.inputQueryString = inputQueryString;
        this.bindings = bindings;
    }

    @Override
    public String getOriginalString() {
        return this.inputQueryString;
    }

    @Override
    public IQ translate(KGQueryTranslator translator) throws OntopUnsupportedKGQueryException, OntopInvalidKGQueryException {
        if (!(translator instanceof RDF4JQueryTranslator)) {
            throw new IllegalArgumentException("RDF4JInputQueryImpl requires an RDF4JInputQueryTranslator");
        }
        return ((RDF4JQueryTranslator)translator).translateQuery(this.transformParsedQuery(), this.bindings);
    }

    protected abstract ParsedQuery transformParsedQuery() throws OntopUnsupportedKGQueryException;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RDF4JKGQueryImpl that = (RDF4JKGQueryImpl)o;
        return this.inputQueryString.equals(that.inputQueryString) && this.bindings.equals((Object)that.bindings);
    }

    public int hashCode() {
        return Objects.hash(this.inputQueryString, this.bindings);
    }
}

