/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.query.translation.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.exception.OntopUnsupportedKGQueryException;
import it.unibz.inf.ontop.model.term.GroundTerm;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbolFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.LangSPARQLFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.SPARQLFunctionSymbol;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.vocabulary.XPathFunction;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import it.unibz.inf.ontop.query.translation.impl.RDF4JValueTranslator;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDF;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.AbstractAggregateOperator;
import org.eclipse.rdf4j.query.algebra.AggregateFunctionCall;
import org.eclipse.rdf4j.query.algebra.And;
import org.eclipse.rdf4j.query.algebra.Avg;
import org.eclipse.rdf4j.query.algebra.BNodeGenerator;
import org.eclipse.rdf4j.query.algebra.BinaryValueOperator;
import org.eclipse.rdf4j.query.algebra.Bound;
import org.eclipse.rdf4j.query.algebra.Coalesce;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.query.algebra.Count;
import org.eclipse.rdf4j.query.algebra.Datatype;
import org.eclipse.rdf4j.query.algebra.FunctionCall;
import org.eclipse.rdf4j.query.algebra.GroupConcat;
import org.eclipse.rdf4j.query.algebra.IRIFunction;
import org.eclipse.rdf4j.query.algebra.If;
import org.eclipse.rdf4j.query.algebra.IsBNode;
import org.eclipse.rdf4j.query.algebra.IsLiteral;
import org.eclipse.rdf4j.query.algebra.IsNumeric;
import org.eclipse.rdf4j.query.algebra.IsURI;
import org.eclipse.rdf4j.query.algebra.Lang;
import org.eclipse.rdf4j.query.algebra.LangMatches;
import org.eclipse.rdf4j.query.algebra.ListMemberOperator;
import org.eclipse.rdf4j.query.algebra.MathExpr;
import org.eclipse.rdf4j.query.algebra.Max;
import org.eclipse.rdf4j.query.algebra.Min;
import org.eclipse.rdf4j.query.algebra.NAryValueOperator;
import org.eclipse.rdf4j.query.algebra.Not;
import org.eclipse.rdf4j.query.algebra.Or;
import org.eclipse.rdf4j.query.algebra.Regex;
import org.eclipse.rdf4j.query.algebra.SameTerm;
import org.eclipse.rdf4j.query.algebra.Sample;
import org.eclipse.rdf4j.query.algebra.Str;
import org.eclipse.rdf4j.query.algebra.Sum;
import org.eclipse.rdf4j.query.algebra.UnaryValueOperator;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;

public class RDF4JValueExprTranslator {
    private final Set<Variable> knownVariables;
    private final ImmutableMap<Variable, GroundTerm> externalBindings;
    private final boolean treatBNodeAsVariable;
    private final TermFactory termFactory;
    private final RDF rdfFactory;
    private final FunctionSymbolFactory functionSymbolFactory;
    private final RDF4JValueTranslator valueTranslator;
    private static final ImmutableMap<MathExpr.MathOp, String> NumericalOperations = ImmutableMap.builder().put((Object)MathExpr.MathOp.PLUS, (Object)"+").put((Object)MathExpr.MathOp.MINUS, (Object)"-").put((Object)MathExpr.MathOp.MULTIPLY, (Object)"*").put((Object)MathExpr.MathOp.DIVIDE, (Object)"/").build();

    public RDF4JValueExprTranslator(Set<Variable> knownVariables, ImmutableMap<Variable, GroundTerm> externalBindings, boolean treatBNodeAsVariable, TermFactory termFactory, RDF rdfFactory, TypeFactory typeFactory, FunctionSymbolFactory functionSymbolFactory) {
        this.knownVariables = knownVariables;
        this.externalBindings = externalBindings;
        this.treatBNodeAsVariable = treatBNodeAsVariable;
        this.termFactory = termFactory;
        this.rdfFactory = rdfFactory;
        this.functionSymbolFactory = functionSymbolFactory;
        this.valueTranslator = new RDF4JValueTranslator(termFactory, rdfFactory, typeFactory);
    }

    public ImmutableTerm getTerm(ValueExpr expr) {
        if (expr instanceof Var) {
            return this.translateRDF4JVar((Var)expr, false);
        }
        if (expr instanceof ValueConstant) {
            Value v = ((ValueConstant)expr).getValue();
            return this.valueTranslator.getTermForLiteralOrIri(v);
        }
        if (expr instanceof Bound) {
            Var v = ((Bound)expr).getArg();
            Variable var = this.termFactory.getVariable(v.getName());
            return this.knownVariables.contains(var) ? this.getFunctionalTerm("BOUND", (ImmutableTerm)var) : this.termFactory.getRDFLiteralConstant("false", XSD.BOOLEAN);
        }
        if (expr instanceof UnaryValueOperator) {
            return this.getTerm((UnaryValueOperator)expr);
        }
        if (expr instanceof BinaryValueOperator) {
            return this.getTerm((BinaryValueOperator)expr);
        }
        if (expr instanceof FunctionCall) {
            FunctionCall f = (FunctionCall)expr;
            ImmutableList terms = (ImmutableList)f.getArgs().stream().map(this::getTerm).collect(ImmutableCollectors.toList());
            String functionName = this.extractFunctionName(f.getURI());
            Optional optionalFunctionSymbol = this.functionSymbolFactory.getSPARQLFunctionSymbol(functionName, terms.size());
            if (optionalFunctionSymbol.isPresent()) {
                return this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)optionalFunctionSymbol.get(), terms);
            }
        }
        if (expr instanceof NAryValueOperator) {
            return this.getTerm((NAryValueOperator)expr);
        }
        if (expr instanceof BNodeGenerator) {
            Optional<ImmutableTerm> term = Optional.ofNullable(((BNodeGenerator)expr).getNodeIdExpr()).map(this::getTerm);
            return (ImmutableTerm)term.map(t -> this.getFunctionalTerm("BNODE", (ImmutableTerm)t)).orElseGet(() -> this.getFunctionalTerm("BNODE"));
        }
        if (expr instanceof If) {
            If ifExpr = (If)expr;
            return this.getFunctionalTerm("IF", this.convertToXsdBooleanTerm(this.getTerm(ifExpr.getCondition())), this.getTerm(ifExpr.getResult()), this.getTerm(ifExpr.getAlternative()));
        }
        throw new RuntimeException(new OntopUnsupportedKGQueryException("The expression " + expr + " is not supported yet!"));
    }

    private ImmutableTerm getTerm(UnaryValueOperator expr) {
        if (expr.getArg() == null) {
            if (expr instanceof Count) {
                return this.getFunctionalTerm("COUNT");
            }
            throw new RuntimeException(new OntopUnsupportedKGQueryException("The expression " + expr + " is not supported yet!"));
        }
        ImmutableTerm term = this.getTerm(expr.getArg());
        if (expr instanceof AbstractAggregateOperator) {
            AggregateFunctionCall call;
            AbstractAggregateOperator aggExpr = (AbstractAggregateOperator)expr;
            if (aggExpr instanceof Count) {
                return this.getAggregateFunctionalTerm("COUNT", aggExpr.isDistinct(), term);
            }
            if (aggExpr instanceof Avg) {
                return this.getAggregateFunctionalTerm("AVG", aggExpr.isDistinct(), term);
            }
            if (aggExpr instanceof Sum) {
                return this.getAggregateFunctionalTerm("SUM", aggExpr.isDistinct(), term);
            }
            if (aggExpr instanceof Min) {
                return this.getFunctionalTerm("MIN", term);
            }
            if (aggExpr instanceof Max) {
                return this.getFunctionalTerm("MAX", term);
            }
            if (aggExpr instanceof Sample) {
                return this.getFunctionalTerm("SAMPLE", term);
            }
            if (aggExpr instanceof GroupConcat) {
                String separator = Optional.ofNullable(((GroupConcat)aggExpr).getSeparator()).map(e -> ((ValueConstant)e).getValue().stringValue()).orElse(" ");
                return this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)this.functionSymbolFactory.getSPARQLGroupConcatFunctionSymbol(separator, aggExpr.isDistinct()), new ImmutableTerm[]{term});
            }
            if (aggExpr instanceof AggregateFunctionCall && (call = (AggregateFunctionCall)aggExpr).getIRI().startsWith("http://jena.apache.org/ARQ/function/aggregate#")) {
                return this.getAggregateFunctionalTerm(call.getIRI(), aggExpr.isDistinct(), term);
            }
            throw new RuntimeException("Unreachable: all subclasses covered");
        }
        if (expr instanceof Not) {
            return this.getFunctionalTerm(XPathFunction.NOT.getIRIString(), this.convertToXsdBooleanTerm(term));
        }
        if (expr instanceof IsNumeric) {
            return this.getFunctionalTerm("isNumeric", term);
        }
        if (expr instanceof IsLiteral) {
            return this.getFunctionalTerm("isLiteral", term);
        }
        if (expr instanceof IsURI) {
            return this.getFunctionalTerm("isIRI", term);
        }
        if (expr instanceof Str) {
            return this.getFunctionalTerm("STR", term);
        }
        if (expr instanceof Datatype) {
            return this.getFunctionalTerm("DATATYPE", term);
        }
        if (expr instanceof IsBNode) {
            return this.getFunctionalTerm("isBlank", term);
        }
        if (expr instanceof Lang) {
            if (expr.getArg() instanceof Var) {
                return this.getFunctionalTerm("LANG", term);
            }
            throw new RuntimeException(new OntopUnsupportedKGQueryException("A variable or a value is expected in " + expr));
        }
        if (expr instanceof IRIFunction) {
            Optional<IRI> optionalBaseIRI = Optional.ofNullable(((IRIFunction)expr).getBaseURI()).map(arg_0 -> ((RDF)this.rdfFactory).createIRI(arg_0));
            SPARQLFunctionSymbol functionSymbol = optionalBaseIRI.map(arg_0 -> ((FunctionSymbolFactory)this.functionSymbolFactory).getIRIFunctionSymbol(arg_0)).orElseGet(() -> ((FunctionSymbolFactory)this.functionSymbolFactory).getIRIFunctionSymbol());
            return this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)functionSymbol, new ImmutableTerm[]{term});
        }
        throw new RuntimeException(new OntopUnsupportedKGQueryException("The expression " + expr + " is not supported yet!"));
    }

    private ImmutableTerm getTerm(BinaryValueOperator expr) {
        ImmutableTerm term1 = this.getTerm(expr.getLeftArg());
        ImmutableTerm term2 = this.getTerm(expr.getRightArg());
        if (expr instanceof And) {
            return this.getFunctionalTerm("&&", this.convertToXsdBooleanTerm(term1), this.convertToXsdBooleanTerm(term2));
        }
        if (expr instanceof Or) {
            return this.getFunctionalTerm("||", this.convertToXsdBooleanTerm(term1), this.convertToXsdBooleanTerm(term2));
        }
        if (expr instanceof SameTerm) {
            return this.getFunctionalTerm("sameTerm", term1, term2);
        }
        if (expr instanceof Regex) {
            Regex reg = (Regex)expr;
            return reg.getFlagsArg() != null ? this.getFunctionalTerm("REGEX", term1, term2, this.getTerm(reg.getFlagsArg())) : this.getFunctionalTerm("REGEX", term1, term2);
        }
        if (expr instanceof Compare) {
            switch (((Compare)expr).getOperator()) {
                case EQ: {
                    return this.getFunctionalTerm("=", term1, term2);
                }
                case LT: {
                    return this.getFunctionalTerm("<", term1, term2);
                }
                case GT: {
                    return this.getFunctionalTerm(">", term1, term2);
                }
                case NE: {
                    return this.getFunctionalTerm(XPathFunction.NOT.getIRIString(), (ImmutableTerm)this.getFunctionalTerm("=", term1, term2));
                }
                case LE: {
                    return this.getFunctionalTerm(XPathFunction.NOT.getIRIString(), (ImmutableTerm)this.getFunctionalTerm(">", term1, term2));
                }
                case GE: {
                    return this.getFunctionalTerm(XPathFunction.NOT.getIRIString(), (ImmutableTerm)this.getFunctionalTerm("<", term1, term2));
                }
            }
            throw new RuntimeException(new OntopUnsupportedKGQueryException("Unsupported operator: " + expr));
        }
        if (expr instanceof MathExpr) {
            return this.getFunctionalTerm((String)NumericalOperations.get((Object)((MathExpr)expr).getOperator()), term1, term2);
        }
        if (expr instanceof LangMatches) {
            if (!(term1 instanceof ImmutableFunctionalTerm && ((ImmutableFunctionalTerm)term1).getFunctionSymbol() instanceof LangSPARQLFunctionSymbol && term2 instanceof RDFConstant)) {
                throw new RuntimeException(new OntopUnsupportedKGQueryException("The function langMatches is only supported with lang(..) function for the first argument and a constant for the second"));
            }
            return this.getFunctionalTerm("langMatches", term1, term2);
        }
        throw new RuntimeException("Unreachable: all subclasses covered");
    }

    private ImmutableTerm getTerm(NAryValueOperator expr) {
        ImmutableList terms = (ImmutableList)expr.getArguments().stream().map(this::getTerm).collect(ImmutableCollectors.toList());
        if (expr instanceof Coalesce) {
            SPARQLFunctionSymbol functionSymbol = this.functionSymbolFactory.getRequiredSPARQLFunctionSymbol("COALESCE", terms.size());
            return this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)functionSymbol, terms);
        }
        if (expr instanceof ListMemberOperator) {
            if (terms.size() < 2) {
                throw new MinorOntopInternalBugException("Was not expecting a ListMemberOperator from RDF4J with less than 2 terms");
            }
            ImmutableTerm firstArgument = (ImmutableTerm)terms.get(0);
            return (ImmutableTerm)terms.stream().skip(1L).map(t -> this.getFunctionalTerm("=", firstArgument, (ImmutableTerm)t)).reduce((e1, e2) -> this.getFunctionalTerm("||", (ImmutableTerm)e1, (ImmutableTerm)e2)).orElseThrow(() -> new MinorOntopInternalBugException("Cannot happen because there are at least 2 terms"));
        }
        throw new RuntimeException("Unreachable: all subclasses covered");
    }

    private ImmutableFunctionalTerm getFunctionalTerm(String functionName) {
        return this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)this.functionSymbolFactory.getRequiredSPARQLFunctionSymbol(functionName, 0), new ImmutableTerm[0]);
    }

    private ImmutableFunctionalTerm getFunctionalTerm(String functionName, ImmutableTerm t) {
        return this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)this.functionSymbolFactory.getRequiredSPARQLFunctionSymbol(functionName, 1), new ImmutableTerm[]{t});
    }

    private ImmutableFunctionalTerm getFunctionalTerm(String functionName, ImmutableTerm t1, ImmutableTerm t2) {
        return this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)this.functionSymbolFactory.getRequiredSPARQLFunctionSymbol(functionName, 2), new ImmutableTerm[]{t1, t2});
    }

    private ImmutableFunctionalTerm getFunctionalTerm(String functionName, ImmutableTerm t1, ImmutableTerm t2, ImmutableTerm t3) {
        return this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)this.functionSymbolFactory.getRequiredSPARQLFunctionSymbol(functionName, 3), new ImmutableTerm[]{t1, t2, t3});
    }

    private ImmutableFunctionalTerm getAggregateFunctionalTerm(String officialName, boolean isDistinct, ImmutableTerm t) {
        return this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)(isDistinct ? this.functionSymbolFactory.getRequiredSPARQLDistinctAggregateFunctionSymbol(officialName, 1) : this.functionSymbolFactory.getRequiredSPARQLFunctionSymbol(officialName, 1)), new ImmutableTerm[]{t});
    }

    private ImmutableTerm convertToXsdBooleanTerm(ImmutableTerm term) {
        return term.inferType().flatMap(TermTypeInference::getTermType).filter(t -> t instanceof RDFDatatype).map(t -> (RDFDatatype)t).filter(t -> t.isA(XSD.BOOLEAN)).isPresent() ? term : this.termFactory.getSPARQLEffectiveBooleanValue(term);
    }

    private String extractFunctionName(String uri) {
        if (uri.equals(XPathFunction.YEAR_FROM_DATETIME.getIRIString())) {
            return "YEAR";
        }
        if (uri.equals(XPathFunction.MONTH_FROM_DATETIME.getIRIString())) {
            return "MONTH";
        }
        if (uri.equals(XPathFunction.DAY_FROM_DATETIME.getIRIString())) {
            return "DAY";
        }
        return uri;
    }

    public VariableOrGroundTerm translateRDF4JVar(Var v, boolean leafNode) {
        if (v.hasValue()) {
            return this.valueTranslator.getTermForLiteralOrIri(v.getValue());
        }
        if (v.isAnonymous() && !this.treatBNodeAsVariable) {
            return this.termFactory.getConstantBNode(v.getName());
        }
        Variable var = this.termFactory.getVariable(v.getName());
        if (leafNode) {
            return var;
        }
        return this.knownVariables.contains(var) ? var : (VariableOrGroundTerm)Optional.ofNullable((GroundTerm)this.externalBindings.get((Object)var)).orElseGet(() -> ((TermFactory)this.termFactory).getNullConstant());
    }
}

