/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.query.translation.impl;

import it.unibz.inf.ontop.exception.OntopUnsupportedKGQueryException;
import it.unibz.inf.ontop.model.term.GroundTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TypeFactory;
import java.util.Optional;
import org.apache.commons.rdf.api.RDF;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;

public class RDF4JValueTranslator {
    private final TermFactory termFactory;
    private final RDF rdfFactory;
    private final TypeFactory typeFactory;

    public RDF4JValueTranslator(TermFactory termFactory, RDF rdfFactory, TypeFactory typeFactory) {
        this.termFactory = termFactory;
        this.rdfFactory = rdfFactory;
        this.typeFactory = typeFactory;
    }

    public GroundTerm getTermForLiteralOrIri(Value v) {
        if (v instanceof IRI) {
            return this.termFactory.getConstantIRI(this.rdfFactory.createIRI(((IRI)v).stringValue()));
        }
        if (v instanceof Literal) {
            RDFDatatype type;
            Literal literal = (Literal)v;
            IRI typeURI = literal.getDatatype();
            String value = literal.getLabel();
            Optional lang = literal.getLanguage();
            if (lang.isPresent()) {
                return this.termFactory.getRDFLiteralConstant(value, (String)lang.get());
            }
            RDFDatatype rDFDatatype = type = typeURI == null ? this.typeFactory.getXsdStringDatatype() : this.typeFactory.getDatatype(this.rdfFactory.createIRI(typeURI.stringValue()));
            if (type == null) {
                return this.termFactory.getConstantIRI(this.rdfFactory.createIRI(typeURI.stringValue()));
            }
            if (!XMLDatatypeUtil.isValidValue((String)value, (IRI)typeURI)) {
                throw new RuntimeException(new OntopUnsupportedKGQueryException(String.format("Invalid lexical forms are not accepted. Found for %s: %s", type, value)));
            }
            return this.termFactory.getRDFLiteralConstant(value, type);
        }
        throw new RuntimeException(new OntopUnsupportedKGQueryException("The value " + v + " is not supported yet!"));
    }
}

