/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.exception.RelationNotFoundInMetadataException;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.function.Function;

public class ImmutableMetadataLookup
implements MetadataLookup {
    protected final QuotedIDFactory idFactory;
    protected final ImmutableMap<RelationID, ? extends NamedRelationDefinition> map;

    ImmutableMetadataLookup(QuotedIDFactory idFactory, ImmutableMap<RelationID, ? extends NamedRelationDefinition> map) {
        this.idFactory = idFactory;
        this.map = map;
    }

    @Override
    public NamedRelationDefinition getRelation(RelationID id) throws MetadataExtractionException {
        NamedRelationDefinition relation = (NamedRelationDefinition)this.map.get((Object)id);
        if (relation == null) {
            throw new RelationNotFoundInMetadataException(id, (Collection<RelationID>)this.map.keySet());
        }
        return relation;
    }

    @Override
    public RelationDefinition getBlackBoxView(String query) {
        throw new UnsupportedOperationException();
    }

    @Override
    public QuotedIDFactory getQuotedIDFactory() {
        return this.idFactory;
    }

    protected ImmutableList<NamedRelationDefinition> getRelations() {
        return (ImmutableList)this.map.values().stream().collect(ImmutableCollectors.toMultimap(NamedRelationDefinition::getAllIDs, Function.identity())).asMap().values().stream().map(s -> (NamedRelationDefinition)s.iterator().next()).collect(ImmutableCollectors.toList());
    }
}

