/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.CompositeIQTree;
import it.unibz.inf.ontop.iq.ConcreteIQTreeCache;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.IQTreeCache;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.iq.impl.IQTreeTools;
import it.unibz.inf.ontop.iq.node.ExplicitVariableProjectionNode;
import it.unibz.inf.ontop.iq.node.FlattenNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.request.FunctionalDependencies;
import it.unibz.inf.ontop.iq.request.VariableNonRequirement;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public abstract class AbstractCompositeIQTree<N extends QueryNode>
implements CompositeIQTree<N> {
    private final N rootNode;
    private final ImmutableList<IQTree> children;
    private final ConcreteIQTreeCache treeCache;
    private static final String TAB_STR = "   ";
    private @Nullable ImmutableSet<Variable> knownVariables;
    private @Nullable String string;
    private boolean hasBeenSuccessfullyValidate;
    protected final IQTreeTools iqTreeTools;
    protected final IntermediateQueryFactory iqFactory;
    private final TermFactory termFactory;
    private final SubstitutionFactory substitutionFactory;

    protected AbstractCompositeIQTree(N rootNode, ImmutableList<IQTree> children, IQTreeCache treeCache, IQTreeTools iqTreeTools, IntermediateQueryFactory iqFactory, TermFactory termFactory, SubstitutionFactory substitutionFactory) {
        this.iqTreeTools = iqTreeTools;
        this.iqFactory = iqFactory;
        this.termFactory = termFactory;
        this.substitutionFactory = substitutionFactory;
        if (children.isEmpty()) {
            throw new IllegalArgumentException("A composite IQ must have at least one child");
        }
        this.rootNode = rootNode;
        this.children = children;
        if (!(treeCache instanceof ConcreteIQTreeCache)) {
            throw new IllegalArgumentException("Was expecting the tree cache to be instance of ConcreteIQTreeCache");
        }
        this.treeCache = (ConcreteIQTreeCache)treeCache;
        this.knownVariables = null;
        this.hasBeenSuccessfullyValidate = false;
    }

    @Override
    public N getRootNode() {
        return this.rootNode;
    }

    @Override
    public ImmutableList<IQTree> getChildren() {
        return this.children;
    }

    @Override
    public synchronized ImmutableSet<Variable> getVariables() {
        ImmutableSet<Variable> variables = this.treeCache.getVariables();
        if (variables != null) {
            return variables;
        }
        variables = this.computeVariables();
        this.treeCache.setVariables(variables);
        return variables;
    }

    protected ImmutableSet<Variable> computeVariables() {
        if (this.rootNode instanceof ExplicitVariableProjectionNode) {
            return ((ExplicitVariableProjectionNode)this.rootNode).getVariables();
        }
        ImmutableSet childVariables = (ImmutableSet)this.children.stream().flatMap(c -> c.getVariables().stream()).collect(ImmutableCollectors.toSet());
        if (this.rootNode instanceof FlattenNode) {
            return ((FlattenNode)this.rootNode).getVariables((ImmutableSet<Variable>)childVariables);
        }
        return childVariables;
    }

    @Override
    public ImmutableSet<Variable> getKnownVariables() {
        if (this.knownVariables == null) {
            this.knownVariables = (ImmutableSet)Stream.concat(this.getRootNode().getLocalVariables().stream(), this.getChildren().stream().flatMap(c -> c.getKnownVariables().stream())).collect(ImmutableCollectors.toSet());
        }
        return this.knownVariables;
    }

    public String toString() {
        if (this.string == null) {
            this.string = AbstractCompositeIQTree.printSubtree(this, "");
        }
        return this.string;
    }

    private static String printSubtree(IQTree subTree, String offset) {
        String childOffset = offset + TAB_STR;
        return offset + subTree.getRootNode() + "\n" + subTree.getChildren().stream().map(c -> AbstractCompositeIQTree.printSubtree(c, childOffset)).reduce("", (c, a) -> c + a);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractCompositeIQTree other = (AbstractCompositeIQTree)o;
        return this.rootNode.equals(other.rootNode) && this.children.equals(other.children);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    protected Optional<Substitution<? extends VariableOrGroundTerm>> normalizeDescendingSubstitution(Substitution<? extends VariableOrGroundTerm> descendingSubstitution) throws IQTreeTools.UnsatisfiableDescendingSubstitutionException {
        return this.iqTreeTools.normalizeDescendingSubstitution(this, descendingSubstitution);
    }

    @Override
    public IQTree applyDescendingSubstitution(Substitution<? extends VariableOrGroundTerm> descendingSubstitution, Optional<ImmutableExpression> constraint, VariableGenerator variableGenerator) {
        ImmutableSet<Variable> variables = this.getVariables();
        try {
            Optional<Substitution<VariableOrGroundTerm>> normalizedSubstitution = this.normalizeDescendingSubstitution(descendingSubstitution);
            Optional<ImmutableExpression> newConstraint = this.normalizeConstraint(constraint, descendingSubstitution);
            return normalizedSubstitution.flatMap(s -> this.iqTreeTools.extractFreshRenaming((Substitution<? extends ImmutableTerm>)s, variables)).map(s -> this.applyFreshRenaming((InjectiveSubstitution<Variable>)s, true)).map(t -> newConstraint.map(c -> t.propagateDownConstraint((ImmutableExpression)c, variableGenerator)).orElse((IQTree)t)).orElseGet(() -> normalizedSubstitution.map(s -> this.applyRegularDescendingSubstitution((Substitution<? extends VariableOrGroundTerm>)s, newConstraint, variableGenerator)).orElseGet(() -> newConstraint.map(c -> this.propagateDownConstraint((ImmutableExpression)c, variableGenerator)).orElse(this)));
        }
        catch (IQTreeTools.UnsatisfiableDescendingSubstitutionException e) {
            return this.iqFactory.createEmptyNode(this.iqTreeTools.computeNewProjectedVariables(descendingSubstitution, variables));
        }
    }

    @Override
    public IQTree applyFreshRenaming(InjectiveSubstitution<Variable> freshRenamingSubstitution) {
        return this.applyFreshRenaming(freshRenamingSubstitution, false);
    }

    private Optional<ImmutableExpression> normalizeConstraint(Optional<ImmutableExpression> constraint, Substitution<? extends VariableOrGroundTerm> descendingSubstitution) {
        if (!constraint.isPresent()) {
            return constraint;
        }
        ImmutableSet newVariables = (ImmutableSet)this.getVariables().stream().map(v -> this.substitutionFactory.onVariableOrGroundTerms().apply((Substitution<VariableOrGroundTerm>)descendingSubstitution, (Variable)v)).filter(t -> t instanceof Variable).map(t -> (Variable)t).collect(ImmutableCollectors.toSet());
        return this.termFactory.getConjunction(constraint.get().flattenAND().filter(e -> e.getVariableStream().anyMatch(arg_0 -> ((ImmutableSet)newVariables).contains(arg_0))));
    }

    protected abstract IQTree applyFreshRenaming(InjectiveSubstitution<Variable> var1, boolean var2);

    protected abstract IQTree applyRegularDescendingSubstitution(Substitution<? extends VariableOrGroundTerm> var1, Optional<ImmutableExpression> var2, VariableGenerator var3);

    @Override
    public final void validate() throws InvalidIntermediateQueryException {
        if (!this.hasBeenSuccessfullyValidate) {
            this.validateNode();
            this.children.forEach(IQTree::validate);
            this.hasBeenSuccessfullyValidate = true;
        }
    }

    protected abstract void validateNode() throws InvalidIntermediateQueryException;

    @Override
    public synchronized VariableNullability getVariableNullability() {
        VariableNullability variableNullability = this.treeCache.getVariableNullability();
        if (variableNullability != null) {
            return variableNullability;
        }
        variableNullability = this.computeVariableNullability();
        this.treeCache.setVariableNullability(variableNullability);
        return variableNullability;
    }

    protected abstract VariableNullability computeVariableNullability();

    protected IQTreeCache getTreeCache() {
        return this.treeCache;
    }

    @Override
    public synchronized ImmutableSet<Substitution<NonVariableTerm>> getPossibleVariableDefinitions() {
        ImmutableSet<Substitution<NonVariableTerm>> possibleVariableDefinitions = this.treeCache.getPossibleVariableDefinitions();
        if (possibleVariableDefinitions == null) {
            possibleVariableDefinitions = this.computePossibleVariableDefinitions();
            this.treeCache.setPossibleVariableDefinitions(possibleVariableDefinitions);
        }
        return possibleVariableDefinitions;
    }

    protected abstract ImmutableSet<Substitution<NonVariableTerm>> computePossibleVariableDefinitions();

    @Override
    public synchronized ImmutableSet<ImmutableSet<Variable>> inferUniqueConstraints() {
        ImmutableSet<ImmutableSet<Variable>> uniqueConstraints = this.treeCache.getUniqueConstraints();
        if (uniqueConstraints == null) {
            uniqueConstraints = this.computeUniqueConstraints();
            this.treeCache.setUniqueConstraints(uniqueConstraints);
        }
        return uniqueConstraints;
    }

    protected abstract ImmutableSet<ImmutableSet<Variable>> computeUniqueConstraints();

    @Override
    public synchronized FunctionalDependencies inferFunctionalDependencies() {
        FunctionalDependencies dependencies = this.treeCache.getFunctionalDependencies();
        if (dependencies == null) {
            dependencies = this.computeFunctionalDependencies();
            this.treeCache.setFunctionalDependencies(dependencies);
        }
        return dependencies;
    }

    protected abstract FunctionalDependencies computeFunctionalDependencies();

    @Override
    public synchronized VariableNonRequirement getVariableNonRequirement() {
        VariableNonRequirement notInternallyRequiredVariables = this.treeCache.getVariableNonRequirement();
        if (notInternallyRequiredVariables != null) {
            return notInternallyRequiredVariables;
        }
        notInternallyRequiredVariables = this.computeVariableNonRequirement();
        this.treeCache.setVariableNonRequirement(notInternallyRequiredVariables);
        return notInternallyRequiredVariables;
    }

    protected abstract VariableNonRequirement computeVariableNonRequirement();

    @Override
    public boolean isDistinct() {
        Boolean isDistinct = this.treeCache.isDistinct();
        if (isDistinct == null) {
            isDistinct = this.computeIsDistinct();
            this.treeCache.setIsDistinct(isDistinct);
        }
        return isDistinct;
    }

    protected abstract boolean computeIsDistinct();
}

