/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.impl;

import com.google.common.collect.ImmutableSet;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.iq.ConcreteIQTreeCache;
import it.unibz.inf.ontop.iq.IQTreeCache;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.request.FunctionalDependencies;
import it.unibz.inf.ontop.iq.request.VariableNonRequirement;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class ConcreteIQTreeCacheImpl
implements ConcreteIQTreeCache {
    private final boolean isNormalizedForOptimization;
    private final boolean areDistinctAlreadyRemoved;
    private final CoreSingletons coreSingletons;
    private final SubstitutionFactory substitutionFactory;
    private @Nullable VariableNullability variableNullability;
    private @Nullable ImmutableSet<Variable> variables;
    private @Nullable VariableNonRequirement variableNonRequirement;
    private @Nullable ImmutableSet<Substitution<NonVariableTerm>> possibleVariableDefinitions;
    private @Nullable ImmutableSet<ImmutableSet<Variable>> uniqueConstraints;
    private @Nullable FunctionalDependencies functionalDependencies;
    private @Nullable Boolean isDistinct;

    @Inject
    @AssistedInject
    private ConcreteIQTreeCacheImpl(CoreSingletons coreSingletons) {
        this(false, coreSingletons);
    }

    @AssistedInject
    private ConcreteIQTreeCacheImpl(@Assisted boolean isNormalizedForOptimization, CoreSingletons coreSingletons) {
        this.coreSingletons = coreSingletons;
        this.substitutionFactory = coreSingletons.getSubstitutionFactory();
        this.isNormalizedForOptimization = isNormalizedForOptimization;
        this.areDistinctAlreadyRemoved = false;
    }

    protected ConcreteIQTreeCacheImpl(CoreSingletons coreSingletons, boolean isNormalizedForOptimization, boolean areDistinctAlreadyRemoved, @Nullable VariableNullability variableNullability, @Nullable ImmutableSet<Variable> variables, @Nullable VariableNonRequirement variableNonRequirement, @Nullable ImmutableSet<Substitution<NonVariableTerm>> possibleVariableDefinitions, @Nullable ImmutableSet<ImmutableSet<Variable>> uniqueConstraints, @Nullable FunctionalDependencies functionalDependencies, @Nullable Boolean isDistinct) {
        this.isNormalizedForOptimization = isNormalizedForOptimization;
        this.areDistinctAlreadyRemoved = areDistinctAlreadyRemoved;
        this.coreSingletons = coreSingletons;
        this.substitutionFactory = coreSingletons.getSubstitutionFactory();
        this.variableNullability = variableNullability;
        this.variables = variables;
        this.variableNonRequirement = variableNonRequirement;
        this.possibleVariableDefinitions = possibleVariableDefinitions;
        this.uniqueConstraints = uniqueConstraints;
        this.functionalDependencies = functionalDependencies;
        this.isDistinct = isDistinct;
    }

    @Override
    public boolean isNormalizedForOptimization() {
        return this.isNormalizedForOptimization;
    }

    @Override
    public boolean areDistinctAlreadyRemoved() {
        return this.areDistinctAlreadyRemoved;
    }

    @Override
    public @Nullable ImmutableSet<Variable> getVariables() {
        return this.variables;
    }

    @Override
    public @Nullable VariableNonRequirement getVariableNonRequirement() {
        return this.variableNonRequirement;
    }

    @Override
    public @Nullable VariableNullability getVariableNullability() {
        return this.variableNullability;
    }

    @Override
    public @Nullable ImmutableSet<Substitution<NonVariableTerm>> getPossibleVariableDefinitions() {
        return this.possibleVariableDefinitions;
    }

    @Override
    public @Nullable ImmutableSet<ImmutableSet<Variable>> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    @Override
    public @Nullable FunctionalDependencies getFunctionalDependencies() {
        return this.functionalDependencies;
    }

    @Override
    public @Nullable Boolean isDistinct() {
        return this.isDistinct;
    }

    @Override
    public void setVariables(@Nonnull ImmutableSet<Variable> variables) {
        this.variables = variables;
    }

    @Override
    public void setVariableNonRequirement(@Nonnull VariableNonRequirement variableNonRequirement) {
        this.variableNonRequirement = variableNonRequirement;
    }

    @Override
    public IQTreeCache declareAsNormalizedForOptimizationWithoutEffect() {
        return new ConcreteIQTreeCacheImpl(this.coreSingletons, true, this.areDistinctAlreadyRemoved, this.variableNullability, this.variables, this.variableNonRequirement, this.possibleVariableDefinitions, this.uniqueConstraints, this.functionalDependencies, this.isDistinct);
    }

    @Override
    public IQTreeCache declareAsNormalizedForOptimizationWithEffect() {
        return new ConcreteIQTreeCacheImpl(this.coreSingletons, true, this.areDistinctAlreadyRemoved, null, null, null, null, null, null, null);
    }

    @Override
    public IQTreeCache declareConstraintPushedDownWithEffect() {
        return new ConcreteIQTreeCacheImpl(this.coreSingletons, false, this.areDistinctAlreadyRemoved, null, this.variables, null, null, null, null, null);
    }

    @Override
    public IQTreeCache declareDistinctRemoval(boolean noEffect) {
        return noEffect ? new ConcreteIQTreeCacheImpl(this.coreSingletons, this.isNormalizedForOptimization, true, this.variableNullability, this.variables, this.variableNonRequirement, this.possibleVariableDefinitions, this.uniqueConstraints, this.functionalDependencies, this.isDistinct) : new ConcreteIQTreeCacheImpl(this.coreSingletons, false, true, this.variableNullability, this.variables, null, this.possibleVariableDefinitions, null, null, null);
    }

    @Override
    public synchronized void setVariableNullability(@Nonnull VariableNullability variableNullability) {
        if (this.variableNullability != null) {
            throw new IllegalStateException("Variable nullability already present. Only call this method once");
        }
        this.variableNullability = variableNullability;
    }

    @Override
    public synchronized void setPossibleVariableDefinitions(@Nonnull ImmutableSet<Substitution<NonVariableTerm>> possibleVariableDefinitions) {
        if (this.possibleVariableDefinitions != null) {
            throw new IllegalStateException("Possible variable definitions already present. Only call this method once");
        }
        this.possibleVariableDefinitions = possibleVariableDefinitions;
    }

    @Override
    public void setUniqueConstraints(@Nonnull ImmutableSet<ImmutableSet<Variable>> uniqueConstraints) {
        if (this.uniqueConstraints != null) {
            throw new IllegalStateException("Unique constraints already present. Only call this method once");
        }
        this.uniqueConstraints = uniqueConstraints;
    }

    @Override
    public void setFunctionalDependencies(@Nonnull FunctionalDependencies functionalDependencies) {
        if (this.functionalDependencies != null) {
            throw new IllegalStateException("Functional dependencies already present. Only call this method once");
        }
        this.functionalDependencies = functionalDependencies;
    }

    @Override
    public void setIsDistinct(@Nonnull Boolean isDistinct) {
        if (this.isDistinct != null) {
            throw new IllegalStateException("Distinct information is already present. Only call this method once");
        }
        this.isDistinct = isDistinct;
    }

    @Override
    public IQTreeCache applyFreshRenaming(InjectiveSubstitution<Variable> renamingSubstitution) {
        VariableNullability newVariableNullability = this.variableNullability == null ? null : this.variableNullability.applyFreshRenaming(renamingSubstitution);
        ImmutableSet<Variable> newVariables = this.variables == null ? null : this.substitutionFactory.apply(renamingSubstitution, this.variables);
        VariableNonRequirement newNotInternallyRequiredVariables = this.variableNonRequirement == null ? null : this.variableNonRequirement.rename(renamingSubstitution, this.substitutionFactory);
        ImmutableSet newPossibleDefinitions = this.possibleVariableDefinitions == null ? null : (ImmutableSet)this.possibleVariableDefinitions.stream().map(s -> this.substitutionFactory.onNonVariableTerms().rename(renamingSubstitution, (Substitution<NonVariableTerm>)s)).collect(ImmutableCollectors.toSet());
        ImmutableSet newUniqueConstraints = this.uniqueConstraints == null ? null : (ImmutableSet)this.uniqueConstraints.stream().map(s -> this.substitutionFactory.apply((Substitution<Variable>)renamingSubstitution, (ImmutableSet<Variable>)s)).collect(ImmutableCollectors.toSet());
        FunctionalDependencies newFunctionalDependencies = this.functionalDependencies == null ? null : this.functionalDependencies.rename(renamingSubstitution, this.substitutionFactory);
        return new ConcreteIQTreeCacheImpl(this.coreSingletons, this.isNormalizedForOptimization, this.areDistinctAlreadyRemoved, newVariableNullability, newVariables, newNotInternallyRequiredVariables, (ImmutableSet<Substitution<NonVariableTerm>>)newPossibleDefinitions, (ImmutableSet<ImmutableSet<Variable>>)newUniqueConstraints, newFunctionalDependencies, this.isDistinct);
    }
}

