/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.evaluator.TermNullabilityEvaluator;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.IQTreeCache;
import it.unibz.inf.ontop.iq.NaryIQTree;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.iq.exception.QueryNodeTransformationException;
import it.unibz.inf.ontop.iq.impl.IQTreeTools;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.QueryNodeVisitor;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.JoinLikeNodeImpl;
import it.unibz.inf.ontop.iq.node.impl.JoinOrFilterVariableNullabilityTools;
import it.unibz.inf.ontop.iq.node.impl.UnsatisfiableConditionException;
import it.unibz.inf.ontop.iq.node.normalization.ConditionSimplifier;
import it.unibz.inf.ontop.iq.node.normalization.InnerJoinNormalizer;
import it.unibz.inf.ontop.iq.request.FunctionalDependencies;
import it.unibz.inf.ontop.iq.request.VariableNonRequirement;
import it.unibz.inf.ontop.iq.transform.IQTreeExtendedTransformer;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.node.HomogeneousQueryNodeTransformer;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class InnerJoinNodeImpl
extends JoinLikeNodeImpl
implements InnerJoinNode {
    private static final String JOIN_NODE_STR = "JOIN";
    private final InnerJoinNormalizer normalizer;

    @AssistedInject
    protected InnerJoinNodeImpl(@Assisted Optional<ImmutableExpression> optionalFilterCondition, TermNullabilityEvaluator nullabilityEvaluator, TermFactory termFactory, TypeFactory typeFactory, IntermediateQueryFactory iqFactory, SubstitutionFactory substitutionFactory, IQTreeTools iqTreeTools, JoinOrFilterVariableNullabilityTools variableNullabilityTools, ConditionSimplifier conditionSimplifier, InnerJoinNormalizer normalizer) {
        super(optionalFilterCondition, nullabilityEvaluator, termFactory, iqFactory, typeFactory, substitutionFactory, variableNullabilityTools, conditionSimplifier, iqTreeTools);
        this.normalizer = normalizer;
    }

    @AssistedInject
    private InnerJoinNodeImpl(@Assisted ImmutableExpression joiningCondition, TermNullabilityEvaluator nullabilityEvaluator, TermFactory termFactory, TypeFactory typeFactory, IntermediateQueryFactory iqFactory, SubstitutionFactory substitutionFactory, IQTreeTools iqTreeTools, JoinOrFilterVariableNullabilityTools variableNullabilityTools, ConditionSimplifier conditionSimplifier, InnerJoinNormalizer normalizer) {
        this(Optional.of(joiningCondition), nullabilityEvaluator, termFactory, typeFactory, iqFactory, substitutionFactory, iqTreeTools, variableNullabilityTools, conditionSimplifier, normalizer);
    }

    @AssistedInject
    private InnerJoinNodeImpl(TermNullabilityEvaluator nullabilityEvaluator, TermFactory termFactory, TypeFactory typeFactory, IntermediateQueryFactory iqFactory, SubstitutionFactory substitutionFactory, IQTreeTools iqTreeTools, JoinOrFilterVariableNullabilityTools variableNullabilityTools, ConditionSimplifier conditionSimplifier, InnerJoinNormalizer normalizer) {
        this(Optional.empty(), nullabilityEvaluator, termFactory, typeFactory, iqFactory, substitutionFactory, iqTreeTools, variableNullabilityTools, conditionSimplifier, normalizer);
    }

    @Override
    public void acceptVisitor(QueryNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public InnerJoinNode acceptNodeTransformer(HomogeneousQueryNodeTransformer transformer) throws QueryNodeTransformationException {
        return transformer.transform(this);
    }

    @Override
    public ImmutableSet<Substitution<NonVariableTerm>> getPossibleVariableDefinitions(ImmutableList<IQTree> children) {
        return children.stream().map(IQTree::getPossibleVariableDefinitions).filter(s -> !s.isEmpty()).reduce(ImmutableSet.of(), this::combineVarDefs);
    }

    private ImmutableSet<Substitution<NonVariableTerm>> combineVarDefs(ImmutableSet<Substitution<NonVariableTerm>> s1, ImmutableSet<Substitution<NonVariableTerm>> s2) {
        return s1.isEmpty() ? s2 : (ImmutableSet)s1.stream().flatMap(d1 -> s2.stream().map(d2 -> this.substitutionFactory.onNonVariableTerms().compose((Substitution<NonVariableTerm>)d2, (Substitution<NonVariableTerm>)d1))).collect(ImmutableCollectors.toSet());
    }

    @Override
    public InnerJoinNode changeOptionalFilterCondition(Optional<ImmutableExpression> newOptionalFilterCondition) {
        return this.iqFactory.createInnerJoinNode(newOptionalFilterCondition);
    }

    @Override
    public int hashCode() {
        return this.getOptionalFilterCondition().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InnerJoinNodeImpl) {
            InnerJoinNodeImpl that = (InnerJoinNodeImpl)o;
            return this.getOptionalFilterCondition().equals(that.getOptionalFilterCondition());
        }
        return false;
    }

    public String toString() {
        return JOIN_NODE_STR + this.getOptionalFilterString();
    }

    @Override
    public IQTree normalizeForOptimization(ImmutableList<IQTree> children, VariableGenerator variableGenerator, IQTreeCache treeCache) {
        return this.normalizer.normalizeForOptimization(this, children, variableGenerator, treeCache);
    }

    @Override
    public IQTree applyDescendingSubstitution(Substitution<? extends VariableOrGroundTerm> descendingSubstitution, Optional<ImmutableExpression> constraint, ImmutableList<IQTree> children, VariableGenerator variableGenerator) {
        Optional<ImmutableExpression> unoptimizedExpression = this.getOptionalFilterCondition().map(descendingSubstitution::apply);
        VariableNullability simplifiedChildFutureVariableNullability = this.variableNullabilityTools.getSimplifiedVariableNullability(this.iqTreeTools.computeNewProjectedVariables(descendingSubstitution, this.iqTreeTools.getChildrenVariables(children)));
        VariableNullability extendedVariableNullability = constraint.map(c -> simplifiedChildFutureVariableNullability.extendToExternalVariables(c.getVariableStream())).orElse(simplifiedChildFutureVariableNullability);
        try {
            ConditionSimplifier.ExpressionAndSubstitution expressionAndSubstitution = this.conditionSimplifier.simplifyCondition(unoptimizedExpression, (ImmutableSet<Variable>)ImmutableSet.of(), children, simplifiedChildFutureVariableNullability);
            Optional<ImmutableExpression> downConstraint = this.conditionSimplifier.computeDownConstraint(constraint, expressionAndSubstitution, extendedVariableNullability);
            Substitution<VariableOrGroundTerm> downSubstitution = this.substitutionFactory.onVariableOrGroundTerms().compose(descendingSubstitution, expressionAndSubstitution.getSubstitution());
            ImmutableList newChildren = (ImmutableList)children.stream().map(c -> c.applyDescendingSubstitution(downSubstitution, downConstraint, variableGenerator)).collect(ImmutableCollectors.toList());
            NaryIQTree joinTree = this.iqFactory.createNaryIQTree(this.iqFactory.createInnerJoinNode(expressionAndSubstitution.getOptionalExpression()), (ImmutableList<IQTree>)newChildren);
            return this.iqTreeTools.createConstructionNodeTreeIfNontrivial(joinTree, expressionAndSubstitution.getSubstitution(), () -> this.iqTreeTools.computeNewProjectedVariables(descendingSubstitution, this.iqTreeTools.getChildrenVariables(children)));
        }
        catch (UnsatisfiableConditionException e) {
            return this.iqFactory.createEmptyNode(this.iqTreeTools.computeNewProjectedVariables(descendingSubstitution, this.iqTreeTools.getChildrenVariables(children)));
        }
    }

    @Override
    public IQTree applyDescendingSubstitutionWithoutOptimizing(Substitution<? extends VariableOrGroundTerm> descendingSubstitution, ImmutableList<IQTree> children, VariableGenerator variableGenerator) {
        InnerJoinNode newJoinNode = this.iqTreeTools.createInnerJoinNode(this.getOptionalFilterCondition().map(descendingSubstitution::apply));
        ImmutableList newChildren = (ImmutableList)children.stream().map(c -> c.applyDescendingSubstitutionWithoutOptimizing(descendingSubstitution, variableGenerator)).collect(ImmutableCollectors.toList());
        return this.iqFactory.createNaryIQTree(newJoinNode, (ImmutableList<IQTree>)newChildren);
    }

    @Override
    public IQTree applyFreshRenaming(InjectiveSubstitution<Variable> renamingSubstitution, ImmutableList<IQTree> children, IQTreeCache treeCache) {
        ImmutableList newChildren = (ImmutableList)children.stream().map(c -> c.applyFreshRenaming(renamingSubstitution)).collect(ImmutableCollectors.toList());
        Optional<ImmutableExpression> newCondition = this.getOptionalFilterCondition().map(renamingSubstitution::apply);
        InnerJoinNodeImpl newJoinNode = newCondition.equals(this.getOptionalFilterCondition()) ? this : this.iqFactory.createInnerJoinNode(newCondition);
        IQTreeCache newTreeCache = treeCache.applyFreshRenaming(renamingSubstitution);
        return this.iqFactory.createNaryIQTree(newJoinNode, (ImmutableList<IQTree>)newChildren, newTreeCache);
    }

    @Override
    public VariableNullability getVariableNullability(ImmutableList<IQTree> children) {
        return this.variableNullabilityTools.getVariableNullability(children, this.getOptionalFilterCondition());
    }

    @Override
    public boolean isConstructed(Variable variable, ImmutableList<IQTree> children) {
        return children.stream().anyMatch(c -> c.isConstructed(variable));
    }

    @Override
    public boolean isDistinct(IQTree tree, ImmutableList<IQTree> children) {
        return super.isDistinct(tree, children);
    }

    @Override
    public IQTree liftIncompatibleDefinitions(Variable variable, ImmutableList<IQTree> children, VariableGenerator variableGenerator) {
        return IntStream.range(0, children.size()).mapToObj(i -> Maps.immutableEntry((Object)i, (Object)((IQTree)children.get(i)))).filter(e -> ((IQTree)e.getValue()).isConstructed(variable)).map(e -> Maps.immutableEntry((Object)((Integer)e.getKey()), (Object)((IQTree)e.getValue()).liftIncompatibleDefinitions(variable, variableGenerator))).filter(e -> {
            QueryNode newRootNode = ((IQTree)e.getValue()).getRootNode();
            return newRootNode instanceof UnionNode && ((UnionNode)newRootNode).hasAChildWithLiftableDefinition(variable, ((IQTree)e.getValue()).getChildren());
        }).findFirst().map(e -> this.liftUnionChild((Integer)e.getKey(), (NaryIQTree)e.getValue(), children, variableGenerator)).orElseGet(() -> this.iqFactory.createNaryIQTree(this, children));
    }

    @Override
    public IQTree acceptTransformer(IQTree tree, IQTreeVisitingTransformer transformer, ImmutableList<IQTree> children) {
        return transformer.transformInnerJoin(tree, this, children);
    }

    @Override
    public <T> IQTree acceptTransformer(IQTree tree, IQTreeExtendedTransformer<T> transformer, ImmutableList<IQTree> children, T context) {
        return transformer.transformInnerJoin(tree, this, children, context);
    }

    @Override
    public <T> T acceptVisitor(IQVisitor<T> visitor, ImmutableList<IQTree> children) {
        return visitor.visitInnerJoin(this, children);
    }

    @Override
    public void validateNode(ImmutableList<IQTree> children) throws InvalidIntermediateQueryException {
        if (children.size() < 2) {
            throw new InvalidIntermediateQueryException("JOIN node " + this + " does not have at least 2 children.\n" + children);
        }
        this.getOptionalFilterCondition().ifPresent(e -> this.checkExpression((ImmutableExpression)e, children));
        this.checkNonProjectedVariables(children);
    }

    @Override
    public IQTree removeDistincts(ImmutableList<IQTree> children, IQTreeCache treeCache) {
        ImmutableList newChildren = (ImmutableList)children.stream().map(IQTree::removeDistincts).collect(ImmutableCollectors.toList());
        IQTreeCache newTreeCache = treeCache.declareDistinctRemoval(newChildren.equals(children));
        return this.iqFactory.createNaryIQTree(this, (ImmutableList<IQTree>)newChildren, newTreeCache);
    }

    @Override
    public ImmutableSet<ImmutableSet<Variable>> inferUniqueConstraints(ImmutableList<IQTree> children) {
        ImmutableSet childrenSet = ImmutableSet.copyOf(children);
        ImmutableMap<IQTree, ImmutableSet> constraintMap = childrenSet.stream().collect(ImmutableCollectors.toMap(c -> c, IQTree::inferUniqueConstraints));
        if (constraintMap.values().stream().anyMatch(AbstractCollection::isEmpty)) {
            return ImmutableSet.of();
        }
        ImmutableSet<ImmutableSet<Variable>> naturalJoinConstraints = this.extractConstraintsOverNaturalJoins(children, (ImmutableSet<IQTree>)childrenSet, constraintMap);
        ImmutableSet<ImmutableSet<Variable>> combinedConstraints = this.extractCombinedConstraints((ImmutableCollection<ImmutableSet<ImmutableSet<Variable>>>)constraintMap.values(), this.getVariableNullability(children));
        return this.removeRedundantConstraints((Set<ImmutableSet<Variable>>)Sets.union(naturalJoinConstraints, combinedConstraints));
    }

    private ImmutableSet<ImmutableSet<Variable>> extractConstraintsOverNaturalJoins(ImmutableList<IQTree> children, ImmutableSet<IQTree> childrenSet, ImmutableMap<IQTree, ImmutableSet<ImmutableSet<Variable>>> childConstraintMap) {
        ImmutableMultimap directDependencyMap = IntStream.range(0, children.size() - 1).boxed().flatMap(i -> IntStream.range(i + 1, children.size()).boxed().flatMap(j -> this.extractFunctionalDependencies((IQTree)children.get(i.intValue()), (IQTree)children.get(j.intValue()), childConstraintMap))).collect(ImmutableCollectors.toMultimap());
        Multimap<IQTree, IQTree> saturatedDependencyMap = this.saturateDependencies(directDependencyMap);
        return (ImmutableSet)saturatedDependencyMap.asMap().entrySet().stream().filter(e -> ((Collection)e.getValue()).containsAll((Collection<?>)Sets.difference((Set)childrenSet, (Set)ImmutableSet.of((Object)((IQTree)e.getKey()))))).map(Map.Entry::getKey).flatMap(child -> ((ImmutableSet)childConstraintMap.get(child)).stream()).collect(ImmutableCollectors.toSet());
    }

    private ImmutableSet<ImmutableSet<Variable>> extractCombinedConstraints(ImmutableCollection<ImmutableSet<ImmutableSet<Variable>>> childConstraints, VariableNullability variableNullability) {
        ImmutableList nonNullableConstraints = (ImmutableList)childConstraints.stream().map(cs -> (ImmutableSet)cs.stream().filter(c -> c.stream().noneMatch(variableNullability::isPossiblyNullable)).collect(ImmutableCollectors.toSet())).collect(ImmutableCollectors.toList());
        if (nonNullableConstraints.isEmpty() || nonNullableConstraints.stream().anyMatch(AbstractCollection::isEmpty)) {
            return ImmutableSet.of();
        }
        return this.computeCartesianProduct((ImmutableList<ImmutableSet<ImmutableSet<Variable>>>)nonNullableConstraints, 0);
    }

    private ImmutableSet<ImmutableSet<Variable>> computeCartesianProduct(ImmutableList<ImmutableSet<ImmutableSet<Variable>>> nonNullableConstraints, int index) {
        int arity = nonNullableConstraints.size();
        if (index == arity - 1) {
            return (ImmutableSet)nonNullableConstraints.get(index);
        }
        ImmutableSet<ImmutableSet<Variable>> followingCartesianProduct = this.computeCartesianProduct(nonNullableConstraints, index + 1);
        return (ImmutableSet)((ImmutableSet)nonNullableConstraints.get(index)).stream().flatMap(c -> followingCartesianProduct.stream().map(c1 -> Sets.union((Set)c, (Set)c1).immutableCopy())).collect(ImmutableCollectors.toSet());
    }

    private ImmutableSet<ImmutableSet<Variable>> removeRedundantConstraints(Set<ImmutableSet<Variable>> allConstraints) {
        Set mergedConstraints = allConstraints.stream().sorted(Comparator.comparingInt(AbstractCollection::size)).reduce(Sets.newHashSet(), (cs, c1) -> {
            if (cs.stream().noneMatch(arg_0 -> c1.containsAll(arg_0))) {
                cs.add(c1);
            }
            return cs;
        }, (c1, c2) -> {
            throw new MinorOntopInternalBugException("No merging");
        });
        return ImmutableSet.copyOf((Collection)mergedConstraints);
    }

    @Override
    public FunctionalDependencies inferFunctionalDependencies(ImmutableList<IQTree> children, ImmutableSet<ImmutableSet<Variable>> uniqueConstraints, ImmutableSet<Variable> variables) {
        return children.stream().flatMap(child -> child.inferFunctionalDependencies().stream()).collect(FunctionalDependencies.toFunctionalDependencies());
    }

    @Override
    public VariableNonRequirement computeVariableNonRequirement(ImmutableList<IQTree> children) {
        return super.computeVariableNonRequirement(children);
    }

    private Stream<Map.Entry<IQTree, IQTree>> extractFunctionalDependencies(IQTree t1, IQTree t2, ImmutableMap<IQTree, ImmutableSet<ImmutableSet<Variable>>> constraintMap) {
        Sets.SetView commonVariables = Sets.intersection(t1.getVariables(), t2.getVariables());
        if (commonVariables.isEmpty()) {
            return Stream.empty();
        }
        return Stream.of(Optional.of(Maps.immutableEntry((Object)t1, (Object)t2)).filter(arg_0 -> InnerJoinNodeImpl.lambda$extractFunctionalDependencies$28(constraintMap, (Set)commonVariables, arg_0)), Optional.of(Maps.immutableEntry((Object)t2, (Object)t1)).filter(arg_0 -> InnerJoinNodeImpl.lambda$extractFunctionalDependencies$29(constraintMap, (Set)commonVariables, arg_0))).flatMap(Optional::stream);
    }

    private Multimap<IQTree, IQTree> saturateDependencies(ImmutableMultimap<IQTree, IQTree> directDependencyMap) {
        boolean hasConverged;
        HashMultimap mutableMultimap = HashMultimap.create(directDependencyMap);
        do {
            hasConverged = true;
            for (IQTree determinant : directDependencyMap.keys()) {
                ImmutableSet dependents = ImmutableSet.copyOf((Collection)mutableMultimap.get((Object)determinant));
                for (IQTree dependent : dependents) {
                    if (!mutableMultimap.putAll((Object)determinant, (Iterable)mutableMultimap.get((Object)dependent))) continue;
                    hasConverged = false;
                }
            }
        } while (!hasConverged);
        return mutableMultimap;
    }

    @Override
    public IQTree propagateDownConstraint(ImmutableExpression constraint, ImmutableList<IQTree> children, VariableGenerator variableGenerator) {
        VariableNullability extendedChildrenVariableNullability = this.variableNullabilityTools.getChildrenVariableNullability(children).extendToExternalVariables(constraint.getVariableStream());
        try {
            ConditionSimplifier.ExpressionAndSubstitution conditionSimplificationResults = this.conditionSimplifier.simplifyCondition(this.getOptionalFilterCondition(), (ImmutableSet<Variable>)ImmutableSet.of(), children, extendedChildrenVariableNullability);
            Optional<ImmutableExpression> downConstraint = this.conditionSimplifier.computeDownConstraint(Optional.of(constraint), conditionSimplificationResults, extendedChildrenVariableNullability);
            ImmutableList newChildren = Optional.of(conditionSimplificationResults.getSubstitution()).filter(s -> !s.isEmpty()).map(s -> (ImmutableList)children.stream().map(child -> child.applyDescendingSubstitution((Substitution<? extends VariableOrGroundTerm>)s, downConstraint, variableGenerator)).collect(ImmutableCollectors.toList())).orElseGet(() -> downConstraint.map(s -> (ImmutableList)children.stream().map(child -> child.propagateDownConstraint((ImmutableExpression)s, variableGenerator)).collect(ImmutableCollectors.toList())).orElse(children));
            InnerJoinNodeImpl newJoin = conditionSimplificationResults.getOptionalExpression().equals(this.getOptionalFilterCondition()) ? this : this.iqTreeTools.createInnerJoinNode(conditionSimplificationResults.getOptionalExpression());
            NaryIQTree joinTree = this.iqFactory.createNaryIQTree(newJoin, (ImmutableList<IQTree>)newChildren);
            return this.iqTreeTools.createConstructionNodeTreeIfNontrivial(joinTree, conditionSimplificationResults.getSubstitution(), () -> this.iqTreeTools.getChildrenVariables(children));
        }
        catch (UnsatisfiableConditionException e) {
            return this.iqFactory.createEmptyNode(this.iqTreeTools.getChildrenVariables(children));
        }
    }

    private IQTree liftUnionChild(int childIndex, NaryIQTree newUnionChild, ImmutableList<IQTree> initialChildren, VariableGenerator variableGenerator) {
        UnionNode newUnionNode = this.iqFactory.createUnionNode(this.iqTreeTools.getChildrenVariables(initialChildren));
        return this.iqFactory.createNaryIQTree(newUnionNode, (ImmutableList<IQTree>)((ImmutableList)newUnionChild.getChildren().stream().map(unionGrandChild -> this.createJoinSubtree(childIndex, (IQTree)unionGrandChild, initialChildren)).collect(ImmutableCollectors.toList()))).normalizeForOptimization(variableGenerator);
    }

    private IQTree createJoinSubtree(int childIndex, IQTree unionGrandChild, ImmutableList<IQTree> initialChildren) {
        return this.iqFactory.createNaryIQTree(this, (ImmutableList<IQTree>)((ImmutableList)IntStream.range(0, initialChildren.size()).mapToObj(i -> i == childIndex ? unionGrandChild : (IQTree)initialChildren.get(i)).collect(ImmutableCollectors.toList())));
    }

    private static /* synthetic */ boolean lambda$extractFunctionalDependencies$29(ImmutableMap constraintMap, Set commonVariables, Map.Entry e) {
        return ((ImmutableSet)constraintMap.get(e.getValue())).stream().anyMatch(commonVariables::containsAll);
    }

    private static /* synthetic */ boolean lambda$extractFunctionalDependencies$28(ImmutableMap constraintMap, Set commonVariables, Map.Entry e) {
        return ((ImmutableSet)constraintMap.get(e.getValue())).stream().anyMatch(commonVariables::containsAll);
    }
}

