/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.evaluator.TermNullabilityEvaluator;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.IQTreeCache;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.iq.exception.QueryNodeTransformationException;
import it.unibz.inf.ontop.iq.impl.IQTreeTools;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.QueryNodeVisitor;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.JoinLikeNodeImpl;
import it.unibz.inf.ontop.iq.node.impl.JoinOrFilterVariableNullabilityTools;
import it.unibz.inf.ontop.iq.node.impl.UnsatisfiableConditionException;
import it.unibz.inf.ontop.iq.node.normalization.ConditionSimplifier;
import it.unibz.inf.ontop.iq.node.normalization.LeftJoinNormalizer;
import it.unibz.inf.ontop.iq.node.normalization.impl.ExpressionAndSubstitutionImpl;
import it.unibz.inf.ontop.iq.request.FunctionalDependencies;
import it.unibz.inf.ontop.iq.request.VariableNonRequirement;
import it.unibz.inf.ontop.iq.transform.IQTreeExtendedTransformer;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.node.HomogeneousQueryNodeTransformer;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonFunctionalTerm;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBStrictEqFunctionSymbol;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class LeftJoinNodeImpl
extends JoinLikeNodeImpl
implements LeftJoinNode {
    private static final String LEFT_JOIN_NODE_STR = "LJ";
    private final LeftJoinNormalizer ljNormalizer;
    private final CoreUtilsFactory coreUtilsFactory;

    @AssistedInject
    private LeftJoinNodeImpl(@Assisted Optional<ImmutableExpression> optionalJoinCondition, TermNullabilityEvaluator nullabilityEvaluator, SubstitutionFactory substitutionFactory, TermFactory termFactory, TypeFactory typeFactory, IntermediateQueryFactory iqFactory, ConditionSimplifier conditionSimplifier, LeftJoinNormalizer ljNormalizer, JoinOrFilterVariableNullabilityTools variableNullabilityTools, CoreUtilsFactory coreUtilsFactory, IQTreeTools iqTreeTools) {
        super(optionalJoinCondition, nullabilityEvaluator, termFactory, iqFactory, typeFactory, substitutionFactory, variableNullabilityTools, conditionSimplifier, iqTreeTools);
        this.ljNormalizer = ljNormalizer;
        this.coreUtilsFactory = coreUtilsFactory;
    }

    @AssistedInject
    private LeftJoinNodeImpl(@Assisted ImmutableExpression joiningCondition, TermNullabilityEvaluator nullabilityEvaluator, SubstitutionFactory substitutionFactory, TermFactory termFactory, TypeFactory typeFactory, IntermediateQueryFactory iqFactory, ConditionSimplifier conditionSimplifier, LeftJoinNormalizer ljNormalizer, JoinOrFilterVariableNullabilityTools variableNullabilityTools, CoreUtilsFactory coreUtilsFactory, IQTreeTools iqTreeTools) {
        this(Optional.of(joiningCondition), nullabilityEvaluator, substitutionFactory, termFactory, typeFactory, iqFactory, conditionSimplifier, ljNormalizer, variableNullabilityTools, coreUtilsFactory, iqTreeTools);
    }

    @AssistedInject
    private LeftJoinNodeImpl(TermNullabilityEvaluator nullabilityEvaluator, SubstitutionFactory substitutionFactory, TermFactory termFactory, TypeFactory typeFactory, IntermediateQueryFactory iqFactory, ConditionSimplifier conditionSimplifier, LeftJoinNormalizer ljNormalizer, JoinOrFilterVariableNullabilityTools variableNullabilityTools, CoreUtilsFactory coreUtilsFactory, IQTreeTools iqTreeTools) {
        this(Optional.empty(), nullabilityEvaluator, substitutionFactory, termFactory, typeFactory, iqFactory, conditionSimplifier, ljNormalizer, variableNullabilityTools, coreUtilsFactory, iqTreeTools);
    }

    @Override
    public void acceptVisitor(QueryNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public LeftJoinNode acceptNodeTransformer(HomogeneousQueryNodeTransformer transformer) throws QueryNodeTransformationException {
        return transformer.transform(this);
    }

    @Override
    public LeftJoinNode changeOptionalFilterCondition(Optional<ImmutableExpression> newOptionalFilterCondition) {
        return new LeftJoinNodeImpl(newOptionalFilterCondition, this.nullabilityEvaluator, this.substitutionFactory, this.termFactory, this.typeFactory, this.iqFactory, this.conditionSimplifier, this.ljNormalizer, this.variableNullabilityTools, this.coreUtilsFactory, this.iqTreeTools);
    }

    @Override
    public int hashCode() {
        return this.getOptionalFilterCondition().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LeftJoinNodeImpl) {
            LeftJoinNodeImpl that = (LeftJoinNodeImpl)o;
            return this.getOptionalFilterCondition().equals(that.getOptionalFilterCondition());
        }
        return false;
    }

    public String toString() {
        return LEFT_JOIN_NODE_STR + this.getOptionalFilterString();
    }

    @Override
    public VariableNullability getVariableNullability(IQTree leftChild, IQTree rightChild) {
        VariableNullability rightNullability = this.getOptionalFilterCondition().map(c -> this.variableNullabilityTools.updateWithFilter((ImmutableExpression)c, rightChild.getVariableNullability().getNullableGroups(), rightChild.getVariables())).orElseGet(rightChild::getVariableNullability);
        Sets.SetView rightSpecificVariables = Sets.difference(rightChild.getVariables(), leftChild.getVariables());
        ImmutableSet rightSelectedGroups = (ImmutableSet)rightNullability.getNullableGroups().stream().map(arg_0 -> LeftJoinNodeImpl.lambda$getVariableNullability$1((Set)rightSpecificVariables, arg_0)).filter(g -> !g.isEmpty()).collect(ImmutableCollectors.toSet());
        ImmutableSet initiallyNonNullableRightSpecificGroup = (ImmutableSet)rightSpecificVariables.stream().filter(v -> !rightNullability.isPossiblyNullable((Variable)v)).collect(ImmutableCollectors.toSet());
        ImmutableSet rightGroupStream = initiallyNonNullableRightSpecificGroup.isEmpty() ? rightSelectedGroups : Sets.union((Set)ImmutableSet.of((Object)initiallyNonNullableRightSpecificGroup), (Set)rightSelectedGroups);
        ImmutableSet nullableGroups = Sets.union(leftChild.getVariableNullability().getNullableGroups(), (Set)rightGroupStream).immutableCopy();
        ImmutableSet scope = Sets.union(leftChild.getVariables(), rightChild.getVariables()).immutableCopy();
        return this.coreUtilsFactory.createVariableNullability((ImmutableSet<ImmutableSet<Variable>>)nullableGroups, (ImmutableSet<Variable>)scope);
    }

    @Override
    public ImmutableSet<Substitution<NonVariableTerm>> getPossibleVariableDefinitions(IQTree leftChild, IQTree rightChild) {
        ImmutableSet<Substitution<NonVariableTerm>> leftDefs = leftChild.getPossibleVariableDefinitions();
        Sets.SetView rightSpecificVariables = Sets.difference(rightChild.getVariables(), leftChild.getVariables());
        ImmutableSet rightDefs = (ImmutableSet)rightChild.getPossibleVariableDefinitions().stream().map(arg_0 -> LeftJoinNodeImpl.lambda$getPossibleVariableDefinitions$4((Set)rightSpecificVariables, arg_0)).collect(ImmutableCollectors.toSet());
        if (leftDefs.isEmpty()) {
            return rightDefs;
        }
        if (rightDefs.isEmpty()) {
            return leftDefs;
        }
        return (ImmutableSet)leftDefs.stream().flatMap(l -> rightDefs.stream().map(r -> this.substitutionFactory.union(l, r))).collect(ImmutableCollectors.toSet());
    }

    @Override
    public IQTree acceptTransformer(IQTree tree, IQTreeVisitingTransformer transformer, IQTree leftChild, IQTree rightChild) {
        return transformer.transformLeftJoin(tree, this, leftChild, rightChild);
    }

    @Override
    public <T> IQTree acceptTransformer(IQTree tree, IQTreeExtendedTransformer<T> transformer, IQTree leftChild, IQTree rightChild, T context) {
        return transformer.transformLeftJoin(tree, this, leftChild, rightChild, context);
    }

    @Override
    public <T> T acceptVisitor(IQVisitor<T> visitor, IQTree leftChild, IQTree rightChild) {
        return visitor.visitLeftJoin(this, leftChild, rightChild);
    }

    @Override
    public IQTree normalizeForOptimization(IQTree initialLeftChild, IQTree initialRightChild, VariableGenerator variableGenerator, IQTreeCache treeCache) {
        return this.ljNormalizer.normalizeForOptimization(this, initialLeftChild, initialRightChild, variableGenerator, treeCache);
    }

    @Override
    public IQTree liftIncompatibleDefinitions(Variable variable, IQTree leftChild, IQTree rightChild, VariableGenerator variableGenerator) {
        IQTree liftedLeftChild;
        QueryNode leftChildRoot;
        if (leftChild.getVariables().contains((Object)variable) && (leftChildRoot = (liftedLeftChild = leftChild.liftIncompatibleDefinitions(variable, variableGenerator)).getRootNode()) instanceof UnionNode && ((UnionNode)leftChildRoot).hasAChildWithLiftableDefinition(variable, liftedLeftChild.getChildren())) {
            UnionNode newUnionNode = this.iqFactory.createUnionNode(this.iqTreeTools.getChildrenVariables(leftChild, rightChild));
            return this.iqFactory.createNaryIQTree(newUnionNode, (ImmutableList<IQTree>)((ImmutableList)liftedLeftChild.getChildren().stream().map(unionChild -> this.iqFactory.createBinaryNonCommutativeIQTree(this, (IQTree)unionChild, rightChild)).collect(ImmutableCollectors.toList())));
        }
        return this.iqFactory.createBinaryNonCommutativeIQTree(this, leftChild, rightChild);
    }

    @Override
    public IQTree applyDescendingSubstitution(Substitution<? extends VariableOrGroundTerm> descendingSubstitution, Optional<ImmutableExpression> constraint, IQTree leftChild, IQTree rightChild, VariableGenerator variableGenerator) {
        if (constraint.filter(c -> this.isRejectingRightSpecificNulls((ImmutableExpression)c, leftChild, rightChild)).isPresent() || this.containsEqualityRightSpecificVariable(descendingSubstitution, leftChild, rightChild)) {
            return this.transformIntoInnerJoinTree(leftChild, rightChild).applyDescendingSubstitution(descendingSubstitution, constraint, variableGenerator);
        }
        IQTree updatedLeftChild = leftChild.applyDescendingSubstitution(descendingSubstitution, constraint, variableGenerator);
        Optional<ImmutableExpression> initialExpression = this.getOptionalFilterCondition();
        if (initialExpression.isPresent()) {
            try {
                ConditionSimplifier.ExpressionAndSubstitution expressionAndCondition = this.applyDescendingSubstitutionToExpression(initialExpression.get(), descendingSubstitution, leftChild.getVariables(), rightChild.getVariables());
                Substitution<? extends VariableOrGroundTerm> rightDescendingSubstitution = this.substitutionFactory.onVariableOrGroundTerms().compose(expressionAndCondition.getSubstitution(), descendingSubstitution);
                IQTree updatedRightChild = rightChild.applyDescendingSubstitution(rightDescendingSubstitution, Optional.empty(), variableGenerator);
                return updatedRightChild.isDeclaredAsEmpty() ? updatedLeftChild : this.iqFactory.createBinaryNonCommutativeIQTree(this.iqFactory.createLeftJoinNode(expressionAndCondition.getOptionalExpression()), updatedLeftChild, updatedRightChild);
            }
            catch (UnsatisfiableConditionException e) {
                return updatedLeftChild;
            }
        }
        IQTree updatedRightChild = rightChild.applyDescendingSubstitution(descendingSubstitution, Optional.empty(), variableGenerator);
        if (updatedRightChild.isDeclaredAsEmpty()) {
            ImmutableSet<Variable> leftVariables = updatedLeftChild.getVariables();
            ImmutableSet projectedVariables = Sets.union(leftVariables, updatedRightChild.getVariables()).immutableCopy();
            Substitution<Constant> substitution = Sets.difference((Set)projectedVariables, leftVariables).stream().collect(this.substitutionFactory.toSubstitution(v -> this.termFactory.getNullConstant()));
            return this.iqTreeTools.createConstructionNodeTreeIfNontrivial(updatedLeftChild, substitution, () -> projectedVariables);
        }
        return this.iqFactory.createBinaryNonCommutativeIQTree(this, updatedLeftChild, updatedRightChild);
    }

    @Override
    public IQTree applyDescendingSubstitutionWithoutOptimizing(Substitution<? extends VariableOrGroundTerm> descendingSubstitution, IQTree leftChild, IQTree rightChild, VariableGenerator variableGenerator) {
        if (this.containsEqualityRightSpecificVariable(descendingSubstitution, leftChild, rightChild)) {
            return this.transformIntoInnerJoinTree(leftChild, rightChild).applyDescendingSubstitutionWithoutOptimizing(descendingSubstitution, variableGenerator);
        }
        IQTree newLeftChild = leftChild.applyDescendingSubstitutionWithoutOptimizing(descendingSubstitution, variableGenerator);
        IQTree newRightChild = rightChild.applyDescendingSubstitutionWithoutOptimizing(descendingSubstitution, variableGenerator);
        LeftJoinNode newLJNode = this.getOptionalFilterCondition().map(descendingSubstitution::apply).map(this.iqFactory::createLeftJoinNode).orElse(this);
        return this.iqFactory.createBinaryNonCommutativeIQTree(newLJNode, newLeftChild, newRightChild);
    }

    @Override
    public IQTree applyFreshRenaming(InjectiveSubstitution<Variable> renamingSubstitution, IQTree leftChild, IQTree rightChild, IQTreeCache treeCache) {
        IQTree newLeftChild = leftChild.applyFreshRenaming(renamingSubstitution);
        IQTree newRightChild = rightChild.applyFreshRenaming(renamingSubstitution);
        Optional<ImmutableExpression> newCondition = this.getOptionalFilterCondition().map(renamingSubstitution::apply);
        LeftJoinNodeImpl newLeftJoinNode = newCondition.equals(this.getOptionalFilterCondition()) ? this : this.iqFactory.createLeftJoinNode(newCondition);
        IQTreeCache newTreeCache = treeCache.applyFreshRenaming(renamingSubstitution);
        return this.iqFactory.createBinaryNonCommutativeIQTree(newLeftJoinNode, newLeftChild, newRightChild, newTreeCache);
    }

    @Override
    public boolean isConstructed(Variable variable, IQTree leftChild, IQTree rightChild) {
        return Stream.of(leftChild, rightChild).anyMatch(c -> c.isConstructed(variable));
    }

    @Override
    public boolean isDistinct(IQTree tree, IQTree leftChild, IQTree rightChild) {
        if (!leftChild.isDistinct()) {
            return false;
        }
        if (rightChild.isDistinct()) {
            return true;
        }
        Optional<ImmutableExpression> optionalFilterCondition = this.getOptionalFilterCondition();
        ImmutableSet<Variable> rightVariables = rightChild.getVariables();
        Sets.SetView commonVariables = Sets.intersection(leftChild.getVariables(), rightVariables);
        if (!optionalFilterCondition.isPresent() && commonVariables.isEmpty()) {
            return false;
        }
        ImmutableSet<ImmutableSet<Variable>> rightConstraints = rightChild.inferUniqueConstraints();
        if (rightConstraints.isEmpty()) {
            return false;
        }
        ImmutableSet nullableGroups = (ImmutableSet)rightChild.getVariableNullability().getNullableGroups().stream().filter(arg_0 -> LeftJoinNodeImpl.lambda$isDistinct$12((Set)commonVariables, arg_0)).collect(ImmutableCollectors.toSet());
        VariableNullability variableNullabilityForRight = optionalFilterCondition.map(c -> this.variableNullabilityTools.updateWithFilter((ImmutableExpression)optionalFilterCondition.get(), (ImmutableSet<ImmutableSet<Variable>>)nullableGroups, rightVariables)).orElseGet(() -> this.coreUtilsFactory.createVariableNullability((ImmutableSet<ImmutableSet<Variable>>)nullableGroups, rightVariables));
        return rightConstraints.stream().anyMatch(c -> c.stream().noneMatch(variableNullabilityForRight::isPossiblyNullable));
    }

    @Override
    public IQTree propagateDownConstraint(ImmutableExpression constraint, IQTree leftChild, IQTree rightChild, VariableGenerator variableGenerator) {
        return this.propagateDownCondition(Optional.of(constraint), leftChild, rightChild, variableGenerator);
    }

    @Override
    public void validateNode(IQTree leftChild, IQTree rightChild) throws InvalidIntermediateQueryException {
        this.getOptionalFilterCondition().ifPresent(e -> this.checkExpression((ImmutableExpression)e, (ImmutableList<IQTree>)ImmutableList.of((Object)leftChild, (Object)rightChild)));
        this.checkNonProjectedVariables((ImmutableList<IQTree>)ImmutableList.of((Object)leftChild, (Object)rightChild));
    }

    @Override
    public IQTree removeDistincts(IQTree leftChild, IQTree rightChild, IQTreeCache treeCache) {
        IQTree newLeftChild = leftChild.removeDistincts();
        IQTree newRightChild = rightChild.removeDistincts();
        IQTreeCache newTreeCache = treeCache.declareDistinctRemoval(newLeftChild.equals(leftChild) && newRightChild.equals(rightChild));
        return this.iqFactory.createBinaryNonCommutativeIQTree(this, newLeftChild, newRightChild, newTreeCache);
    }

    @Override
    public ImmutableSet<ImmutableSet<Variable>> inferUniqueConstraints(IQTree leftChild, IQTree rightChild) {
        ImmutableSet<ImmutableSet<Variable>> leftChildConstraints;
        block6: {
            block5: {
                leftChildConstraints = leftChild.inferUniqueConstraints();
                if (leftChildConstraints.isEmpty()) {
                    return ImmutableSet.of();
                }
                ImmutableSet<ImmutableSet<Variable>> rightChildConstraints = rightChild.inferUniqueConstraints();
                if (rightChildConstraints.isEmpty()) {
                    return ImmutableSet.of();
                }
                Sets.SetView commonVariables = Sets.intersection(leftChild.getVariables(), rightChild.getVariables());
                if (commonVariables.isEmpty()) break block5;
                if (!rightChildConstraints.stream().noneMatch(((Set)commonVariables)::containsAll)) break block6;
            }
            return ImmutableSet.of();
        }
        return leftChildConstraints;
    }

    @Override
    public FunctionalDependencies inferFunctionalDependencies(IQTree leftChild, IQTree rightChild, ImmutableSet<ImmutableSet<Variable>> uniqueConstraints, ImmutableSet<Variable> variables) {
        FunctionalDependencies rightFunctionalDependencies = rightChild.inferFunctionalDependencies();
        if (rightFunctionalDependencies.isEmpty()) {
            return leftChild.inferFunctionalDependencies();
        }
        ImmutableSet<Variable> leftVariables = leftChild.getVariables();
        FunctionalDependencies filterRightFunctionalDependencies = rightFunctionalDependencies.stream().map(e -> Maps.immutableEntry((Object)((ImmutableSet)e.getKey()), (Object)Sets.difference((Set)((Set)e.getValue()), (Set)leftVariables).immutableCopy())).filter(e -> !((ImmutableSet)e.getValue()).isEmpty()).collect(FunctionalDependencies.toFunctionalDependencies());
        if (filterRightFunctionalDependencies.isEmpty()) {
            return leftChild.inferFunctionalDependencies();
        }
        return leftChild.inferFunctionalDependencies().concat(filterRightFunctionalDependencies);
    }

    @Override
    public VariableNonRequirement computeNotInternallyRequiredVariables(IQTree leftChild, IQTree rightChild) {
        return this.computeVariableNonRequirement((ImmutableList<IQTree>)ImmutableList.of((Object)leftChild, (Object)rightChild));
    }

    private IQTree propagateDownCondition(Optional<ImmutableExpression> constraint, IQTree leftChild, IQTree rightChild, VariableGenerator variableGenerator) {
        if (constraint.filter(c -> this.isRejectingRightSpecificNulls((ImmutableExpression)c, leftChild, rightChild)).isPresent()) {
            return this.transformIntoInnerJoinTree(leftChild, rightChild).propagateDownConstraint(constraint.get(), variableGenerator);
        }
        IQTree newLeftChild = constraint.map(c -> leftChild.propagateDownConstraint((ImmutableExpression)c, variableGenerator)).orElse(leftChild);
        return this.iqFactory.createBinaryNonCommutativeIQTree(this, newLeftChild, rightChild);
    }

    private ConditionSimplifier.ExpressionAndSubstitution applyDescendingSubstitutionToExpression(ImmutableExpression initialExpression, Substitution<? extends VariableOrGroundTerm> descendingSubstitution, ImmutableSet<Variable> leftChildVariables, ImmutableSet<Variable> rightChildVariables) throws UnsatisfiableConditionException {
        ImmutableExpression expression = descendingSubstitution.apply(initialExpression);
        ImmutableExpression.Evaluation results = expression.evaluate2VL(this.coreUtilsFactory.createSimplifiedVariableNullability(expression));
        if (results.isEffectiveFalse()) {
            throw new UnsatisfiableConditionException();
        }
        return results.getExpression().map(e -> this.convertIntoExpressionAndSubstitution((ImmutableExpression)e, leftChildVariables, rightChildVariables)).orElseGet(() -> new ExpressionAndSubstitutionImpl(Optional.empty(), descendingSubstitution.restrictRangeTo(VariableOrGroundTerm.class)));
    }

    private ConditionSimplifier.ExpressionAndSubstitution convertIntoExpressionAndSubstitution(ImmutableExpression expression, ImmutableSet<Variable> leftVariables, ImmutableSet<Variable> rightVariables) {
        Sets.SetView rightSpecificVariables = Sets.difference(rightVariables, leftVariables);
        ImmutableSet expressions = (ImmutableSet)expression.flattenAND().collect(ImmutableCollectors.toSet());
        ImmutableSet downSubstitutionExpressions = (ImmutableSet)expressions.stream().filter(e -> e.getFunctionSymbol() instanceof DBStrictEqFunctionSymbol).filter(e -> {
            ImmutableList<? extends ImmutableTerm> arguments = e.getTerms();
            if (!arguments.stream().allMatch(t -> t instanceof NonFunctionalTerm)) return false;
            if (!arguments.stream().anyMatch(arg_0 -> ((ImmutableSet)rightVariables).contains(arg_0))) return false;
            return true;
        }).collect(ImmutableCollectors.toSet());
        Substitution<VariableOrGroundTerm> downSubstitution = downSubstitutionExpressions.stream().map(ImmutableFunctionalTerm::getTerms).map(args -> args.get(0) instanceof Variable ? args : args.reverse()).map(arg_0 -> LeftJoinNodeImpl.lambda$convertIntoExpressionAndSubstitution$27((Set)rightSpecificVariables, arg_0)).collect(this.substitutionFactory.toSubstitution(args -> (Variable)args.get(0), args -> (VariableOrGroundTerm)args.get(1)));
        Optional<ImmutableExpression> newExpression = Optional.of((ImmutableList)expressions.stream().filter(arg_0 -> LeftJoinNodeImpl.lambda$convertIntoExpressionAndSubstitution$30(downSubstitutionExpressions, (Set)rightSpecificVariables, arg_0)).collect(ImmutableCollectors.toList())).filter(l -> !l.isEmpty()).map(this.termFactory::getConjunction).map(downSubstitution::apply);
        return new ExpressionAndSubstitutionImpl(newExpression, downSubstitution);
    }

    private boolean isRejectingRightSpecificNulls(ImmutableExpression constraint, IQTree leftChild, IQTree rightChild) {
        Sets.SetView nullVariables = Sets.intersection((Set)Sets.difference(rightChild.getVariables(), leftChild.getVariables()), constraint.getVariables());
        if (nullVariables.isEmpty()) {
            return false;
        }
        ImmutableExpression nullifiedExpression = nullVariables.stream().collect(this.substitutionFactory.toSubstitution(v -> this.termFactory.getNullConstant())).apply(constraint);
        return nullifiedExpression.evaluate2VL(this.termFactory.createDummyVariableNullability(nullifiedExpression)).isEffectiveFalse();
    }

    private boolean containsEqualityRightSpecificVariable(Substitution<? extends VariableOrGroundTerm> descendingSubstitution, IQTree leftChild, IQTree rightChild) {
        ImmutableSet<Variable> leftVariables = leftChild.getVariables();
        ImmutableSet<Variable> rightVariables = rightChild.getVariables();
        Substitution<Variable> restricted = descendingSubstitution.restrictRangeTo(Variable.class);
        Sets.SetView variables = Sets.union(leftVariables, rightVariables);
        ImmutableSet<Variable> freshVariables = restricted.getPreImage(arg_0 -> LeftJoinNodeImpl.lambda$containsEqualityRightSpecificVariable$33((Set)variables, arg_0));
        return !Sets.intersection((Set)Sets.difference(rightVariables, leftVariables), (Set)Sets.union((Set)Sets.difference(descendingSubstitution.getDomain(), freshVariables), restricted.getRangeSet())).isEmpty();
    }

    private IQTree transformIntoInnerJoinTree(IQTree leftChild, IQTree rightChild) {
        return this.iqFactory.createNaryIQTree(this.iqFactory.createInnerJoinNode(this.getOptionalFilterCondition()), (ImmutableList<IQTree>)ImmutableList.of((Object)leftChild, (Object)rightChild));
    }

    @Override
    protected VariableNonRequirement applyFilterToVariableNonRequirement(VariableNonRequirement nonRequirementBeforeFilter, ImmutableList<IQTree> children) {
        if (nonRequirementBeforeFilter.isEmpty()) {
            return nonRequirementBeforeFilter;
        }
        IQTree leftChild = (IQTree)children.get(0);
        IQTree rightChild = (IQTree)children.get(1);
        Sets.SetView rightSpecificVariables = Sets.difference(rightChild.getVariables(), leftChild.getVariables());
        if (rightSpecificVariables.isEmpty()) {
            return nonRequirementBeforeFilter;
        }
        Sets.SetView commonVariables = Sets.intersection(leftChild.getVariables(), rightChild.getVariables());
        if (!commonVariables.isEmpty()) {
            if (rightChild.inferUniqueConstraints().stream().anyMatch(((Set)commonVariables)::containsAll)) {
                Sets.SetView rightSpecificNonRequiredVariables = Sets.intersection((Set)rightSpecificVariables, nonRequirementBeforeFilter.getNotRequiredVariables());
                ImmutableSet<Variable> filterVariables = this.getLocalVariables();
                return nonRequirementBeforeFilter.transformConditions((arg_0, arg_1) -> LeftJoinNodeImpl.lambda$applyFilterToVariableNonRequirement$34(filterVariables, (Set)rightSpecificNonRequiredVariables, arg_0, arg_1));
            }
        }
        return super.applyFilterToVariableNonRequirement(nonRequirementBeforeFilter, children);
    }

    private static /* synthetic */ ImmutableSet lambda$applyFilterToVariableNonRequirement$34(ImmutableSet filterVariables, Set rightSpecificNonRequiredVariables, Variable v, ImmutableSet conditions) {
        return filterVariables.contains((Object)v) ? Sets.union((Set)conditions, (Set)rightSpecificNonRequiredVariables).immutableCopy() : conditions;
    }

    private static /* synthetic */ boolean lambda$containsEqualityRightSpecificVariable$33(Set variables, Variable t) {
        return !variables.contains(t);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static /* synthetic */ boolean lambda$convertIntoExpressionAndSubstitution$30(ImmutableSet downSubstitutionExpressions, Set rightSpecificVariables, ImmutableExpression e) {
        if (!downSubstitutionExpressions.contains((Object)e)) return true;
        if (!e.getTerms().stream().anyMatch(rightSpecificVariables::contains)) return false;
        return true;
    }

    private static /* synthetic */ ImmutableList lambda$convertIntoExpressionAndSubstitution$27(Set rightSpecificVariables, ImmutableList args) {
        return args.get(0) instanceof Variable && rightSpecificVariables.contains(args.get(1)) ? args.reverse() : args;
    }

    private static /* synthetic */ boolean lambda$isDistinct$12(Set commonVariables, ImmutableSet g) {
        return Sets.intersection((Set)g, (Set)commonVariables).isEmpty();
    }

    private static /* synthetic */ Substitution lambda$getPossibleVariableDefinitions$4(Set rightSpecificVariables, Substitution s) {
        return s.restrictDomainTo(rightSpecificVariables);
    }

    private static /* synthetic */ ImmutableSet lambda$getVariableNullability$1(Set rightSpecificVariables, ImmutableSet g) {
        return Sets.intersection((Set)g, (Set)rightSpecificVariables).immutableCopy();
    }
}

