/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OntopModelSettings;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.IQTreeCache;
import it.unibz.inf.ontop.iq.NaryIQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.iq.exception.QueryNodeTransformationException;
import it.unibz.inf.ontop.iq.node.AggregationNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.EmptyNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.QueryNodeVisitor;
import it.unibz.inf.ontop.iq.node.SliceNode;
import it.unibz.inf.ontop.iq.node.TrueNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.node.ValuesNode;
import it.unibz.inf.ontop.iq.node.impl.QueryModifierNodeImpl;
import it.unibz.inf.ontop.iq.request.FunctionalDependencies;
import it.unibz.inf.ontop.iq.request.VariableNonRequirement;
import it.unibz.inf.ontop.iq.transform.IQTreeExtendedTransformer;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.node.HomogeneousQueryNodeTransformer;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class SliceNodeImpl
extends QueryModifierNodeImpl
implements SliceNode {
    private static final String SLICE_STR = "SLICE";
    private final long offset;
    private final @Nullable Long limit;
    private final OntopModelSettings settings;

    @AssistedInject
    private SliceNodeImpl(@Assisted(value="offset") long offset, @Assisted(value="limit") long limit, IntermediateQueryFactory iqFactory, OntopModelSettings settings) {
        super(iqFactory);
        if (offset < 0L) {
            throw new IllegalArgumentException("The offset must not be negative");
        }
        if (limit < 0L) {
            throw new IllegalArgumentException("The limit must not be negative");
        }
        this.offset = offset;
        this.limit = limit;
        this.settings = settings;
    }

    @AssistedInject
    private SliceNodeImpl(@Assisted long offset, IntermediateQueryFactory iqFactory, OntopModelSettings settings) {
        super(iqFactory);
        if (offset < 0L) {
            throw new IllegalArgumentException("The offset must not be negative");
        }
        this.offset = offset;
        this.limit = null;
        this.settings = settings;
    }

    @Override
    public IQTree liftIncompatibleDefinitions(Variable variable, IQTree child, VariableGenerator variableGenerator) {
        return this.iqFactory.createUnaryIQTree(this, child);
    }

    @Override
    public IQTree normalizeForOptimization(IQTree child, VariableGenerator variableGenerator, IQTreeCache treeCache) {
        if (this.limit != null && this.limit == 0L) {
            return this.iqFactory.createEmptyNode(child.getVariables());
        }
        IQTree newChild = child.normalizeForOptimization(variableGenerator);
        return this.normalizeForOptimization(newChild, variableGenerator, treeCache, () -> !newChild.equals(child));
    }

    protected IQTree normalizeForOptimization(IQTree newChild, VariableGenerator variableGenerator, IQTreeCache treeCache, Supplier<Boolean> hasChildChanged) {
        QueryNode newChildRoot = newChild.getRootNode();
        if (newChildRoot instanceof ConstructionNode) {
            return this.liftChildConstruction((ConstructionNode)newChildRoot, (UnaryIQTree)newChild, variableGenerator);
        }
        if (newChildRoot instanceof SliceNode) {
            return this.mergeWithSliceChild((SliceNode)newChildRoot, (UnaryIQTree)newChild, treeCache);
        }
        if (newChildRoot instanceof EmptyNode) {
            return newChild;
        }
        if (newChildRoot instanceof TrueNode || newChildRoot instanceof AggregationNode && ((AggregationNode)newChildRoot).getGroupingVariables().isEmpty()) {
            return this.offset > 0L ? this.iqFactory.createEmptyNode(newChild.getVariables()) : newChild;
        }
        if (newChildRoot instanceof ValuesNode) {
            ValuesNode valuesNode = (ValuesNode)newChildRoot;
            ImmutableList<ImmutableList<Constant>> values = valuesNode.getValues();
            if ((long)values.size() <= this.offset) {
                return this.iqFactory.createEmptyNode(valuesNode.getVariables());
            }
            return this.iqFactory.createValuesNode(valuesNode.getOrderedVariables(), (ImmutableList<ImmutableList<Constant>>)values.subList((int)this.offset, Integer.min(this.getLimit().map(l -> l + this.offset).orElse(this.offset).intValue(), values.size()))).normalizeForOptimization(variableGenerator);
        }
        if (this.offset == 0L && this.limit != null && !this.settings.isLimitOptimizationDisabled()) {
            return this.normalizeLimitNoOffset(this.limit.intValue(), newChild, variableGenerator, treeCache, hasChildChanged);
        }
        return this.iqFactory.createUnaryIQTree(this, newChild, hasChildChanged.get() != false ? treeCache.declareAsNormalizedForOptimizationWithEffect() : treeCache.declareAsNormalizedForOptimizationWithoutEffect());
    }

    private IQTree liftChildConstruction(ConstructionNode childConstructionNode, UnaryIQTree childTree, VariableGenerator variableGenerator) {
        IQTree newSliceLevelTree = this.iqFactory.createUnaryIQTree(this, childTree.getChild()).normalizeForOptimization(variableGenerator);
        return this.iqFactory.createUnaryIQTree(childConstructionNode, newSliceLevelTree, this.iqFactory.createIQTreeCache(true));
    }

    private IQTree mergeWithSliceChild(SliceNode newChildRoot, UnaryIQTree newChild, IQTreeCache treeCache) {
        long newOffset = this.offset + newChildRoot.getOffset();
        Optional<Long> newLimit = newChildRoot.getLimit().map(cl -> Math.max(cl - this.offset, 0L)).map(cl -> this.getLimit().map(l -> Math.min(cl, l)).orElse((Long)cl)).or(this::getLimit);
        SliceNode newSliceNode = newLimit.map(l -> this.iqFactory.createSliceNode(newOffset, (long)l)).orElseGet(() -> this.iqFactory.createSliceNode(newOffset));
        return this.iqFactory.createUnaryIQTree(newSliceNode, newChild.getChild(), treeCache.declareAsNormalizedForOptimizationWithEffect());
    }

    private IQTree normalizeLimitNoOffset(int limit, IQTree newChild, VariableGenerator variableGenerator, IQTreeCache treeCache, Supplier<Boolean> hasChildChanged) {
        ImmutableList<IQTree> joinChildren;
        ImmutableList newJoinChildren;
        QueryNode newChildRoot = newChild.getRootNode();
        if (newChildRoot instanceof UnionNode) {
            Optional<IQTree> newTree;
            UnionNode unionNode = (UnionNode)newChildRoot;
            Optional<IQTree> optional = newTree = newChild.getChildren().stream().anyMatch(c -> SliceNodeImpl.getKnownCardinality(c).isPresent()) ? this.simplifyUnionWithChildrenOfKnownCardinality(unionNode, newChild, limit, variableGenerator) : this.pushLimitInUnionChildren(unionNode, newChild, variableGenerator);
            if (newTree.isPresent()) {
                return newTree.get();
            }
        } else if (newChildRoot instanceof DistinctNode) {
            Optional<IQTree> newTree;
            if (limit <= 1) {
                return this.normalizeForOptimization(((UnaryIQTree)newChild).getChild(), variableGenerator, treeCache, () -> true);
            }
            IQTree childOfDistinct = (IQTree)newChild.getChildren().get(0);
            if (childOfDistinct.getRootNode() instanceof UnionNode && childOfDistinct.getChildren().stream().anyMatch(IQTree::isDistinct) && (newTree = this.simplifyDistinctUnionWithDistinctChildren(childOfDistinct, limit, variableGenerator)).isPresent()) {
                return newTree.get();
            }
        } else if (newChildRoot instanceof InnerJoinNode && limit <= 1 && !(newJoinChildren = (ImmutableList)(joinChildren = newChild.getChildren()).stream().map(c -> c.getRootNode() instanceof DistinctNode ? (IQTree)c.getChildren().get(0) : c).collect(ImmutableCollectors.toList())).equals(joinChildren)) {
            NaryIQTree updatedChildTree = this.iqFactory.createNaryIQTree((InnerJoinNode)newChildRoot, (ImmutableList<IQTree>)newJoinChildren);
            return this.normalizeForOptimization(updatedChildTree, variableGenerator, treeCache, () -> true);
        }
        return this.iqFactory.createUnaryIQTree(this, newChild, hasChildChanged.get() != false ? treeCache.declareAsNormalizedForOptimizationWithEffect() : treeCache.declareAsNormalizedForOptimizationWithoutEffect());
    }

    private static Optional<Integer> getKnownCardinality(IQTree tree) {
        if (tree instanceof TrueNode) {
            return Optional.of(1);
        }
        if (tree instanceof ValuesNode) {
            return Optional.of(((ValuesNode)tree).getValues().size());
        }
        QueryNode rootNode = tree.getRootNode();
        if (rootNode instanceof ConstructionNode) {
            return SliceNodeImpl.getKnownCardinality((IQTree)tree.getChildren().get(0));
        }
        return Optional.empty();
    }

    private Optional<IQTree> simplifyUnionWithChildrenOfKnownCardinality(UnionNode childRoot, IQTree childTree, int limit, VariableGenerator variableGenerator) {
        ImmutableList<IQTree> children = childTree.getChildren();
        ImmutableMultimap cardinalityMultimap = children.stream().flatMap(c -> SliceNodeImpl.getKnownCardinality(c).map(card -> Maps.immutableEntry((Object)c, (Object)card)).stream()).collect(ImmutableCollectors.toMultimap());
        Optional maxChildCardinality = cardinalityMultimap.values().stream().max(Integer::compareTo);
        if (maxChildCardinality.isEmpty()) {
            return Optional.empty();
        }
        if ((Integer)maxChildCardinality.get() >= limit) {
            IQTree largestChild = (IQTree)cardinalityMultimap.inverse().get((Object)((Integer)maxChildCardinality.get())).stream().findAny().orElseThrow(() -> new MinorOntopInternalBugException("There should be one child"));
            return Optional.of(this.iqFactory.createUnaryIQTree(this, largestChild).normalizeForOptimization(variableGenerator));
        }
        int sum = cardinalityMultimap.values().stream().reduce(0, Integer::sum);
        if (sum >= limit) {
            int remainingLimit = limit;
            ImmutableList.Builder newChildrenBuilder = ImmutableList.builder();
            for (Map.Entry entry : cardinalityMultimap.entries()) {
                IQTree newChild = (Integer)entry.getValue() <= remainingLimit ? (IQTree)entry.getKey() : this.iqFactory.createUnaryIQTree(this.iqFactory.createSliceNode(0L, remainingLimit), (IQTree)entry.getKey());
                newChildrenBuilder.add((Object)newChild);
                if ((remainingLimit -= ((Integer)entry.getValue()).intValue()) > 0) continue;
                break;
            }
            return Optional.of(this.iqFactory.createNaryIQTree(childRoot, (ImmutableList<IQTree>)newChildrenBuilder.build()).normalizeForOptimization(variableGenerator));
        }
        int numberOfChildrenWithUnknownCardinality = children.size() - cardinalityMultimap.size();
        if (numberOfChildrenWithUnknownCardinality == 0) {
            return Optional.of(childTree);
        }
        ImmutableList newChildren = (ImmutableList)children.stream().map(c -> cardinalityMultimap.containsKey(c) ? c : this.iqFactory.createUnaryIQTree(this.iqFactory.createSliceNode(0L, limit - sum), (IQTree)c)).collect(ImmutableCollectors.toList());
        IQTree newUnionTree = this.iqFactory.createNaryIQTree(childRoot, (ImmutableList<IQTree>)newChildren).normalizeForOptimization(variableGenerator);
        return numberOfChildrenWithUnknownCardinality == 1 ? Optional.of(newUnionTree) : (newUnionTree.equals(childTree) ? Optional.empty() : Optional.of(this.iqFactory.createUnaryIQTree(this, newUnionTree).normalizeForOptimization(variableGenerator)));
    }

    private Optional<IQTree> pushLimitInUnionChildren(UnionNode unionNode, IQTree unionTree, VariableGenerator variableGenerator) {
        ImmutableList newUnionChildren = (ImmutableList)unionTree.getChildren().stream().map(c -> this.iqFactory.createUnaryIQTree(this, (IQTree)c)).map(c -> c.normalizeForOptimization(variableGenerator)).collect(ImmutableCollectors.toList());
        return unionTree.getChildren().equals((Object)newUnionChildren) ? Optional.empty() : Optional.of(this.iqFactory.createUnaryIQTree(this, this.iqFactory.createNaryIQTree(unionNode, (ImmutableList<IQTree>)newUnionChildren)));
    }

    private Optional<IQTree> simplifyDistinctUnionWithDistinctChildren(IQTree unionTree, int limit, VariableGenerator variableGenerator) {
        ImmutableList<IQTree> unionChildren = unionTree.getChildren();
        Optional<IQTree> sufficientChild = unionChildren.stream().filter(IQTree::isDistinct).filter(c -> SliceNodeImpl.getKnownCardinality(c).filter(card -> card >= limit).isPresent()).findAny();
        if (sufficientChild.isPresent()) {
            return Optional.of(this.iqFactory.createUnaryIQTree(this, sufficientChild.get()).normalizeForOptimization(variableGenerator));
        }
        ImmutableList newUnionChildren = (ImmutableList)unionChildren.stream().map(c -> c.isDistinct() ? this.iqFactory.createUnaryIQTree(this, (IQTree)c) : c).map(c -> c.normalizeForOptimization(variableGenerator)).collect(ImmutableCollectors.toList());
        return newUnionChildren.equals(unionChildren) ? Optional.empty() : Optional.of(this.iqFactory.createUnaryIQTree(this, this.iqFactory.createUnaryIQTree(this.iqFactory.createDistinctNode(), this.iqFactory.createNaryIQTree((UnionNode)unionTree.getRootNode(), (ImmutableList<IQTree>)newUnionChildren))).normalizeForOptimization(variableGenerator));
    }

    @Override
    public IQTree applyDescendingSubstitution(Substitution<? extends VariableOrGroundTerm> descendingSubstitution, Optional<ImmutableExpression> constraint, IQTree child, VariableGenerator variableGenerator) {
        return this.iqFactory.createUnaryIQTree(this, child.applyDescendingSubstitution(descendingSubstitution, constraint, variableGenerator));
    }

    @Override
    public IQTree applyDescendingSubstitutionWithoutOptimizing(Substitution<? extends VariableOrGroundTerm> descendingSubstitution, IQTree child, VariableGenerator variableGenerator) {
        return this.iqFactory.createUnaryIQTree(this, child.applyDescendingSubstitutionWithoutOptimizing(descendingSubstitution, variableGenerator));
    }

    @Override
    public IQTree applyFreshRenaming(InjectiveSubstitution<Variable> renamingSubstitution, IQTree child, IQTreeCache treeCache) {
        IQTree newChild = child.applyFreshRenaming(renamingSubstitution);
        IQTreeCache newTreeCache = treeCache.applyFreshRenaming(renamingSubstitution);
        return this.iqFactory.createUnaryIQTree(this, newChild, newTreeCache);
    }

    @Override
    public boolean isDistinct(IQTree tree, IQTree child) {
        if (this.limit != null && this.limit <= 1L) {
            return true;
        }
        return child.isDistinct();
    }

    @Override
    public IQTree acceptTransformer(IQTree tree, IQTreeVisitingTransformer transformer, IQTree child) {
        return transformer.transformSlice(tree, this, child);
    }

    @Override
    public <T> IQTree acceptTransformer(IQTree tree, IQTreeExtendedTransformer<T> transformer, IQTree child, T context) {
        return transformer.transformSlice(tree, this, child, context);
    }

    @Override
    public <T> T acceptVisitor(IQVisitor<T> visitor, IQTree child) {
        return visitor.visitSlice(this, child);
    }

    @Override
    public void validateNode(IQTree child) throws InvalidIntermediateQueryException {
    }

    @Override
    public IQTree removeDistincts(IQTree child, IQTreeCache treeCache) {
        IQTree newChild = child.removeDistincts();
        IQTreeCache newTreeCache = treeCache.declareDistinctRemoval(newChild.equals(child));
        return this.iqFactory.createUnaryIQTree(this, newChild, newTreeCache);
    }

    @Override
    public ImmutableSet<ImmutableSet<Variable>> inferUniqueConstraints(IQTree child) {
        return child.inferUniqueConstraints();
    }

    @Override
    public FunctionalDependencies inferFunctionalDependencies(IQTree child, ImmutableSet<ImmutableSet<Variable>> uniqueConstraints, ImmutableSet<Variable> variables) {
        return child.inferFunctionalDependencies();
    }

    @Override
    public VariableNonRequirement computeVariableNonRequirement(IQTree child) {
        return child.getVariableNonRequirement();
    }

    @Override
    public void acceptVisitor(QueryNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public SliceNode acceptNodeTransformer(HomogeneousQueryNodeTransformer transformer) throws QueryNodeTransformationException {
        return transformer.transform(this);
    }

    @Override
    public ImmutableSet<Variable> getLocallyRequiredVariables() {
        return ImmutableSet.of();
    }

    @Override
    public ImmutableSet<Variable> getLocallyDefinedVariables() {
        return ImmutableSet.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SliceNodeImpl) {
            SliceNodeImpl that = (SliceNodeImpl)o;
            return this.offset == that.offset && Objects.equals(this.limit, that.limit);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.offset, this.limit);
    }

    @Override
    public ImmutableSet<Variable> getLocalVariables() {
        return ImmutableSet.of();
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public Optional<Long> getLimit() {
        return Optional.ofNullable(this.limit);
    }

    public String toString() {
        return SLICE_STR + (String)(this.offset > 0L ? " offset=" + this.offset : "") + (String)(this.limit == null ? "" : " limit=" + this.limit);
    }

    @Override
    public IQTree propagateDownConstraint(ImmutableExpression constraint, IQTree child, VariableGenerator variableGenerator) {
        return this.iqFactory.createUnaryIQTree(this, child);
    }
}

