/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.impl;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.IQTreeCache;
import it.unibz.inf.ontop.iq.NaryIQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.iq.exception.QueryNodeSubstitutionException;
import it.unibz.inf.ontop.iq.exception.QueryNodeTransformationException;
import it.unibz.inf.ontop.iq.impl.IQTreeTools;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.QueryNodeVisitor;
import it.unibz.inf.ontop.iq.node.TrueNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.node.ValuesNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.CompositeQueryNodeImpl;
import it.unibz.inf.ontop.iq.node.normalization.NotRequiredVariableRemover;
import it.unibz.inf.ontop.iq.request.FunctionalDependencies;
import it.unibz.inf.ontop.iq.request.VariableNonRequirement;
import it.unibz.inf.ontop.iq.transform.IQTreeExtendedTransformer;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.node.HomogeneousQueryNodeTransformer;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.IncrementalEvaluation;
import it.unibz.inf.ontop.model.term.NonGroundFunctionalTerm;
import it.unibz.inf.ontop.model.term.NonGroundTerm;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class UnionNodeImpl
extends CompositeQueryNodeImpl
implements UnionNode {
    private static final String UNION_NODE_STR = "UNION";
    private final ImmutableSet<Variable> projectedVariables;
    private final IQTreeTools iqTreeTools;
    private final CoreUtilsFactory coreUtilsFactory;
    private final NotRequiredVariableRemover notRequiredVariableRemover;

    @AssistedInject
    private UnionNodeImpl(@Assisted ImmutableSet<Variable> projectedVariables, IntermediateQueryFactory iqFactory, SubstitutionFactory substitutionFactory, TermFactory termFactory, CoreUtilsFactory coreUtilsFactory, IQTreeTools iqTreeTools, NotRequiredVariableRemover notRequiredVariableRemover) {
        super(substitutionFactory, termFactory, iqFactory, iqTreeTools);
        this.projectedVariables = projectedVariables;
        this.iqTreeTools = iqTreeTools;
        this.coreUtilsFactory = coreUtilsFactory;
        this.notRequiredVariableRemover = notRequiredVariableRemover;
    }

    @Override
    public void acceptVisitor(QueryNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public UnionNode acceptNodeTransformer(HomogeneousQueryNodeTransformer transformer) throws QueryNodeTransformationException {
        return transformer.transform(this);
    }

    @Override
    public ImmutableSet<Substitution<NonVariableTerm>> getPossibleVariableDefinitions(ImmutableList<IQTree> children) {
        return (ImmutableSet)children.stream().flatMap(c -> c.getPossibleVariableDefinitions().stream()).map(s -> s.restrictDomainTo((Set<Variable>)this.projectedVariables)).collect(ImmutableCollectors.toSet());
    }

    @Override
    public boolean hasAChildWithLiftableDefinition(Variable variable, ImmutableList<IQTree> children) {
        return children.stream().anyMatch(c -> c.getRootNode() instanceof ConstructionNode && ((ConstructionNode)c.getRootNode()).getSubstitution().isDefining(variable));
    }

    @Override
    public VariableNullability getVariableNullability(ImmutableList<IQTree> children) {
        ImmutableSet variableNullabilities = (ImmutableSet)children.stream().map(IQTree::getVariableNullability).collect(ImmutableCollectors.toSet());
        ImmutableMultimap multimap = variableNullabilities.stream().flatMap(vn -> vn.getNullableGroups().stream()).flatMap(g -> g.stream().map(v -> Maps.immutableEntry((Object)v, (Object)g))).collect(ImmutableCollectors.toMultimap());
        ImmutableMap<Variable, ImmutableSet> preselectedGroupMap = multimap.asMap().entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> UnionNodeImpl.intersectionOfAll((Collection)e.getValue())));
        ImmutableSet nullableGroups = (ImmutableSet)preselectedGroupMap.keySet().stream().map(v -> this.computeNullableGroup((Variable)v, (ImmutableMap<Variable, ImmutableSet<Variable>>)preselectedGroupMap, (ImmutableSet<VariableNullability>)variableNullabilities)).collect(ImmutableCollectors.toSet());
        ImmutableSet<Variable> scope = this.iqTreeTools.getChildrenVariables(children);
        return this.coreUtilsFactory.createVariableNullability((ImmutableSet<ImmutableSet<Variable>>)nullableGroups, scope);
    }

    private ImmutableSet<Variable> computeNullableGroup(Variable mainVariable, ImmutableMap<Variable, ImmutableSet<Variable>> preselectedGroupMap, ImmutableSet<VariableNullability> variableNullabilities) {
        return (ImmutableSet)((ImmutableSet)preselectedGroupMap.get((Object)mainVariable)).stream().filter(v -> mainVariable.equals(v) || ((ImmutableSet)preselectedGroupMap.get(v)).contains((Object)mainVariable) && variableNullabilities.stream().allMatch(vn -> vn.isPossiblyNullable(mainVariable) == vn.isPossiblyNullable((Variable)v))).collect(ImmutableCollectors.toSet());
    }

    private static ImmutableSet<Variable> intersectionOfAll(Collection<ImmutableSet<Variable>> groups) {
        return groups.stream().reduce((g1, g2) -> Sets.intersection((Set)g1, (Set)g2).immutableCopy()).orElseThrow(() -> new IllegalArgumentException("groups must not be empty"));
    }

    @Override
    public boolean isConstructed(Variable variable, ImmutableList<IQTree> children) {
        return children.stream().anyMatch(c -> c.isConstructed(variable));
    }

    @Override
    public boolean isDistinct(IQTree tree, ImmutableList<IQTree> children) {
        if (children.stream().anyMatch(c -> !c.isDistinct())) {
            return false;
        }
        return IntStream.range(0, children.size()).allMatch(i -> children.subList(i + 1, children.size()).stream().allMatch(o -> this.areDisjoint((IQTree)children.get(i), (IQTree)o)));
    }

    private boolean areDisjoint(IQTree child1, IQTree child2) {
        return this.areDisjoint(child1, child2, this.projectedVariables);
    }

    private boolean areDisjoint(IQTree child1, IQTree child2, ImmutableSet<Variable> variables) {
        VariableNullability variableNullability1 = child1.getVariableNullability();
        VariableNullability variableNullability2 = child2.getVariableNullability();
        ImmutableSet<Substitution<NonVariableTerm>> possibleDefs1 = child1.getPossibleVariableDefinitions();
        ImmutableSet<Substitution<NonVariableTerm>> possibleDefs2 = child2.getPossibleVariableDefinitions();
        return variables.stream().filter(v -> !variableNullability1.isPossiblyNullable((Variable)v) || !variableNullability2.isPossiblyNullable((Variable)v)).anyMatch(v -> this.areDisjointWhenNonNull(this.extractDefs(possibleDefs1, (Variable)v), this.extractDefs(possibleDefs2, (Variable)v), variableNullability1));
    }

    @Override
    public IQTree makeDistinct(ImmutableList<IQTree> children) {
        ImmutableMap<IQTree, ImmutableSet<IQTree>> compatibilityMap = this.extractCompatibilityMap(children);
        if (this.areGroupDisjoint(compatibilityMap)) {
            ImmutableList newChildren = (ImmutableList)ImmutableSet.copyOf((Collection)compatibilityMap.values()).stream().map(this::makeDistinctGroup).collect(ImmutableCollectors.toList());
            return this.makeDistinctGroupTree((ImmutableList<IQTree>)newChildren);
        }
        return this.makeDistinctGroup((ImmutableSet<IQTree>)ImmutableSet.copyOf(children));
    }

    private ImmutableMap<IQTree, ImmutableSet<IQTree>> extractCompatibilityMap(ImmutableList<IQTree> children) {
        return IntStream.range(0, children.size()).boxed().flatMap(i -> IntStream.range(i, children.size()).boxed().flatMap(j -> i.equals(j) || !this.areDisjoint((IQTree)children.get(i.intValue()), (IQTree)children.get(j.intValue())) ? Stream.of(Maps.immutableEntry((Object)((IQTree)children.get(i.intValue())), (Object)((IQTree)children.get(j.intValue()))), Maps.immutableEntry((Object)((IQTree)children.get(j.intValue())), (Object)((IQTree)children.get(i.intValue())))) : Stream.empty())).collect(ImmutableCollectors.toMultimap()).asMap().entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> ImmutableSet.copyOf((Collection)((Collection)e.getValue()))));
    }

    private IQTree makeDistinctGroup(ImmutableSet<IQTree> childGroup) {
        return this.iqFactory.createUnaryIQTree(this.iqFactory.createDistinctNode(), this.makeDistinctGroupTree((ImmutableList<IQTree>)ImmutableList.copyOf(childGroup)));
    }

    private IQTree makeDistinctGroupTree(ImmutableList<IQTree> list) {
        switch (list.size()) {
            case 0: {
                throw new MinorOntopInternalBugException("Unexpected empty child group");
            }
            case 1: {
                return (IQTree)list.get(0);
            }
        }
        return this.iqFactory.createNaryIQTree(this, list);
    }

    private boolean areGroupDisjoint(ImmutableMap<IQTree, ImmutableSet<IQTree>> compatibilityMap) {
        return compatibilityMap.values().stream().allMatch(g -> g.stream().allMatch(t -> ((ImmutableSet)compatibilityMap.get(t)).equals(g)));
    }

    private ImmutableSet<ImmutableTerm> extractDefs(ImmutableSet<Substitution<NonVariableTerm>> possibleDefs, Variable v) {
        if (possibleDefs.isEmpty()) {
            return ImmutableSet.of((Object)v);
        }
        return (ImmutableSet)possibleDefs.stream().map(s -> s.apply(v)).collect(ImmutableCollectors.toSet());
    }

    private boolean areDisjointWhenNonNull(ImmutableSet<ImmutableTerm> defs1, ImmutableSet<ImmutableTerm> defs2, VariableNullability variableNullability) {
        return defs1.stream().allMatch(d1 -> defs2.stream().allMatch(d2 -> this.areDisjointWhenNonNull((ImmutableTerm)d1, (ImmutableTerm)d2, variableNullability)));
    }

    private boolean areDisjointWhenNonNull(ImmutableTerm t1, ImmutableTerm t2, VariableNullability variableNullability) {
        IncrementalEvaluation evaluation = t1.evaluateStrictEq(t2, variableNullability);
        switch (evaluation.getStatus()) {
            case SIMPLIFIED_EXPRESSION: {
                return evaluation.getNewExpression().orElseThrow(() -> new MinorOntopInternalBugException("An expression was expected")).evaluate2VL(variableNullability).isEffectiveFalse();
            }
            case IS_NULL: 
            case IS_FALSE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public IQTree liftIncompatibleDefinitions(Variable variable, ImmutableList<IQTree> children, VariableGenerator variableGenerator) {
        ImmutableList liftedChildren = (ImmutableList)children.stream().map(c -> c.liftIncompatibleDefinitions(variable, variableGenerator)).collect(ImmutableCollectors.toList());
        return this.iqFactory.createNaryIQTree(this, (ImmutableList<IQTree>)liftedChildren);
    }

    @Override
    public IQTree propagateDownConstraint(ImmutableExpression constraint, ImmutableList<IQTree> children, VariableGenerator variableGenerator) {
        return this.iqFactory.createNaryIQTree(this, (ImmutableList<IQTree>)((ImmutableList)children.stream().map(c -> c.propagateDownConstraint(constraint, variableGenerator)).collect(ImmutableCollectors.toList())));
    }

    @Override
    public IQTree acceptTransformer(IQTree tree, IQTreeVisitingTransformer transformer, ImmutableList<IQTree> children) {
        return transformer.transformUnion(tree, this, children);
    }

    @Override
    public <T> IQTree acceptTransformer(IQTree tree, IQTreeExtendedTransformer<T> transformer, ImmutableList<IQTree> children, T context) {
        return transformer.transformUnion(tree, this, children, context);
    }

    @Override
    public <T> T acceptVisitor(IQVisitor<T> visitor, ImmutableList<IQTree> children) {
        return visitor.visitUnion(this, children);
    }

    @Override
    public void validateNode(ImmutableList<IQTree> children) throws InvalidIntermediateQueryException {
        if (children.size() < 2) {
            throw new InvalidIntermediateQueryException("UNION node " + this + " does not have at least 2 children node.");
        }
        ImmutableSet<Variable> unionVariables = this.getVariables();
        for (IQTree child : children) {
            if (child.getVariables().equals(unionVariables)) continue;
            throw new InvalidIntermediateQueryException("This child " + child + " does not project exactly all the variables of the UNION node (" + unionVariables + ")\n" + this);
        }
    }

    @Override
    public IQTree removeDistincts(ImmutableList<IQTree> children, IQTreeCache treeCache) {
        ImmutableList newChildren = (ImmutableList)children.stream().map(IQTree::removeDistincts).collect(ImmutableCollectors.toList());
        IQTreeCache newTreeCache = treeCache.declareDistinctRemoval(newChildren.equals(children));
        return this.iqFactory.createNaryIQTree(this, (ImmutableList<IQTree>)newChildren, newTreeCache);
    }

    @Override
    public ImmutableSet<ImmutableSet<Variable>> inferUniqueConstraints(ImmutableList<IQTree> children) {
        int childrenCount = children.size();
        if (childrenCount < 2) {
            throw new InvalidIntermediateQueryException("At least 2 children are expected for a union");
        }
        IQTree firstChild = (IQTree)children.get(0);
        ImmutableMap<Boolean, ImmutableList<ImmutableSet>> ucsPartitionedByDisjointness = firstChild.inferUniqueConstraints().stream().filter(uc -> children.stream().skip(1L).allMatch(c -> c.inferUniqueConstraints().contains(uc))).collect(ImmutableCollectors.partitioningBy(uc -> this.areDisjoint(children, (ImmutableSet<Variable>)uc)));
        if (((ImmutableList)ucsPartitionedByDisjointness.get((Object)false)).isEmpty()) {
            return ImmutableSet.copyOf((Collection)((Collection)ucsPartitionedByDisjointness.get((Object)true)));
        }
        ImmutableSet disjointVariables = (ImmutableSet)firstChild.getVariables().stream().filter(v -> this.areDisjoint(children, (ImmutableSet<Variable>)ImmutableSet.of((Object)v))).filter(v -> ((ImmutableList)ucsPartitionedByDisjointness.get((Object)true)).stream().noneMatch(set -> set.size() == 1 && ((Variable)set.stream().findFirst().get()).equals(v))).collect(ImmutableCollectors.toSet());
        return (ImmutableSet)Stream.concat(((ImmutableList)ucsPartitionedByDisjointness.get((Object)true)).stream(), ((ImmutableList)ucsPartitionedByDisjointness.get((Object)false)).stream().flatMap(uc -> disjointVariables.stream().map(v -> Sets.union((Set)uc, (Set)ImmutableSet.of((Object)v)).immutableCopy()))).collect(ImmutableCollectors.toSet());
    }

    @Override
    public FunctionalDependencies inferFunctionalDependencies(ImmutableList<IQTree> children, ImmutableSet<ImmutableSet<Variable>> uniqueConstraints, ImmutableSet<Variable> variables) {
        int childrenCount = children.size();
        if (childrenCount < 2) {
            throw new InvalidIntermediateQueryException("At least 2 children are expected for a union");
        }
        IQTree firstChild = (IQTree)children.get(0);
        FunctionalDependencies mergedDependencies = children.stream().skip(1L).reduce(firstChild.inferFunctionalDependencies(), (fd, c) -> fd.merge(c.inferFunctionalDependencies()), (fd1, fd2) -> fd1.merge((FunctionalDependencies)fd2));
        ImmutableMap<Boolean, ImmutableList<Map.Entry>> fdsPartitionedByDisjointness = mergedDependencies.stream().collect(ImmutableCollectors.partitioningBy(fd -> this.areDisjoint(children, (ImmutableSet<Variable>)((ImmutableSet)fd.getKey()))));
        if (((ImmutableList)fdsPartitionedByDisjointness.get((Object)false)).isEmpty()) {
            return ((ImmutableList)fdsPartitionedByDisjointness.get((Object)true)).stream().collect(FunctionalDependencies.toFunctionalDependencies());
        }
        ImmutableSet disjointVariables = (ImmutableSet)firstChild.getVariables().stream().filter(v -> this.areDisjoint(children, (ImmutableSet<Variable>)ImmutableSet.of((Object)v))).filter(v -> ((ImmutableList)fdsPartitionedByDisjointness.get((Object)true)).stream().noneMatch(entry -> ((ImmutableSet)entry.getKey()).size() == 1 && ((Variable)((ImmutableSet)entry.getKey()).stream().findFirst().get()).equals(v))).collect(ImmutableCollectors.toSet());
        return Stream.concat(((ImmutableList)fdsPartitionedByDisjointness.get((Object)true)).stream(), ((ImmutableList)fdsPartitionedByDisjointness.get((Object)false)).stream().flatMap(fd -> disjointVariables.stream().map(v -> UnionNodeImpl.appendDeterminant(fd, v)))).collect(FunctionalDependencies.toFunctionalDependencies());
    }

    private static Map.Entry<ImmutableSet<Variable>, ImmutableSet<Variable>> appendDeterminant(Map.Entry<ImmutableSet<Variable>, ImmutableSet<Variable>> fd, Variable v) {
        ImmutableSet vSet = ImmutableSet.of((Object)v);
        return Maps.immutableEntry((Object)Sets.union((Set)((Set)fd.getKey()), (Set)vSet).immutableCopy(), (Object)Sets.difference((Set)((Set)fd.getValue()), (Set)vSet).immutableCopy());
    }

    private boolean areDisjoint(ImmutableList<IQTree> children, ImmutableSet<Variable> uc) {
        int childrenCount = children.size();
        return IntStream.range(0, childrenCount).allMatch(i -> IntStream.range(i + 1, childrenCount).allMatch(j -> this.areDisjoint((IQTree)children.get(i), (IQTree)children.get(j), uc)));
    }

    @Override
    public VariableNonRequirement computeVariableNonRequirement(ImmutableList<IQTree> children) {
        return VariableNonRequirement.of(this.getVariables());
    }

    @Override
    public ImmutableSet<Variable> getVariables() {
        return this.projectedVariables;
    }

    @Override
    public ImmutableSet<Variable> getLocalVariables() {
        return this.projectedVariables;
    }

    public String toString() {
        return "UNION " + this.projectedVariables;
    }

    @Override
    public ImmutableSet<Variable> getLocallyRequiredVariables() {
        return this.projectedVariables;
    }

    @Override
    public ImmutableSet<Variable> getLocallyDefinedVariables() {
        return ImmutableSet.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UnionNodeImpl) {
            UnionNodeImpl that = (UnionNodeImpl)o;
            return this.projectedVariables.equals(that.projectedVariables);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.projectedVariables);
    }

    @Override
    public IQTree normalizeForOptimization(ImmutableList<IQTree> children, VariableGenerator variableGenerator, IQTreeCache treeCache) {
        ImmutableList liftedChildren = (ImmutableList)children.stream().map(c -> c.normalizeForOptimization(variableGenerator)).filter(c -> !c.isDeclaredAsEmpty()).map(c -> this.notRequiredVariableRemover.optimize((IQTree)c, this.projectedVariables, variableGenerator)).collect(ImmutableCollectors.toList());
        switch (liftedChildren.size()) {
            case 0: {
                return this.iqFactory.createEmptyNode(this.projectedVariables);
            }
            case 1: {
                return (IQTree)liftedChildren.get(0);
            }
        }
        return this.tryToMergeSomeChildrenInAValuesNode(this.liftBindingFromLiftedChildrenAndFlatten((ImmutableList<IQTree>)liftedChildren, variableGenerator, treeCache), variableGenerator, treeCache);
    }

    @Override
    public IQTree applyDescendingSubstitution(Substitution<? extends VariableOrGroundTerm> descendingSubstitution, Optional<ImmutableExpression> constraint, ImmutableList<IQTree> children, VariableGenerator variableGenerator) {
        ImmutableList updatedChildren = (ImmutableList)children.stream().map(c -> c.applyDescendingSubstitution(descendingSubstitution, constraint, variableGenerator)).filter(c -> !c.isDeclaredAsEmpty()).collect(ImmutableCollectors.toList());
        switch (updatedChildren.size()) {
            case 0: {
                return this.iqFactory.createEmptyNode(this.iqTreeTools.computeNewProjectedVariables(descendingSubstitution, this.projectedVariables));
            }
            case 1: {
                return (IQTree)updatedChildren.get(0);
            }
        }
        UnionNode newRootNode = this.iqFactory.createUnionNode(this.iqTreeTools.computeNewProjectedVariables(descendingSubstitution, this.projectedVariables));
        return this.iqFactory.createNaryIQTree(newRootNode, (ImmutableList<IQTree>)updatedChildren);
    }

    @Override
    public IQTree applyDescendingSubstitutionWithoutOptimizing(Substitution<? extends VariableOrGroundTerm> descendingSubstitution, ImmutableList<IQTree> children, VariableGenerator variableGenerator) {
        ImmutableSet<Variable> updatedProjectedVariables = this.iqTreeTools.computeNewProjectedVariables(descendingSubstitution, this.projectedVariables);
        ImmutableList updatedChildren = (ImmutableList)children.stream().map(c -> c.applyDescendingSubstitutionWithoutOptimizing(descendingSubstitution, variableGenerator)).collect(ImmutableCollectors.toList());
        UnionNode newRootNode = this.iqFactory.createUnionNode(updatedProjectedVariables);
        return this.iqFactory.createNaryIQTree(newRootNode, (ImmutableList<IQTree>)updatedChildren);
    }

    @Override
    public IQTree applyFreshRenaming(InjectiveSubstitution<Variable> renamingSubstitution, ImmutableList<IQTree> children, IQTreeCache treeCache) {
        ImmutableList newChildren = (ImmutableList)children.stream().map(c -> c.applyFreshRenaming(renamingSubstitution)).collect(ImmutableCollectors.toList());
        UnionNode newUnionNode = this.iqFactory.createUnionNode(this.substitutionFactory.apply(renamingSubstitution, this.getVariables()));
        IQTreeCache newTreeCache = treeCache.applyFreshRenaming(renamingSubstitution);
        return this.iqFactory.createNaryIQTree(newUnionNode, (ImmutableList<IQTree>)newChildren, newTreeCache);
    }

    private IQTree liftBindingFromLiftedChildrenAndFlatten(ImmutableList<IQTree> liftedChildren, VariableGenerator variableGenerator, IQTreeCache treeCache) {
        if (liftedChildren.stream().anyMatch(c -> !(c.getRootNode() instanceof ConstructionNode))) {
            return this.iqFactory.createNaryIQTree(this, this.flattenChildren(liftedChildren), treeCache.declareAsNormalizedForOptimizationWithEffect());
        }
        ImmutableList tmpNormalizedChildSubstitutions = (ImmutableList)liftedChildren.stream().map(c -> (ConstructionNode)c.getRootNode()).map(ConstructionNode::getSubstitution).map(s -> s.transform(this::normalizeNullAndRDFConstants)).collect(ImmutableCollectors.toList());
        Substitution<ImmutableTerm> mergedSubstitution = this.projectedVariables.stream().map(v -> this.mergeDefinitions((Variable)v, (ImmutableCollection<Substitution<ImmutableTerm>>)tmpNormalizedChildSubstitutions, variableGenerator).map(d -> Maps.immutableEntry((Object)v, (Object)d))).flatMap(Optional::stream).collect(this.substitutionFactory.toSubstitution());
        if (mergedSubstitution.isEmpty()) {
            return this.iqFactory.createNaryIQTree(this, this.flattenChildren(liftedChildren), treeCache.declareAsNormalizedForOptimizationWithEffect());
        }
        ConstructionNode newRootNode = this.iqFactory.createConstructionNode(this.projectedVariables, mergedSubstitution.transform(ImmutableTerm::simplify));
        ImmutableSet<Variable> unionVariables = newRootNode.getChildVariables();
        UnionNode newUnionNode = this.iqFactory.createUnionNode(unionVariables);
        NaryIQTree unionIQ = this.iqFactory.createNaryIQTree(newUnionNode, (ImmutableList<IQTree>)((ImmutableList)IntStream.range(0, liftedChildren.size()).mapToObj(i -> this.updateChild((UnaryIQTree)liftedChildren.get(i), mergedSubstitution, (Substitution)tmpNormalizedChildSubstitutions.get(i), unionVariables, variableGenerator)).flatMap(this::flattenChild).map(c -> this.iqTreeTools.createConstructionNodeTreeIfNontrivial((IQTree)c, unionVariables)).collect(ImmutableCollectors.toList())));
        return this.iqFactory.createUnaryIQTree(newRootNode, unionIQ).normalizeForOptimization(variableGenerator);
    }

    private ImmutableList<IQTree> flattenChildren(ImmutableList<IQTree> children) {
        ImmutableList flattenedChildren = (ImmutableList)children.stream().flatMap(this::flattenChild).collect(ImmutableCollectors.toList());
        return children.size() == flattenedChildren.size() ? children : flattenedChildren;
    }

    private Stream<IQTree> flattenChild(IQTree child) {
        return child.getRootNode() instanceof UnionNode ? child.getChildren().stream() : Stream.of(child);
    }

    private ImmutableTerm normalizeNullAndRDFConstants(ImmutableTerm definition) {
        if (definition instanceof RDFConstant) {
            RDFConstant constant = (RDFConstant)definition;
            return this.termFactory.getRDFFunctionalTerm(this.termFactory.getDBStringConstant(constant.getValue()), this.termFactory.getRDFTermTypeConstant(constant.getType()));
        }
        if (definition.isNull()) {
            return this.termFactory.getRDFFunctionalTerm(this.termFactory.getNullConstant(), this.termFactory.getNullConstant());
        }
        return definition;
    }

    private Optional<ImmutableTerm> mergeDefinitions(Variable variable, ImmutableCollection<Substitution<ImmutableTerm>> childSubstitutions, VariableGenerator variableGenerator) {
        if (childSubstitutions.stream().anyMatch(s -> !s.isDefining(variable))) {
            return Optional.empty();
        }
        return childSubstitutions.stream().map(s -> s.get(variable)).map(this::normalizeNullAndRDFConstants).map(Optional::of).reduce((od1, od2) -> od1.flatMap(d1 -> od2.flatMap(d2 -> this.combineDefinitions((ImmutableTerm)d1, (ImmutableTerm)d2, variableGenerator, true)))).flatMap(t -> t);
    }

    private Optional<ImmutableTerm> combineDefinitions(ImmutableTerm d1, ImmutableTerm d2, VariableGenerator variableGenerator, boolean topLevel) {
        if (d1.equals(d2)) {
            return Optional.of(d1.isGround() || topLevel && d1 instanceof Variable ? d1 : this.replaceVariablesByFreshOnes((NonGroundTerm)d1, variableGenerator));
        }
        if (d1 instanceof Variable) {
            return topLevel ? Optional.empty() : Optional.of(variableGenerator.generateNewVariableFromVar((Variable)d1));
        }
        if (d2 instanceof Variable) {
            return topLevel ? Optional.empty() : Optional.of(variableGenerator.generateNewVariableFromVar((Variable)d2));
        }
        if (d1 instanceof ImmutableFunctionalTerm && d2 instanceof ImmutableFunctionalTerm) {
            ImmutableFunctionalTerm functionalTerm1 = (ImmutableFunctionalTerm)d1;
            ImmutableFunctionalTerm functionalTerm2 = (ImmutableFunctionalTerm)d2;
            FunctionSymbol firstFunctionSymbol = functionalTerm1.getFunctionSymbol();
            if (!firstFunctionSymbol.equals(functionalTerm2.getFunctionSymbol()) || !firstFunctionSymbol.shouldBeDecomposedInUnion()) {
                return topLevel ? Optional.empty() : Optional.of(variableGenerator.generateNewVariable());
            }
            ImmutableList<? extends ImmutableTerm> arguments1 = functionalTerm1.getTerms();
            ImmutableList<? extends ImmutableTerm> arguments2 = functionalTerm2.getTerms();
            if (arguments1.size() != arguments2.size()) {
                throw new IllegalStateException("Functions have different arities, they cannot be combined");
            }
            ImmutableList newArguments = (ImmutableList)IntStream.range(0, arguments1.size()).mapToObj(i -> this.combineDefinitions((ImmutableTerm)arguments1.get(i), (ImmutableTerm)arguments2.get(i), variableGenerator, false).orElseGet(variableGenerator::generateNewVariable)).collect(ImmutableCollectors.toList());
            return Optional.of(this.termFactory.getImmutableFunctionalTerm(firstFunctionSymbol, (ImmutableList<? extends ImmutableTerm>)newArguments));
        }
        return Optional.empty();
    }

    private NonGroundTerm replaceVariablesByFreshOnes(NonGroundTerm term, VariableGenerator variableGenerator) {
        if (term instanceof Variable) {
            return variableGenerator.generateNewVariableFromVar((Variable)term);
        }
        NonGroundFunctionalTerm functionalTerm = (NonGroundFunctionalTerm)term;
        return this.termFactory.getNonGroundFunctionalTerm(functionalTerm.getFunctionSymbol(), (ImmutableList<ImmutableTerm>)((ImmutableList)functionalTerm.getTerms().stream().map(a -> a instanceof NonGroundTerm ? this.replaceVariablesByFreshOnes((NonGroundTerm)a, variableGenerator) : a).collect(ImmutableCollectors.toList())));
    }

    private IQTree updateChild(UnaryIQTree liftedChildTree, Substitution<ImmutableTerm> mergedSubstitution, Substitution<ImmutableTerm> tmpNormalizedSubstitution, ImmutableSet<Variable> projectedVariables, VariableGenerator variableGenerator) {
        ConstructionNode constructionNode = (ConstructionNode)liftedChildTree.getRootNode();
        ImmutableSet<Variable> formerV = constructionNode.getVariables();
        Substitution normalizedEta = this.substitutionFactory.onImmutableTerms().unifierBuilder(tmpNormalizedSubstitution).unify(mergedSubstitution.stream(), Map.Entry::getKey, Map.Entry::getValue).build().map(eta -> this.substitutionFactory.getPrioritizingRenaming((Substitution<?>)eta, projectedVariables).compose((Substitution<ImmutableTerm>)eta)).orElseThrow(() -> new QueryNodeSubstitutionException("The descending substitution " + mergedSubstitution + " is incompatible with " + tmpNormalizedSubstitution));
        Substitution<ImmutableTerm> newTheta = normalizedEta.builder().restrictDomainTo((Set<Variable>)projectedVariables).transform(ImmutableTerm::simplify).build();
        Substitution<VariableOrGroundTerm> descendingSubstitution = normalizedEta.builder().removeFromDomain((Set<Variable>)tmpNormalizedSubstitution.getDomain()).removeFromDomain((Set<Variable>)Sets.difference(newTheta.getDomain(), formerV)).transform(t -> (VariableOrGroundTerm)t).build();
        IQTree newChild = liftedChildTree.getChild().applyDescendingSubstitution(descendingSubstitution, Optional.empty(), variableGenerator);
        return this.iqTreeTools.createConstructionNodeTreeIfNontrivial(newChild, newTheta, () -> projectedVariables);
    }

    private IQTree tryToMergeSomeChildrenInAValuesNode(IQTree tree, VariableGenerator variableGenerator, IQTreeCache treeCache) {
        QueryNode rootNode = tree.getRootNode();
        if (rootNode instanceof ConstructionNode) {
            IQTree newSubTree;
            IQTree subTree = (IQTree)tree.getChildren().get(0);
            return subTree == (newSubTree = this.tryToMergeSomeChildrenInAValuesNode(subTree, variableGenerator, treeCache, false)) ? tree : this.iqFactory.createUnaryIQTree((ConstructionNode)rootNode, newSubTree, treeCache.declareAsNormalizedForOptimizationWithEffect());
        }
        return this.tryToMergeSomeChildrenInAValuesNode(tree, variableGenerator, treeCache, true);
    }

    private IQTree tryToMergeSomeChildrenInAValuesNode(IQTree tree, VariableGenerator variableGenerator, IQTreeCache treeCache, boolean isRoot) {
        QueryNode rootNode = tree.getRootNode();
        if (!(rootNode instanceof UnionNode)) {
            return tree;
        }
        UnionNode unionNode = (UnionNode)rootNode;
        ImmutableList<IQTree> children = tree.getChildren();
        ImmutableList nonMergedChildren = (ImmutableList)children.stream().filter(t -> !this.isMergeableInValuesNode((IQTree)t)).collect(ImmutableCollectors.toList());
        if (nonMergedChildren.size() >= children.size() - 1) {
            return tree;
        }
        ImmutableList valuesVariables = children.stream().map(IQTree::getRootNode).filter(n -> n instanceof ValuesNode).map(n -> ((ValuesNode)n).getOrderedVariables()).findAny().orElseGet(() -> ImmutableList.copyOf(unionNode.getVariables()));
        ImmutableList values = (ImmutableList)children.stream().filter(this::isMergeableInValuesNode).flatMap(c -> this.extractValues((IQTree)c, (ImmutableList<Variable>)valuesVariables)).collect(ImmutableCollectors.toList());
        IQTree mergedSubTree = this.iqFactory.createValuesNode((ImmutableList<Variable>)valuesVariables, (ImmutableList<ImmutableList<Constant>>)values).normalizeForOptimization(variableGenerator);
        if (nonMergedChildren.isEmpty()) {
            return mergedSubTree;
        }
        ImmutableList newChildren = (ImmutableList)Stream.concat(Stream.of(mergedSubTree), nonMergedChildren.stream()).collect(ImmutableCollectors.toList());
        return isRoot ? this.iqFactory.createNaryIQTree(unionNode, (ImmutableList<IQTree>)newChildren, treeCache.declareAsNormalizedForOptimizationWithEffect()) : this.iqFactory.createNaryIQTree(unionNode, (ImmutableList<IQTree>)newChildren);
    }

    private boolean isMergeableInValuesNode(IQTree tree) {
        QueryNode rootNode = tree.getRootNode();
        if (rootNode instanceof ValuesNode || rootNode instanceof TrueNode) {
            return true;
        }
        if (!(rootNode instanceof ConstructionNode)) {
            return false;
        }
        IQTree child = (IQTree)tree.getChildren().get(0);
        if (!(child instanceof TrueNode) && !(child instanceof ValuesNode)) {
            return false;
        }
        ConstructionNode constructionNode = (ConstructionNode)rootNode;
        return constructionNode.getSubstitution().rangeAllMatch(v -> v instanceof DBConstant || v.isNull());
    }

    private Stream<ImmutableList<Constant>> extractValues(IQTree tree, ImmutableList<Variable> outputOrderedVariables) {
        if (tree instanceof ValuesNode) {
            return this.extractValuesFromValuesNode((ValuesNode)tree, outputOrderedVariables);
        }
        if (tree instanceof TrueNode) {
            return Stream.of(ImmutableList.of());
        }
        QueryNode rootNode = tree.getRootNode();
        if (!(rootNode instanceof ConstructionNode)) {
            throw new MinorOntopInternalBugException("Was expecting either a ValuesNode, a TrueNode or a ConstructionNode");
        }
        Substitution<ImmutableTerm> substitution = ((ConstructionNode)rootNode).getSubstitution();
        IQTree child = (IQTree)tree.getChildren().get(0);
        if (child instanceof TrueNode) {
            return Stream.of((ImmutableList)outputOrderedVariables.stream().map(substitution::get).map(t -> (Constant)t).collect(ImmutableCollectors.toList()));
        }
        if (child instanceof ValuesNode) {
            return this.extractValuesFromValuesNode((ValuesNode)child, outputOrderedVariables, substitution);
        }
        throw new MinorOntopInternalBugException("Unexpected child: " + child);
    }

    private Stream<ImmutableList<Constant>> extractValuesFromValuesNode(ValuesNode valuesNode, ImmutableList<Variable> outputOrderedVariables) {
        ImmutableList<Variable> nodeOrderedVariables = valuesNode.getOrderedVariables();
        if (nodeOrderedVariables.equals(outputOrderedVariables)) {
            return valuesNode.getValues().stream();
        }
        ImmutableList indexes = (ImmutableList)outputOrderedVariables.stream().map(arg_0 -> nodeOrderedVariables.indexOf(arg_0)).collect(ImmutableCollectors.toList());
        return valuesNode.getValues().stream().map(vs -> (ImmutableList)indexes.stream().map(arg_0 -> vs.get(arg_0)).collect(ImmutableCollectors.toList()));
    }

    private Stream<ImmutableList<Constant>> extractValuesFromValuesNode(ValuesNode valuesNode, ImmutableList<Variable> outputOrderedVariables, Substitution<ImmutableTerm> substitution) {
        ImmutableList<Variable> nodeOrderedVariables = valuesNode.getOrderedVariables();
        ImmutableMap<Variable, Integer> indexMap = outputOrderedVariables.stream().collect(ImmutableCollectors.toMap(v -> v, arg_0 -> nodeOrderedVariables.indexOf(arg_0)));
        return valuesNode.getValues().stream().map(vs -> (ImmutableList)outputOrderedVariables.stream().map(v -> {
            int index = (Integer)indexMap.get(v);
            return index == -1 ? (Constant)substitution.get((Variable)v) : (Constant)vs.get(index);
        }).collect(ImmutableCollectors.toList()));
    }
}

