/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.normalization.impl;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.normalization.ConstructionSubstitutionNormalizer;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;
import java.util.Set;

public class ConstructionSubstitutionNormalizerImpl
implements ConstructionSubstitutionNormalizer {
    private final IntermediateQueryFactory iqFactory;
    private final SubstitutionFactory substitutionFactory;

    @Inject
    private ConstructionSubstitutionNormalizerImpl(IntermediateQueryFactory iqFactory, SubstitutionFactory substitutionFactory) {
        this.iqFactory = iqFactory;
        this.substitutionFactory = substitutionFactory;
    }

    public ConstructionSubstitutionNormalizer.ConstructionSubstitutionNormalization normalizeSubstitution(Substitution<?> ascendingSubstitution, ImmutableSet<Variable> projectedVariables) {
        InjectiveSubstitution<Variable> downRenamingSubstitution = this.substitutionFactory.getPrioritizingRenaming(ascendingSubstitution, projectedVariables);
        Substitution<?> reducedAscendingSubstitution = ascendingSubstitution.restrictDomainTo((Set<Variable>)projectedVariables);
        Substitution<ImmutableTerm> newAscendingSubstitution = downRenamingSubstitution.compose(reducedAscendingSubstitution).builder().restrictDomainTo((Set<Variable>)projectedVariables).transform(ImmutableTerm::simplify).build();
        return new ConstructionSubstitutionNormalizationImpl(newAscendingSubstitution, downRenamingSubstitution, projectedVariables);
    }

    public class ConstructionSubstitutionNormalizationImpl
    implements ConstructionSubstitutionNormalizer.ConstructionSubstitutionNormalization {
        private final Substitution<ImmutableTerm> normalizedSubstitution;
        private final InjectiveSubstitution<Variable> downRenamingSubstitution;
        private final ImmutableSet<Variable> projectedVariables;

        private ConstructionSubstitutionNormalizationImpl(Substitution<ImmutableTerm> normalizedSubstitution, InjectiveSubstitution<Variable> downRenamingSubstitution, ImmutableSet<Variable> projectedVariables) {
            this.normalizedSubstitution = normalizedSubstitution;
            this.downRenamingSubstitution = downRenamingSubstitution;
            this.projectedVariables = projectedVariables;
        }

        @Override
        public Optional<ConstructionNode> generateTopConstructionNode() {
            return Optional.of(this.normalizedSubstitution).filter(s -> !s.isEmpty()).map(s -> ConstructionSubstitutionNormalizerImpl.this.iqFactory.createConstructionNode(this.projectedVariables, (Substitution<? extends ImmutableTerm>)s));
        }

        @Override
        public IQTree updateChild(IQTree child, VariableGenerator variableGenerator) {
            return this.downRenamingSubstitution.isEmpty() ? child : child.applyDescendingSubstitution(this.downRenamingSubstitution, Optional.empty(), variableGenerator);
        }

        @Override
        public ImmutableExpression updateExpression(ImmutableExpression expression) {
            return this.downRenamingSubstitution.apply(expression);
        }

        @Override
        public Substitution<ImmutableTerm> getNormalizedSubstitution() {
            return this.normalizedSubstitution;
        }
    }
}

