/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.request.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import it.unibz.inf.ontop.iq.request.FunctionalDependencies;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FunctionalDependenciesImpl
implements FunctionalDependencies {
    private final ImmutableSet<FunctionalDependency> dependencies;

    public FunctionalDependenciesImpl(ImmutableSet<Map.Entry<ImmutableSet<Variable>, ImmutableSet<Variable>>> dependencies) {
        this.dependencies = (ImmutableSet)dependencies.stream().map(entry -> new FunctionalDependency((ImmutableSet<Variable>)((ImmutableSet)entry.getKey()), (ImmutableSet<Variable>)((ImmutableSet)entry.getValue()))).collect(ImmutableCollectors.toSet());
    }

    private static boolean inferTransitiveDependencies(ImmutableSet<Map.Entry<ImmutableSet<Variable>, Set<Variable>>> mutableDependencies) {
        boolean changed = false;
        for (Map.Entry entry : mutableDependencies) {
            for (Map.Entry entry2 : mutableDependencies) {
                if (Sets.difference((Set)((Set)entry.getKey()), (Set)((Set)entry2.getKey())).isEmpty() || Sets.difference((Set)Sets.difference((Set)((Set)entry.getValue()), (Set)((Set)entry2.getKey())), (Set)((Set)entry2.getValue())).isEmpty() || !Sets.union((Set)((Set)entry2.getValue()), (Set)((Set)entry2.getKey())).containsAll((Collection)entry.getKey())) continue;
                ((Set)entry2.getValue()).addAll(Sets.difference((Set)((Set)entry.getValue()), (Set)((Set)entry2.getKey())));
                changed = true;
            }
        }
        return changed;
    }

    @Override
    public Stream<Map.Entry<ImmutableSet<Variable>, ImmutableSet<Variable>>> stream() {
        return this.dependencies.stream().map(fd -> Maps.immutableEntry(fd.determinants, fd.dependents));
    }

    @Override
    public FunctionalDependencies rename(InjectiveSubstitution<Variable> renamingSubstitution, SubstitutionFactory substitutionFactory) {
        return new FunctionalDependenciesImpl((ImmutableSet<Map.Entry<ImmutableSet<Variable>, ImmutableSet<Variable>>>)((ImmutableSet)this.dependencies.stream().map(fd -> fd.rename(renamingSubstitution, substitutionFactory)).map(fd -> Maps.immutableEntry(fd.determinants, fd.dependents)).collect(ImmutableCollectors.toSet()))).complete();
    }

    @Override
    public boolean isEmpty() {
        return this.dependencies.isEmpty();
    }

    @Override
    public FunctionalDependencies concat(FunctionalDependencies other) {
        return new FunctionalDependenciesImpl((ImmutableSet<Map.Entry<ImmutableSet<Variable>, ImmutableSet<Variable>>>)((ImmutableSet)Stream.concat(this.stream(), other.stream()).collect(ImmutableCollectors.toSet()))).complete();
    }

    private ImmutableSet<ImmutableSet<Variable>> mergeDeterminants(ImmutableSet<ImmutableSet<Variable>> left, ImmutableSet<ImmutableSet<Variable>> right) {
        return (ImmutableSet)left.stream().flatMap(l -> right.stream().map(r -> Sets.union((Set)l, (Set)r).immutableCopy())).collect(ImmutableCollectors.toSet());
    }

    @Override
    public FunctionalDependencies merge(FunctionalDependencies other) {
        ImmutableSet allDependents = (ImmutableSet)Streams.concat((Stream[])new Stream[]{this.dependencies.stream().flatMap(fd -> fd.dependents.stream())}).collect(ImmutableCollectors.toSet());
        return allDependents.stream().flatMap(v -> this.mergeDeterminants(this.getDeterminantsOf((Variable)v), other.getDeterminantsOf((Variable)v)).stream().map(d -> Maps.immutableEntry((Object)d, (Object)ImmutableSet.of((Object)v)))).collect(FunctionalDependencies.toFunctionalDependencies());
    }

    @Override
    public boolean contains(ImmutableSet<Variable> determinants, ImmutableSet<Variable> dependents) {
        return this.dependencies.stream().anyMatch(dp -> determinants.containsAll(dp.determinants) && dp.dependents.containsAll((Collection)dependents));
    }

    public String toString() {
        return String.format("[%s]", String.join((CharSequence)"; ", (Iterable)this.dependencies.stream().map(FunctionalDependency::toString).collect(ImmutableCollectors.toList())));
    }

    @Override
    public ImmutableSet<ImmutableSet<Variable>> getDeterminantsOf(Variable variable) {
        return (ImmutableSet)this.dependencies.stream().filter(d -> d.dependents.contains((Object)variable)).map(FunctionalDependency::getDeterminants).collect(ImmutableCollectors.toSet());
    }

    protected FunctionalDependencies complete() {
        ImmutableSet dependencyPairs = (ImmutableSet)this.stream().collect(ImmutableCollectors.toSet());
        ImmutableSet withTransitive = (ImmutableSet)dependencyPairs.stream().map(entry -> Maps.immutableEntry((Object)((ImmutableSet)entry.getKey()), new HashSet((Collection)entry.getValue()))).collect(ImmutableCollectors.toSet());
        while (FunctionalDependenciesImpl.inferTransitiveDependencies((ImmutableSet<Map.Entry<ImmutableSet<Variable>, Set<Variable>>>)withTransitive)) {
        }
        ImmutableSet collectedDependencies = (ImmutableSet)withTransitive.stream().collect(Collectors.groupingBy(Map.Entry::getKey)).entrySet().stream().map(e -> new FunctionalDependency((ImmutableSet<Variable>)((ImmutableSet)e.getKey()), (ImmutableSet<Variable>)ImmutableSet.copyOf((Collection)((List)e.getValue()).stream().reduce(Set.of(), (set, entry) -> Sets.union((Set)set, (Set)((Set)entry.getValue())), (set1, set2) -> Sets.union((Set)set1, (Set)set2))))).collect(ImmutableCollectors.toSet());
        ImmutableMap<FunctionalDependency, ImmutableSet> dependenciesToRemove = collectedDependencies.stream().collect(ImmutableCollectors.toMap(fd -> fd, fd -> (ImmutableSet)collectedDependencies.stream().filter(dependencies2 -> !dependencies2.equals(fd)).filter(dependency2 -> fd.determinants.containsAll(dependency2.determinants)).flatMap(dependency2 -> Sets.intersection(fd.dependents, dependency2.dependents).stream()).collect(ImmutableCollectors.toSet())));
        ImmutableSet packedDependencies = (ImmutableSet)Streams.concat((Stream[])new Stream[]{collectedDependencies.stream().filter(fd -> ((ImmutableSet)dependenciesToRemove.get(fd)).isEmpty()), dependenciesToRemove.entrySet().stream().map(entry -> ((FunctionalDependency)entry.getKey()).removeDependents((ImmutableSet<Variable>)((ImmutableSet)entry.getValue()))).filter(fd -> !fd.dependents.isEmpty())}).filter(fd -> !fd.dependents.isEmpty()).collect(ImmutableCollectors.toSet());
        return new FunctionalDependenciesImpl((ImmutableSet<Map.Entry<ImmutableSet<Variable>, ImmutableSet<Variable>>>)((ImmutableSet)packedDependencies.stream().map(fd -> Maps.immutableEntry(fd.determinants, fd.dependents)).collect(ImmutableCollectors.toSet())));
    }

    public static Collector<Map.Entry<ImmutableSet<Variable>, ImmutableSet<Variable>>, ?, FunctionalDependencies> getCollector() {
        return new FunctionalDependenciesCollector();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FunctionalDependenciesImpl)) {
            return false;
        }
        FunctionalDependenciesImpl fd = (FunctionalDependenciesImpl)obj;
        return fd.dependencies.equals(this.dependencies);
    }

    public int hashCode() {
        return this.dependencies.stream().reduce(0, (sum, n) -> sum ^ n.hashCode(), Integer::sum);
    }

    protected static class FunctionalDependenciesCollector
    implements Collector<Map.Entry<ImmutableSet<Variable>, ImmutableSet<Variable>>, ImmutableSet.Builder<Map.Entry<ImmutableSet<Variable>, ImmutableSet<Variable>>>, FunctionalDependencies> {
        protected FunctionalDependenciesCollector() {
        }

        @Override
        public Supplier<ImmutableSet.Builder<Map.Entry<ImmutableSet<Variable>, ImmutableSet<Variable>>>> supplier() {
            return ImmutableSet::builder;
        }

        @Override
        public BiConsumer<ImmutableSet.Builder<Map.Entry<ImmutableSet<Variable>, ImmutableSet<Variable>>>, Map.Entry<ImmutableSet<Variable>, ImmutableSet<Variable>>> accumulator() {
            return (builder, fd) -> builder.add(fd);
        }

        @Override
        public BinaryOperator<ImmutableSet.Builder<Map.Entry<ImmutableSet<Variable>, ImmutableSet<Variable>>>> combiner() {
            return (builder1, builder2) -> {
                builder1.addAll((Iterable)builder2.build());
                return builder1;
            };
        }

        @Override
        public Function<ImmutableSet.Builder<Map.Entry<ImmutableSet<Variable>, ImmutableSet<Variable>>>, FunctionalDependencies> finisher() {
            return builder -> new FunctionalDependenciesImpl((ImmutableSet<Map.Entry<ImmutableSet<Variable>, ImmutableSet<Variable>>>)builder.build()).complete();
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Set.of(Collector.Characteristics.UNORDERED);
        }
    }

    private static class FunctionalDependency {
        private final ImmutableSet<Variable> determinants;
        private final ImmutableSet<Variable> dependents;

        public FunctionalDependency(ImmutableSet<Variable> determinants, ImmutableSet<Variable> dependents) {
            this.determinants = determinants;
            this.dependents = dependents;
        }

        public ImmutableSet<Variable> getDeterminants() {
            return this.determinants;
        }

        public ImmutableSet<Variable> getDependents() {
            return this.dependents;
        }

        public int hashCode() {
            return this.determinants.hashCode() ^ this.dependents.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FunctionalDependency)) {
                return false;
            }
            FunctionalDependency other = (FunctionalDependency)obj;
            return this.dependents.equals(other.dependents) && this.determinants.equals(other.determinants);
        }

        private FunctionalDependency rename(InjectiveSubstitution<Variable> renamingSubstitution, SubstitutionFactory substitutionFactory) {
            return new FunctionalDependency((ImmutableSet<Variable>)((ImmutableSet)this.determinants.stream().map(vars -> substitutionFactory.apply((Substitution<Variable>)renamingSubstitution, (Variable)vars)).collect(ImmutableCollectors.toSet())), (ImmutableSet<Variable>)((ImmutableSet)this.dependents.stream().map(vars -> substitutionFactory.apply((Substitution<Variable>)renamingSubstitution, (Variable)vars)).collect(ImmutableCollectors.toSet())));
        }

        public FunctionalDependency removeDependents(ImmutableSet<Variable> dependents) {
            return new FunctionalDependency(this.determinants, (ImmutableSet<Variable>)Sets.difference(this.dependents, dependents).immutableCopy());
        }

        public String toString() {
            return String.format("(%s) --> (%s)", String.join((CharSequence)", ", this.determinants.stream().map(Object::toString).collect(Collectors.toList())), String.join((CharSequence)", ", this.dependents.stream().map(Object::toString).collect(Collectors.toList())));
        }
    }
}

