/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.template.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.model.template.Template;
import it.unibz.inf.ontop.model.template.impl.AbstractTemplateFactory;
import it.unibz.inf.ontop.model.template.impl.TemplateParser;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBTypeConversionFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.ObjectStringTemplateFunctionSymbol;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.stream.Collectors;

public abstract class ObjectTemplateFactory
extends AbstractTemplateFactory {
    protected ObjectTemplateFactory(TermFactory termFactory) {
        super(termFactory);
    }

    protected ImmutableList<ImmutableTerm> getTemplateTerms(ImmutableList<Template.Component> components) {
        return (ImmutableList)components.stream().filter(Template.Component::isColumn).map(c -> this.getVariable(c.getComponent())).collect(ImmutableCollectors.toList());
    }

    @Override
    public String serializeTemplateTerm(ImmutableFunctionalTerm functionalTerm) {
        ImmutableList varNames = (ImmutableList)functionalTerm.getTerms().stream().map(DBTypeConversionFunctionSymbol::uncast).filter(t -> t instanceof Variable).map(TemplateParser::termToTemplateComponentString).collect(ImmutableCollectors.toList());
        ObjectStringTemplateFunctionSymbol fs = (ObjectStringTemplateFunctionSymbol)functionalTerm.getFunctionSymbol();
        return fs.getTemplateComponents().stream().map(c -> c.isColumn() ? (String)varNames.get(c.getIndex()) : c.getComponent()).collect(Collectors.joining());
    }

    public static String format(String iriOrBnodeTemplate, ImmutableList<?> args) {
        ImmutableList<Template.Component> components = TemplateParser.getComponents(iriOrBnodeTemplate, true);
        return components.stream().map(c -> c.isColumn() ? args.get(c.getIndex()).toString() : c.getComponent()).collect(Collectors.joining());
    }
}

