/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.inject.Inject;
import it.unibz.inf.ontop.model.template.Template;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.InequalityLabel;
import it.unibz.inf.ontop.model.term.functionsymbol.db.BnodeStringTemplateFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBBooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbolFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBIfElseNullFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBMathBinaryOperator;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBNotFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBStrictEqFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBTypeConversionFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.FalseOrNullFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.IRISafenessDeclarationFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.IRIStringTemplateFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.TrueOrNullFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.BnodeStringTemplateFunctionSymbolWithoutSalt;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.BooleanDBIfElseNullFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DBContainsFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DBFunctionSymbolWithSerializerImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DBHashFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DBIntIndexFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DBIriStringResolverFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DBLikeFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DBSimilarToFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DBStrAfterFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DBStrBeforeFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultDBIfElseNullFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultDBStrEndsWithFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultDBStrStartsWithFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.ExtractFromDateOrTimestampFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.FalseOrNullFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.IRISafenessDeclarationFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.IRIStringTemplateFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NullIgnoringDBGroupConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.SimplifiableTypedNullFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.StrictDBInFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.TemporaryDBTypeConversionToStringFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.TrueOrNullFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.UnaryCastDBFunctionSymbolWithSerializerImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.UnaryDBFunctionSymbolWithSerializerImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TypeFactory;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.IRI;

public abstract class AbstractDBFunctionSymbolFactory
implements DBFunctionSymbolFactory {
    private static final String BNODE_PREFIX = "ontop-bnode-";
    private static final String PLACEHOLDER = "{}";
    private final ImmutableTable<String, Integer, DBFunctionSymbol> predefinedRegularFunctionTable;
    private DBTypeConversionFunctionSymbol temporaryToStringCastFunctionSymbol;
    private DBBooleanFunctionSymbol dbStartsWithFunctionSymbol;
    private DBBooleanFunctionSymbol dbEndsWithFunctionSymbol;
    private DBBooleanFunctionSymbol dbLikeFunctionSymbol;
    private DBBooleanFunctionSymbol dbSimilarToFunctionSymbol;
    private DBIfElseNullFunctionSymbol ifElseNullFunctionSymbol;
    private DBNotFunctionSymbol dbNotFunctionSymbol;
    private DBBooleanFunctionSymbol containsFunctionSymbol;
    private DBFunctionSymbol r2rmlIRISafeEncodeFunctionSymbol;
    private DBFunctionSymbol encodeForURIFunctionSymbol;
    private DBFunctionSymbol strBeforeFunctionSymbol;
    private DBFunctionSymbol strAfterFunctionSymbol;
    private DBFunctionSymbol md5FunctionSymbol;
    private DBFunctionSymbol sha1FunctionSymbol;
    private DBFunctionSymbol sha256FunctionSymbol;
    private DBFunctionSymbol sha384FunctionSymbol;
    private DBFunctionSymbol sha512FunctionSymbol;
    private DBFunctionSymbol yearFromDatetimeFunctionSymbol;
    private DBFunctionSymbol yearFromDateFunctionSymbol;
    private DBFunctionSymbol monthFromDatetimeFunctionSymbol;
    private DBFunctionSymbol monthFromDateFunctionSymbol;
    private DBFunctionSymbol dayFromDatetimeFunctionSymbol;
    private DBFunctionSymbol dayFromDateFunctionSymbol;
    private DBFunctionSymbol hoursFunctionSymbol;
    private DBFunctionSymbol minutesFunctionSymbol;
    private DBFunctionSymbol secondsFunctionSymbol;
    private DBFunctionSymbol weekFunctionSymbol;
    private DBFunctionSymbol quarterFunctionSymbol;
    private DBFunctionSymbol decadeFunctionSymbol;
    private DBFunctionSymbol centuryFunctionSymbol;
    private DBFunctionSymbol millenniumFunctionSymbol;
    private DBFunctionSymbol millisecondsFunctionSymbol;
    private DBFunctionSymbol microsecondsFunctionSymbol;
    private DBFunctionSymbol dateTruncFunctionSymbol;
    private DBFunctionSymbol tzFunctionSymbol;
    private DBFunctionSymbol weeksBetweenFromDateTimeFunctionSymbol;
    private DBFunctionSymbol weeksBetweenFromDateFunctionSymbol;
    private DBFunctionSymbol daysBetweenFromDateTimeFunctionSymbol;
    private DBFunctionSymbol daysBetweenFromDateFunctionSymbol;
    private DBFunctionSymbol hoursBetweenFromDateTimeFunctionSymbol;
    private DBFunctionSymbol minutesBetweenFromDateTimeFunctionSymbol;
    private DBFunctionSymbol secondsBetweenFromDateTimeFunctionSymbol;
    private DBFunctionSymbol millisBetweenFromDateTimeFunctionSymbol;
    private final Map<String, DBFunctionSymbol> extractFunctionSymbolsMap;
    private final Map<String, DBFunctionSymbol> currentDateTimeFunctionSymbolsMap;
    private DBBooleanFunctionSymbol nonStrictNumericEqOperator;
    private DBBooleanFunctionSymbol nonStrictStringEqOperator;
    private DBBooleanFunctionSymbol nonStrictDatetimeEqOperator;
    private DBBooleanFunctionSymbol nonStrictDateEqOperator;
    private DBBooleanFunctionSymbol nonStrictDefaultEqOperator;
    private DBBooleanFunctionSymbol booleanIfElseNullFunctionSymbol;
    private DBFunctionSymbol nonDistinctGroupConcat;
    private DBFunctionSymbol distinctGroupConcat;
    private DBFunctionSymbol rowUniqueStrFct;
    private DBFunctionSymbol rowNumberFct;
    private DBFunctionSymbol rowNumberWithOrderByFct;
    private IRISafenessDeclarationFunctionSymbol iriSafenessDeclarationFunctionSymbol;
    private final Map<DBTermType, DBBooleanFunctionSymbol> jsonIsScalarMap;
    private final Map<DBTermType, DBBooleanFunctionSymbol> jsonIsBooleanMap;
    private final Map<DBTermType, DBBooleanFunctionSymbol> jsonIsNumberMap;
    private final Map<DBTermType, DBBooleanFunctionSymbol> isArrayMap;
    private DBFunctionSymbol checkAndConvertBooleanFunctionSymbol;
    private DBFunctionSymbol checkAndConvertBooleanFromStringFunctionSymbol;
    private DBFunctionSymbol checkAndConvertDoubleFunctionSymbol;
    private DBFunctionSymbol checkAndConvertFloatFunctionSymbol;
    private DBFunctionSymbol checkAndConvertFloatFromBooleanFunctionSymbol;
    private DBFunctionSymbol checkAndConvertFloatFromDoubleFunctionSymbol;
    private DBFunctionSymbol checkAndConvertFloatFromNonFPNumericFunctionSymbol;
    private DBFunctionSymbol checkAndConvertDecimalFunctionSymbol;
    private DBFunctionSymbol checkAndConvertDecimalFromBooleanFunctionSymbol;
    private DBFunctionSymbol checkAndConvertIntegerFunctionSymbol;
    private DBFunctionSymbol checkAndConvertIntegerFromBooleanFunctionSymbol;
    private DBFunctionSymbol checkAndConvertStringFromDecimalFunctionSymbol;
    private DBFunctionSymbol checkAndConvertDateTimeFromDateFunctionSymbol;
    private DBFunctionSymbol checkAndConvertDateTimeFromStringFunctionSymbol;
    private DBFunctionSymbol checkAndConvertDateFromDateTimeFunctionSymbol;
    private DBFunctionSymbol checkAndConvertDateFromStringFunctionSymbol;
    private final Map<DBTermType, DBTypeConversionFunctionSymbol> castMap;
    private ImmutableMap<DBTermType, DBTypeConversionFunctionSymbol> normalizationMap;
    private ImmutableTable<DBTermType, RDFDatatype, DBTypeConversionFunctionSymbol> normalizationTable;
    private ImmutableMap<DBTermType, DBTypeConversionFunctionSymbol> deNormalizationMap;
    private ImmutableTable<DBTermType, RDFDatatype, DBTypeConversionFunctionSymbol> deNormalizationTable;
    private ImmutableTable<Integer, Boolean, DBFunctionSymbol> countTable;
    private final Map<DBTermType, DBTypeConversionFunctionSymbol> simpleCastToDBStringMap;
    private final Map<DBTermType, DBTypeConversionFunctionSymbol> simpleCastFromDBStringMap;
    private final Table<DBTermType, DBTermType, DBTypeConversionFunctionSymbol> otherSimpleCastTable;
    private final Table<String, DBTermType, DBMathBinaryOperator> binaryMathTable;
    private final Table<String, ImmutableList<DBTermType>, DBMathBinaryOperator> binaryMathTableWithInputType;
    private final Map<String, DBMathBinaryOperator> untypedBinaryMathMap;
    private final Map<Integer, DBFunctionSymbol> caseMapWithOrder;
    private final Map<Integer, DBFunctionSymbol> caseMapWithoutOrder;
    private final Map<Integer, DBBooleanFunctionSymbol> booleanCaseMapWithOrder;
    private final Map<Integer, DBBooleanFunctionSymbol> booleanCaseMapWithoutOrder;
    private final Map<Integer, DBStrictEqFunctionSymbol> strictEqMap;
    private final Map<Integer, DBBooleanFunctionSymbol> strictNEqMap;
    private final Map<Integer, FalseOrNullFunctionSymbol> falseOrNullMap;
    private final Map<Integer, TrueOrNullFunctionSymbol> trueOrNullMap;
    private final Map<Integer, StrictDBInFunctionSymbolImpl> strictInMap;
    private final Map<Integer, DBFunctionSymbol> coalesceMap;
    private final Map<Integer, DBBooleanFunctionSymbol> booleanCoalesceMap;
    private final Map<InequalityLabel, DBBooleanFunctionSymbol> numericInequalityMap;
    private final Map<InequalityLabel, DBBooleanFunctionSymbol> booleanInequalityMap;
    private final Map<InequalityLabel, DBBooleanFunctionSymbol> stringInequalityMap;
    private final Map<InequalityLabel, DBBooleanFunctionSymbol> datetimeInequalityMap;
    private final Map<InequalityLabel, DBBooleanFunctionSymbol> dateInequalityMap;
    private final Map<InequalityLabel, DBBooleanFunctionSymbol> defaultInequalityMap;
    private final Map<DBTermType, DBFunctionSymbol> absMap;
    private final Map<DBTermType, DBFunctionSymbol> ceilMap;
    private final Map<DBTermType, DBFunctionSymbol> floorMap;
    private final Map<DBTermType, DBFunctionSymbol> roundMap;
    private final Map<DBTermType, DBFunctionSymbol> typeNullMap;
    private final TypeFactory typeFactory;
    private final DBTermType rootDBType;
    private final DBTermType dbStringType;
    private final DBTermType dbBooleanType;
    private final DBTermType dbIntegerType;
    private final DBTermType dbDecimalType;
    private final DBTermType dbDoubleType;
    private final DBTermType dbDateTimestampType;
    private final DBTermType dbDateType;
    private final Table<String, Integer, DBFunctionSymbol> untypedFunctionTable;
    private final Table<String, Integer, DBBooleanFunctionSymbol> notPredefinedBooleanFunctionTable;
    private final Map<ImmutableList<Template.Component>, IRIStringTemplateFunctionSymbol> iriTemplateMap;
    private final Map<ImmutableList<Template.Component>, BnodeStringTemplateFunctionSymbol> bnodeTemplateMap;
    private final Map<IRI, DBFunctionSymbol> iriStringResolverMap;
    private final Map<DBTermType, DBFunctionSymbol> distinctSumMap;
    private final Map<DBTermType, DBFunctionSymbol> regularSumMap;
    private final Map<DBTermType, DBFunctionSymbol> distinctAvgMap;
    private final Map<DBTermType, DBFunctionSymbol> regularAvgMap;
    private final Map<Map.Entry<DBTermType, Boolean>, DBFunctionSymbol> distinctStdevMap;
    private final Map<Map.Entry<DBTermType, Boolean>, DBFunctionSymbol> regularStdevMap;
    private final Map<Map.Entry<DBTermType, Boolean>, DBFunctionSymbol> distinctVarianceMap;
    private final Map<Map.Entry<DBTermType, Boolean>, DBFunctionSymbol> regularVarianceMap;
    private final Map<DBTermType, DBFunctionSymbol> minMap;
    private final Map<DBTermType, DBFunctionSymbol> maxMap;
    private final Map<DBTermType, DBFunctionSymbol> sampleMap;
    private final AtomicInteger counter = new AtomicInteger();

    protected AbstractDBFunctionSymbolFactory(ImmutableTable<String, Integer, DBFunctionSymbol> predefinedRegularFunctionTable, TypeFactory typeFactory) {
        this.typeFactory = typeFactory;
        DBTypeFactory dbTypeFactory = typeFactory.getDBTypeFactory();
        this.rootDBType = dbTypeFactory.getAbstractRootDBType();
        this.predefinedRegularFunctionTable = predefinedRegularFunctionTable;
        this.dbStringType = dbTypeFactory.getDBStringType();
        this.dbBooleanType = dbTypeFactory.getDBBooleanType();
        this.dbIntegerType = dbTypeFactory.getDBLargeIntegerType();
        this.dbDecimalType = dbTypeFactory.getDBDecimalType();
        this.dbDoubleType = dbTypeFactory.getDBDoubleType();
        this.dbDateTimestampType = dbTypeFactory.getDBDateTimestampType();
        this.dbDateType = dbTypeFactory.getDBDateType();
        this.binaryMathTable = HashBasedTable.create();
        this.binaryMathTableWithInputType = HashBasedTable.create();
        this.untypedFunctionTable = HashBasedTable.create();
        this.notPredefinedBooleanFunctionTable = HashBasedTable.create();
        this.simpleCastToDBStringMap = new ConcurrentHashMap<DBTermType, DBTypeConversionFunctionSymbol>();
        this.simpleCastFromDBStringMap = new ConcurrentHashMap<DBTermType, DBTypeConversionFunctionSymbol>();
        this.otherSimpleCastTable = HashBasedTable.create();
        this.untypedBinaryMathMap = new ConcurrentHashMap<String, DBMathBinaryOperator>();
        this.caseMapWithOrder = new ConcurrentHashMap<Integer, DBFunctionSymbol>();
        this.caseMapWithoutOrder = new ConcurrentHashMap<Integer, DBFunctionSymbol>();
        this.booleanCaseMapWithOrder = new ConcurrentHashMap<Integer, DBBooleanFunctionSymbol>();
        this.booleanCaseMapWithoutOrder = new ConcurrentHashMap<Integer, DBBooleanFunctionSymbol>();
        this.strictEqMap = new ConcurrentHashMap<Integer, DBStrictEqFunctionSymbol>();
        this.strictNEqMap = new ConcurrentHashMap<Integer, DBBooleanFunctionSymbol>();
        this.falseOrNullMap = new ConcurrentHashMap<Integer, FalseOrNullFunctionSymbol>();
        this.trueOrNullMap = new ConcurrentHashMap<Integer, TrueOrNullFunctionSymbol>();
        this.strictInMap = new ConcurrentHashMap<Integer, StrictDBInFunctionSymbolImpl>();
        this.castMap = new ConcurrentHashMap<DBTermType, DBTypeConversionFunctionSymbol>();
        this.iriTemplateMap = new ConcurrentHashMap<ImmutableList<Template.Component>, IRIStringTemplateFunctionSymbol>();
        this.bnodeTemplateMap = new ConcurrentHashMap<ImmutableList<Template.Component>, BnodeStringTemplateFunctionSymbol>();
        this.iriStringResolverMap = new ConcurrentHashMap<IRI, DBFunctionSymbol>();
        this.numericInequalityMap = new ConcurrentHashMap<InequalityLabel, DBBooleanFunctionSymbol>();
        this.booleanInequalityMap = new ConcurrentHashMap<InequalityLabel, DBBooleanFunctionSymbol>();
        this.stringInequalityMap = new ConcurrentHashMap<InequalityLabel, DBBooleanFunctionSymbol>();
        this.datetimeInequalityMap = new ConcurrentHashMap<InequalityLabel, DBBooleanFunctionSymbol>();
        this.dateInequalityMap = new ConcurrentHashMap<InequalityLabel, DBBooleanFunctionSymbol>();
        this.defaultInequalityMap = new ConcurrentHashMap<InequalityLabel, DBBooleanFunctionSymbol>();
        this.coalesceMap = new ConcurrentHashMap<Integer, DBFunctionSymbol>();
        this.booleanCoalesceMap = new ConcurrentHashMap<Integer, DBBooleanFunctionSymbol>();
        this.absMap = new ConcurrentHashMap<DBTermType, DBFunctionSymbol>();
        this.ceilMap = new ConcurrentHashMap<DBTermType, DBFunctionSymbol>();
        this.floorMap = new ConcurrentHashMap<DBTermType, DBFunctionSymbol>();
        this.roundMap = new ConcurrentHashMap<DBTermType, DBFunctionSymbol>();
        this.distinctSumMap = new ConcurrentHashMap<DBTermType, DBFunctionSymbol>();
        this.regularSumMap = new ConcurrentHashMap<DBTermType, DBFunctionSymbol>();
        this.distinctAvgMap = new ConcurrentHashMap<DBTermType, DBFunctionSymbol>();
        this.regularAvgMap = new ConcurrentHashMap<DBTermType, DBFunctionSymbol>();
        this.distinctStdevMap = new ConcurrentHashMap<Map.Entry<DBTermType, Boolean>, DBFunctionSymbol>();
        this.regularStdevMap = new ConcurrentHashMap<Map.Entry<DBTermType, Boolean>, DBFunctionSymbol>();
        this.distinctVarianceMap = new ConcurrentHashMap<Map.Entry<DBTermType, Boolean>, DBFunctionSymbol>();
        this.regularVarianceMap = new ConcurrentHashMap<Map.Entry<DBTermType, Boolean>, DBFunctionSymbol>();
        this.minMap = new ConcurrentHashMap<DBTermType, DBFunctionSymbol>();
        this.maxMap = new ConcurrentHashMap<DBTermType, DBFunctionSymbol>();
        this.sampleMap = new ConcurrentHashMap<DBTermType, DBFunctionSymbol>();
        this.typeNullMap = new ConcurrentHashMap<DBTermType, DBFunctionSymbol>();
        this.extractFunctionSymbolsMap = new ConcurrentHashMap<String, DBFunctionSymbol>();
        this.currentDateTimeFunctionSymbolsMap = new ConcurrentHashMap<String, DBFunctionSymbol>();
        this.isArrayMap = new ConcurrentHashMap<DBTermType, DBBooleanFunctionSymbol>();
        this.jsonIsNumberMap = new ConcurrentHashMap<DBTermType, DBBooleanFunctionSymbol>();
        this.jsonIsBooleanMap = new ConcurrentHashMap<DBTermType, DBBooleanFunctionSymbol>();
        this.jsonIsScalarMap = new ConcurrentHashMap<DBTermType, DBBooleanFunctionSymbol>();
    }

    @Inject
    protected void init() {
        this.normalizationMap = this.createNormalizationMap();
        this.normalizationTable = this.createNormalizationTable();
        this.deNormalizationMap = this.createDenormalizationMap();
        this.deNormalizationTable = this.createDenormalizationTable();
        this.countTable = this.createDBCountTable();
        this.temporaryToStringCastFunctionSymbol = new TemporaryDBTypeConversionToStringFunctionSymbolImpl(this.rootDBType, this.dbStringType);
        this.dbStartsWithFunctionSymbol = this.createStrStartsFunctionSymbol();
        this.dbEndsWithFunctionSymbol = this.createStrEndsFunctionSymbol();
        this.dbLikeFunctionSymbol = this.createLikeFunctionSymbol();
        this.dbSimilarToFunctionSymbol = this.createSimilarToFunctionSymbol();
        this.ifElseNullFunctionSymbol = this.createRegularIfElseNull();
        this.dbNotFunctionSymbol = this.createDBNotFunctionSymbol(this.dbBooleanType);
        this.booleanIfElseNullFunctionSymbol = this.createDBBooleanIfElseNull();
        this.nonStrictNumericEqOperator = this.createNonStrictNumericEquality();
        this.nonStrictStringEqOperator = this.createNonStrictStringEquality();
        this.nonStrictDatetimeEqOperator = this.createNonStrictDatetimeEquality();
        this.nonStrictDateEqOperator = this.createNonStrictDateEquality();
        this.nonStrictDefaultEqOperator = this.createNonStrictDefaultEquality();
        this.r2rmlIRISafeEncodeFunctionSymbol = this.createEncodeURLorIRI(true);
        this.encodeForURIFunctionSymbol = this.createEncodeURLorIRI(false);
        this.strAfterFunctionSymbol = this.createStrAfterFunctionSymbol();
        this.containsFunctionSymbol = this.createContainsFunctionSymbol();
        this.strBeforeFunctionSymbol = this.createStrBeforeFunctionSymbol();
        this.md5FunctionSymbol = this.createMD5FunctionSymbol();
        this.sha1FunctionSymbol = this.createSHA1FunctionSymbol();
        this.sha256FunctionSymbol = this.createSHA256FunctionSymbol();
        this.sha384FunctionSymbol = this.createSHA384FunctionSymbol();
        this.sha512FunctionSymbol = this.createSHA512FunctionSymbol();
        this.yearFromDatetimeFunctionSymbol = this.createYearFromDatetimeFunctionSymbol();
        this.yearFromDateFunctionSymbol = this.createYearFromDateFunctionSymbol();
        this.monthFromDatetimeFunctionSymbol = this.createMonthFromDatetimeFunctionSymbol();
        this.monthFromDateFunctionSymbol = this.createMonthFromDateFunctionSymbol();
        this.dayFromDatetimeFunctionSymbol = this.createDayFromDatetimeFunctionSymbol();
        this.dayFromDateFunctionSymbol = this.createDayFromDateFunctionSymbol();
        this.hoursFunctionSymbol = this.createHoursFunctionSymbol();
        this.minutesFunctionSymbol = this.createMinutesFunctionSymbol();
        this.secondsFunctionSymbol = this.createSecondsFunctionSymbol();
        this.weekFunctionSymbol = this.createWeekFunctionSymbol();
        this.quarterFunctionSymbol = this.createQuarterFunctionSymbol();
        this.decadeFunctionSymbol = this.createDecadeFunctionSymbol();
        this.centuryFunctionSymbol = this.createCenturyFunctionSymbol();
        this.millenniumFunctionSymbol = this.createMillenniumFunctionSymbol();
        this.millisecondsFunctionSymbol = this.createMillisecondsFunctionSymbol();
        this.microsecondsFunctionSymbol = this.createMicrosecondsFunctionSymbol();
        this.dateTruncFunctionSymbol = this.createDateTruncFunctionSymbol();
        this.tzFunctionSymbol = this.createTzFunctionSymbol();
        this.weeksBetweenFromDateTimeFunctionSymbol = this.createWeeksBetweenFromDateTimeFunctionSymbol();
        this.weeksBetweenFromDateFunctionSymbol = this.createWeeksBetweenFromDateFunctionSymbol();
        this.daysBetweenFromDateTimeFunctionSymbol = this.createDaysBetweenFromDateTimeFunctionSymbol();
        this.daysBetweenFromDateFunctionSymbol = this.createDaysBetweenFromDateFunctionSymbol();
        this.hoursBetweenFromDateTimeFunctionSymbol = this.createHoursBetweenFromDateTimeFunctionSymbol();
        this.minutesBetweenFromDateTimeFunctionSymbol = this.createMinutesBetweenFromDateTimeFunctionSymbol();
        this.secondsBetweenFromDateTimeFunctionSymbol = this.createSecondsBetweenFromDateTimeFunctionSymbol();
        this.millisBetweenFromDateTimeFunctionSymbol = this.createMillisBetweenFromDateTimeFunctionSymbol();
        this.nonDistinctGroupConcat = this.createDBGroupConcat(this.dbStringType, false);
        this.distinctGroupConcat = this.createDBGroupConcat(this.dbStringType, true);
        this.rowUniqueStrFct = this.createDBRowUniqueStr();
        this.rowNumberFct = this.createDBRowNumber();
        this.rowNumberWithOrderByFct = this.createDBRowNumberWithOrderBy();
        this.iriSafenessDeclarationFunctionSymbol = new IRISafenessDeclarationFunctionSymbolImpl(this.rootDBType);
        this.checkAndConvertDateFromDateTimeFunctionSymbol = this.createCheckAndConvertDateFromDateTimeFunctionSymbol();
        this.checkAndConvertDateFromStringFunctionSymbol = this.createCheckAndConvertDateFromStringFunctionSymbol();
        this.checkAndConvertBooleanFunctionSymbol = this.createCheckAndConvertBooleanFunctionSymbol();
        this.checkAndConvertBooleanFromStringFunctionSymbol = this.createCheckAndConvertBooleanFromStringFunctionSymbol();
        this.checkAndConvertIntegerFunctionSymbol = this.createCheckAndConvertIntegerFunctionSymbol();
        this.checkAndConvertIntegerFromBooleanFunctionSymbol = this.createCheckAndConvertIntegerFromBooleanFunctionSymbol();
        this.checkAndConvertDecimalFunctionSymbol = this.createCheckAndConvertDecimalFunctionSymbol();
        this.checkAndConvertDecimalFromBooleanFunctionSymbol = this.createCheckAndConvertDecimalFromBooleanFunctionSymbol();
        this.checkAndConvertDoubleFunctionSymbol = this.createCheckAndConvertDoubleFunctionSymbol();
        this.checkAndConvertFloatFunctionSymbol = this.createCheckAndConvertFloatFunctionSymbol();
        this.checkAndConvertFloatFromBooleanFunctionSymbol = this.createCheckAndConvertFloatFromBooleanFunctionSymbol();
        this.checkAndConvertFloatFromDoubleFunctionSymbol = this.createCheckAndConvertFloatFromDoubleFunctionSymbol();
        this.checkAndConvertFloatFromNonFPNumericFunctionSymbol = this.createCheckAndConvertFloatFromNonFPNumericFunctionSymbol();
        this.checkAndConvertStringFromDecimalFunctionSymbol = this.createCheckAndConvertStringFromDecimalFunctionSymbol();
        this.checkAndConvertDateTimeFromDateFunctionSymbol = this.createCheckAndConvertDateTimeFromDateFunctionSymbol();
        this.checkAndConvertDateTimeFromStringFunctionSymbol = this.createCheckAndConvertDateTimeFromStringFunctionSymbol();
    }

    protected ImmutableMap<DBTermType, DBTypeConversionFunctionSymbol> createNormalizationMap() {
        DBTypeFactory dbTypeFactory = this.typeFactory.getDBTypeFactory();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        DBTermType defaultDBDateTimestampType = dbTypeFactory.getDBDateTimestampType();
        DBTypeConversionFunctionSymbol datetimeNormFunctionSymbol = this.createDateTimeNormFunctionSymbol(defaultDBDateTimestampType);
        builder.put((Object)defaultDBDateTimestampType, (Object)datetimeNormFunctionSymbol);
        builder.put((Object)this.dbBooleanType, (Object)this.createBooleanNormFunctionSymbol(this.dbBooleanType));
        DBTermType defaultBinaryType = dbTypeFactory.getDBHexBinaryType();
        DBTypeConversionFunctionSymbol hexBinaryNormFunctionSymbol = this.createHexBinaryNormFunctionSymbol(defaultBinaryType);
        builder.put((Object)defaultBinaryType, (Object)hexBinaryNormFunctionSymbol);
        return builder.build();
    }

    protected ImmutableTable<DBTermType, RDFDatatype, DBTypeConversionFunctionSymbol> createNormalizationTable() {
        return ImmutableTable.of();
    }

    protected ImmutableMap<DBTermType, DBTypeConversionFunctionSymbol> createDenormalizationMap() {
        DBTypeFactory dbTypeFactory = this.typeFactory.getDBTypeFactory();
        DBTermType timestampType = dbTypeFactory.getDBDateTimestampType();
        DBTermType booleanType = dbTypeFactory.getDBBooleanType();
        DBTermType binaryType = dbTypeFactory.getDBHexBinaryType();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        DBTypeConversionFunctionSymbol timestampDenormalization = this.createDateTimeDenormFunctionSymbol(timestampType);
        builder.put((Object)timestampType, (Object)timestampDenormalization);
        builder.put((Object)booleanType, (Object)this.createBooleanDenormFunctionSymbol());
        DBTypeConversionFunctionSymbol hexBinaryDenormFunctionSymbol = this.createHexBinaryDenormFunctionSymbol(binaryType);
        builder.put((Object)binaryType, (Object)hexBinaryDenormFunctionSymbol);
        return builder.build();
    }

    protected ImmutableTable<DBTermType, RDFDatatype, DBTypeConversionFunctionSymbol> createDenormalizationTable() {
        return ImmutableTable.of();
    }

    protected ImmutableTable<Integer, Boolean, DBFunctionSymbol> createDBCountTable() {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        Stream.of(false, true).forEach(isUnary -> Stream.of(false, true).forEach(isDistinct -> builder.put((Object)(isUnary != false ? 1 : 0), isDistinct, (Object)this.createDBCount((boolean)isUnary, (boolean)isDistinct))));
        return builder.build();
    }

    @Override
    public IRIStringTemplateFunctionSymbol getIRIStringTemplateFunctionSymbol(ImmutableList<Template.Component> iriTemplate) {
        return this.iriTemplateMap.computeIfAbsent(iriTemplate, t -> IRIStringTemplateFunctionSymbolImpl.createFunctionSymbol(iriTemplate, this.typeFactory));
    }

    @Override
    public BnodeStringTemplateFunctionSymbol getBnodeStringTemplateFunctionSymbol(ImmutableList<Template.Component> bnodeTemplate) {
        return this.bnodeTemplateMap.computeIfAbsent(bnodeTemplate, t -> BnodeStringTemplateFunctionSymbolWithoutSalt.createFunctionSymbol(bnodeTemplate, this.typeFactory));
    }

    @Override
    public BnodeStringTemplateFunctionSymbol getFreshBnodeStringTemplateFunctionSymbol(int arity) {
        if (arity <= 0) {
            throw new IllegalArgumentException("A positive BNode arity is expected");
        }
        Template.Builder builder = Template.builder();
        builder.string(BNODE_PREFIX + this.counter.incrementAndGet());
        for (int i = 0; i < arity - 1; ++i) {
            builder.placeholder().string("/");
        }
        builder.placeholder();
        return this.getBnodeStringTemplateFunctionSymbol(builder.build());
    }

    @Override
    public DBTypeConversionFunctionSymbol getTemporaryConversionToDBStringFunctionSymbol() {
        return this.temporaryToStringCastFunctionSymbol;
    }

    @Override
    public DBTypeConversionFunctionSymbol getDBCastFunctionSymbol(DBTermType targetType) {
        return this.castMap.computeIfAbsent(targetType, this::createSimpleCastFunctionSymbol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBTypeConversionFunctionSymbol getDBCastFunctionSymbol(DBTermType inputType, DBTermType targetType) {
        if (inputType.equals(this.dbStringType)) {
            if (this.simpleCastFromDBStringMap.containsKey(targetType)) {
                return this.simpleCastFromDBStringMap.get(targetType);
            }
            DBTypeConversionFunctionSymbol castFunctionSymbol = this.createSimpleCastFunctionSymbol(inputType, targetType);
            this.simpleCastFromDBStringMap.put(targetType, castFunctionSymbol);
            return castFunctionSymbol;
        }
        if (targetType.equals(this.dbStringType)) {
            if (this.simpleCastToDBStringMap.containsKey(inputType)) {
                return this.simpleCastToDBStringMap.get(inputType);
            }
            DBTypeConversionFunctionSymbol castFunctionSymbol = this.createSimpleCastFunctionSymbol(inputType, targetType);
            this.simpleCastToDBStringMap.put(inputType, castFunctionSymbol);
            return castFunctionSymbol;
        }
        Table<DBTermType, DBTermType, DBTypeConversionFunctionSymbol> table = this.otherSimpleCastTable;
        synchronized (table) {
            if (this.otherSimpleCastTable.contains((Object)inputType, (Object)targetType)) {
                return (DBTypeConversionFunctionSymbol)this.otherSimpleCastTable.get((Object)inputType, (Object)targetType);
            }
            DBTypeConversionFunctionSymbol castFunctionSymbol = this.createSimpleCastFunctionSymbol(inputType, targetType);
            this.otherSimpleCastTable.put((Object)inputType, (Object)targetType, (Object)castFunctionSymbol);
            return castFunctionSymbol;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBFunctionSymbol getRegularDBFunctionSymbol(String nameInDialect, int arity) {
        String canonicalName = this.canonicalizeRegularFunctionSymbolName(nameInDialect);
        Optional<DBFunctionSymbol> optionalPredefinedSymbol = Optional.ofNullable((DBFunctionSymbol)this.predefinedRegularFunctionTable.get((Object)canonicalName, (Object)arity));
        if (optionalPredefinedSymbol.isPresent()) {
            return optionalPredefinedSymbol.get();
        }
        Table<String, Integer, DBFunctionSymbol> table = this.untypedFunctionTable;
        synchronized (table) {
            Optional<DBFunctionSymbol> optionalUntypedSymbol = Optional.ofNullable((DBFunctionSymbol)this.untypedFunctionTable.get((Object)canonicalName, (Object)arity));
            if (optionalUntypedSymbol.isPresent()) {
                return optionalUntypedSymbol.get();
            }
            DBFunctionSymbol symbol = this.createRegularUntypedFunctionSymbol(canonicalName, arity);
            this.untypedFunctionTable.put((Object)canonicalName, (Object)arity, (Object)symbol);
            return symbol;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBBooleanFunctionSymbol getRegularDBBooleanFunctionSymbol(String nameInDialect, int arity) {
        String canonicalName = this.canonicalizeRegularFunctionSymbolName(nameInDialect);
        Optional<DBFunctionSymbol> optionalRegularSymbol = Optional.ofNullable((DBFunctionSymbol)this.predefinedRegularFunctionTable.get((Object)canonicalName, (Object)arity));
        if (optionalRegularSymbol.isPresent()) {
            DBFunctionSymbol functionSymbol = optionalRegularSymbol.get();
            if (functionSymbol instanceof DBBooleanFunctionSymbol) {
                return (DBBooleanFunctionSymbol)functionSymbol;
            }
            throw new IllegalArgumentException(nameInDialect + " is known not to be a boolean function symbol");
        }
        Table<String, Integer, DBBooleanFunctionSymbol> table = this.notPredefinedBooleanFunctionTable;
        synchronized (table) {
            Optional<DBFunctionSymbol> optionalSymbol = Optional.ofNullable((DBFunctionSymbol)this.notPredefinedBooleanFunctionTable.get((Object)canonicalName, (Object)arity));
            if (optionalSymbol.isPresent()) {
                DBFunctionSymbol functionSymbol = optionalSymbol.get();
                if (functionSymbol instanceof DBBooleanFunctionSymbol) {
                    return (DBBooleanFunctionSymbol)functionSymbol;
                }
                throw new IllegalArgumentException(nameInDialect + " is known not to be a boolean function symbol");
            }
            DBBooleanFunctionSymbol symbol = this.createRegularBooleanFunctionSymbol(canonicalName, arity);
            this.notPredefinedBooleanFunctionTable.put((Object)canonicalName, (Object)arity, (Object)symbol);
            return symbol;
        }
    }

    @Override
    public DBFunctionSymbol getDBCase(int arity, boolean doOrderingMatter) {
        if (arity < 3 || arity % 2 == 0) {
            throw new IllegalArgumentException("Arity of a CASE function symbol must be odd and >= 3");
        }
        return doOrderingMatter ? this.caseMapWithOrder.computeIfAbsent(arity, a -> this.createDBCase(arity, true)) : this.caseMapWithoutOrder.computeIfAbsent(arity, a -> this.createDBCase(arity, false));
    }

    @Override
    public DBBooleanFunctionSymbol getDBBooleanCase(int arity, boolean doOrderingMatter) {
        if (arity < 3 || arity % 2 == 0) {
            throw new IllegalArgumentException("Arity of a CASE function symbol must be odd and >= 3");
        }
        return doOrderingMatter ? this.booleanCaseMapWithOrder.computeIfAbsent(arity, a -> this.createDBBooleanCase(arity, true)) : this.booleanCaseMapWithoutOrder.computeIfAbsent(arity, a -> this.createDBBooleanCase(arity, false));
    }

    @Override
    public DBIfElseNullFunctionSymbol getDBIfElseNull() {
        return this.ifElseNullFunctionSymbol;
    }

    @Override
    public DBBooleanFunctionSymbol getDBBooleanIfElseNull() {
        return this.booleanIfElseNullFunctionSymbol;
    }

    @Override
    public DBStrictEqFunctionSymbol getDBStrictEquality(int arity) {
        if (arity < 2) {
            throw new IllegalArgumentException("Arity of a strict equality must be >= 2");
        }
        return this.strictEqMap.computeIfAbsent(arity, a -> this.createDBStrictEquality(arity));
    }

    @Override
    public DBBooleanFunctionSymbol getDBStrictNEquality(int arity) {
        if (arity < 2) {
            throw new IllegalArgumentException("Arity of a strict equality must be >= 2");
        }
        return this.strictNEqMap.computeIfAbsent(arity, a -> this.createDBStrictNEquality(arity));
    }

    @Override
    public DBBooleanFunctionSymbol getDBNonStrictNumericEquality() {
        return this.nonStrictNumericEqOperator;
    }

    @Override
    public DBBooleanFunctionSymbol getDBNonStrictStringEquality() {
        return this.nonStrictStringEqOperator;
    }

    @Override
    public DBBooleanFunctionSymbol getDBNonStrictDatetimeEquality() {
        return this.nonStrictDatetimeEqOperator;
    }

    @Override
    public DBBooleanFunctionSymbol getDBNonStrictDateEquality() {
        return this.nonStrictDateEqOperator;
    }

    @Override
    public DBBooleanFunctionSymbol getDBNonStrictDefaultEquality() {
        return this.nonStrictDefaultEqOperator;
    }

    @Override
    public DBBooleanFunctionSymbol getDBNumericInequality(InequalityLabel inequalityLabel) {
        return this.numericInequalityMap.computeIfAbsent(inequalityLabel, this::createNumericInequality);
    }

    @Override
    public DBBooleanFunctionSymbol getDBBooleanInequality(InequalityLabel inequalityLabel) {
        return this.booleanInequalityMap.computeIfAbsent(inequalityLabel, this::createBooleanInequality);
    }

    @Override
    public DBBooleanFunctionSymbol getDBStringInequality(InequalityLabel inequalityLabel) {
        return this.stringInequalityMap.computeIfAbsent(inequalityLabel, this::createStringInequality);
    }

    @Override
    public DBBooleanFunctionSymbol getDBDatetimeInequality(InequalityLabel inequalityLabel) {
        return this.datetimeInequalityMap.computeIfAbsent(inequalityLabel, this::createDatetimeInequality);
    }

    @Override
    public DBBooleanFunctionSymbol getDBDateInequality(InequalityLabel inequalityLabel) {
        return this.dateInequalityMap.computeIfAbsent(inequalityLabel, this::createDateInequality);
    }

    @Override
    public DBBooleanFunctionSymbol getDBDefaultInequality(InequalityLabel inequalityLabel) {
        return this.defaultInequalityMap.computeIfAbsent(inequalityLabel, this::createDefaultInequality);
    }

    @Override
    public DBBooleanFunctionSymbol getDBStartsWith() {
        return this.dbStartsWithFunctionSymbol;
    }

    @Override
    public DBBooleanFunctionSymbol getDBEndsWith() {
        return this.dbEndsWithFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getR2RMLIRISafeEncode() {
        return this.r2rmlIRISafeEncodeFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBEncodeForURI() {
        return this.encodeForURIFunctionSymbol;
    }

    @Override
    public DBNotFunctionSymbol getDBNot() {
        return this.dbNotFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBCoalesce(int arity) {
        if (arity < 1) {
            throw new IllegalArgumentException("Minimal arity is 1");
        }
        return this.coalesceMap.computeIfAbsent(arity, this::createCoalesceFunctionSymbol);
    }

    @Override
    public DBBooleanFunctionSymbol getDBBooleanCoalesce(int arity) {
        if (arity < 1) {
            throw new IllegalArgumentException("Minimal arity is 1");
        }
        return this.booleanCoalesceMap.computeIfAbsent(arity, this::createBooleanCoalesceFunctionSymbol);
    }

    @Override
    public FalseOrNullFunctionSymbol getFalseOrNullFunctionSymbol(int arity) {
        return this.falseOrNullMap.computeIfAbsent(arity, this::createFalseOrNullFunctionSymbol);
    }

    @Override
    public TrueOrNullFunctionSymbol getTrueOrNullFunctionSymbol(int arity) {
        return this.trueOrNullMap.computeIfAbsent(arity, this::createTrueOrNullFunctionSymbol);
    }

    @Override
    public DBBooleanFunctionSymbol getDBContains() {
        return this.containsFunctionSymbol;
    }

    @Override
    public DBBooleanFunctionSymbol getStrictDBIn(int arity) {
        return this.strictInMap.computeIfAbsent(arity, this::createStrictInFunctionSymbol);
    }

    @Override
    public DBBooleanFunctionSymbol getDBLike() {
        return this.dbLikeFunctionSymbol;
    }

    @Override
    public DBBooleanFunctionSymbol getDBSimilarTo() {
        return this.dbSimilarToFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBStrBefore() {
        return this.strBeforeFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBStrAfter() {
        return this.strAfterFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBMd5() {
        return this.md5FunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBSha1() {
        return this.sha1FunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBSha256() {
        return this.sha256FunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBSha384() {
        return this.sha384FunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBSha512() {
        return this.sha512FunctionSymbol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBMathBinaryOperator getDBMathBinaryOperator(String dbMathOperatorName, DBTermType dbNumericType) {
        Table<String, DBTermType, DBMathBinaryOperator> table = this.binaryMathTable;
        synchronized (table) {
            DBMathBinaryOperator existingOperator = (DBMathBinaryOperator)this.binaryMathTable.get((Object)dbMathOperatorName, (Object)dbNumericType);
            if (existingOperator != null) {
                return existingOperator;
            }
            DBMathBinaryOperator newOperator = this.createDBBinaryMathOperator(dbMathOperatorName, dbNumericType);
            this.binaryMathTable.put((Object)dbMathOperatorName, (Object)dbNumericType, (Object)newOperator);
            return newOperator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBMathBinaryOperator getDBMathBinaryOperator(String dbMathOperatorName, DBTermType arg1Type, DBTermType arg2Type) {
        ImmutableList types = ImmutableList.of((Object)arg1Type, (Object)arg2Type);
        Table<String, ImmutableList<DBTermType>, DBMathBinaryOperator> table = this.binaryMathTableWithInputType;
        synchronized (table) {
            DBMathBinaryOperator existingOperator = (DBMathBinaryOperator)this.binaryMathTableWithInputType.get((Object)dbMathOperatorName, (Object)types);
            if (existingOperator != null) {
                return existingOperator;
            }
            DBMathBinaryOperator newOperator = this.createDBBinaryMathOperator(dbMathOperatorName, arg1Type, arg2Type);
            this.binaryMathTableWithInputType.put((Object)dbMathOperatorName, (Object)types, (Object)newOperator);
            return newOperator;
        }
    }

    @Override
    public DBMathBinaryOperator getUntypedDBMathBinaryOperator(String dbMathOperatorName) {
        DBMathBinaryOperator existingOperator = this.untypedBinaryMathMap.get(dbMathOperatorName);
        if (existingOperator != null) {
            return existingOperator;
        }
        DBMathBinaryOperator newOperator = this.createUntypedDBBinaryMathOperator(dbMathOperatorName);
        this.untypedBinaryMathMap.put(dbMathOperatorName, newOperator);
        return newOperator;
    }

    @Override
    public Optional<DBFunctionSymbol> getAbs(DBTermType dbTermType) {
        DBFunctionSymbol existingFunctionSymbol = this.absMap.get(dbTermType);
        if (existingFunctionSymbol != null) {
            return Optional.of(existingFunctionSymbol);
        }
        Optional<DBFunctionSymbol> dbFunctionSymbol = this.createAbsFunctionSymbol(dbTermType);
        dbFunctionSymbol.ifPresent(fs -> this.absMap.put(dbTermType, (DBFunctionSymbol)fs));
        return dbFunctionSymbol;
    }

    @Override
    public Optional<DBFunctionSymbol> getCeil(DBTermType dbTermType) {
        DBFunctionSymbol existingFunctionSymbol = this.ceilMap.get(dbTermType);
        if (existingFunctionSymbol != null) {
            return Optional.of(existingFunctionSymbol);
        }
        Optional<DBFunctionSymbol> dbFunctionSymbol = this.createCeilFunctionSymbol(dbTermType);
        dbFunctionSymbol.ifPresent(fs -> this.ceilMap.put(dbTermType, (DBFunctionSymbol)fs));
        return dbFunctionSymbol;
    }

    @Override
    public Optional<DBFunctionSymbol> getFloor(DBTermType dbTermType) {
        DBFunctionSymbol existingFunctionSymbol = this.floorMap.get(dbTermType);
        if (existingFunctionSymbol != null) {
            return Optional.of(existingFunctionSymbol);
        }
        Optional<DBFunctionSymbol> dbFunctionSymbol = this.createFloorFunctionSymbol(dbTermType);
        dbFunctionSymbol.ifPresent(fs -> this.floorMap.put(dbTermType, (DBFunctionSymbol)fs));
        return dbFunctionSymbol;
    }

    @Override
    public Optional<DBFunctionSymbol> getRound(DBTermType dbTermType) {
        DBFunctionSymbol existingFunctionSymbol = this.roundMap.get(dbTermType);
        if (existingFunctionSymbol != null) {
            return Optional.of(existingFunctionSymbol);
        }
        Optional<DBFunctionSymbol> dbFunctionSymbol = this.createRoundFunctionSymbol(dbTermType);
        dbFunctionSymbol.ifPresent(fs -> this.roundMap.put(dbTermType, (DBFunctionSymbol)fs));
        return dbFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBYearFromDatetime() {
        return this.yearFromDatetimeFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBYearFromDate() {
        return this.yearFromDateFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBMonthFromDatetime() {
        return this.monthFromDatetimeFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBMonthFromDate() {
        return this.monthFromDateFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBDayFromDatetime() {
        return this.dayFromDatetimeFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBDayFromDate() {
        return this.dayFromDateFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBHours() {
        return this.hoursFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBWeek() {
        return this.weekFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBQuarter() {
        return this.quarterFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBCentury() {
        return this.centuryFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBDecade() {
        return this.decadeFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBMillennium() {
        return this.millenniumFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBMilliseconds() {
        return this.millisecondsFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBMicroseconds() {
        return this.microsecondsFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBDateTrunc(String datePart) {
        return this.dateTruncFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBMinutes() {
        return this.minutesFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBSeconds() {
        return this.secondsFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBTz() {
        return this.tzFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getExtractFunctionSymbol(String component) {
        return this.extractFunctionSymbolsMap.computeIfAbsent(component, this::createExtractFunctionSymbol);
    }

    @Override
    public DBFunctionSymbol getCurrentDateTimeSymbol(String type) {
        return this.currentDateTimeFunctionSymbolsMap.computeIfAbsent(type, this::createCurrentDateTimeFunctionSymbol);
    }

    @Override
    public DBFunctionSymbol getDBWeeksBetweenFromDateTime() {
        return this.weeksBetweenFromDateTimeFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBWeeksBetweenFromDate() {
        return this.weeksBetweenFromDateFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBDaysBetweenFromDateTime() {
        return this.daysBetweenFromDateTimeFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBDaysBetweenFromDate() {
        return this.daysBetweenFromDateFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBHoursBetweenFromDateTime() {
        return this.hoursBetweenFromDateTimeFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBMinutesBetweenFromDateTime() {
        return this.minutesBetweenFromDateTimeFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBSecondsBetweenFromDateTime() {
        return this.secondsBetweenFromDateTimeFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBMillisBetweenFromDateTime() {
        return this.millisBetweenFromDateTimeFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getTypedNullFunctionSymbol(DBTermType termType) {
        return this.typeNullMap.computeIfAbsent(termType, this::createTypeNullFunctionSymbol);
    }

    @Override
    public DBFunctionSymbol getDBRowUniqueStr() {
        return this.rowUniqueStrFct;
    }

    @Override
    public DBFunctionSymbol getDBRowNumber() {
        return this.rowNumberFct;
    }

    @Override
    public DBFunctionSymbol getDBRowNumberWithOrderBy() {
        return this.rowNumberWithOrderByFct;
    }

    @Override
    public DBFunctionSymbol getDBIriStringResolver(IRI baseIRI) {
        return this.iriStringResolverMap.computeIfAbsent(baseIRI, this::createDBIriStringResolver);
    }

    @Override
    public DBFunctionSymbol getDBCount(int arity, boolean isDistinct) {
        if (arity > 1) {
            throw new IllegalArgumentException("COUNT is 0-ary or unary");
        }
        return (DBFunctionSymbol)this.countTable.get((Object)arity, (Object)isDistinct);
    }

    @Override
    public DBFunctionSymbol getNullIgnoringDBSum(DBTermType dbType, boolean isDistinct) {
        Function<DBTermType, DBFunctionSymbol> creationFct = t -> this.createDBSum(dbType, isDistinct);
        return isDistinct ? this.distinctSumMap.computeIfAbsent(dbType, creationFct) : this.regularSumMap.computeIfAbsent(dbType, creationFct);
    }

    @Override
    public DBFunctionSymbol getDBSum(DBTermType dbType, boolean isDistinct) {
        return this.getNullIgnoringDBSum(dbType, isDistinct);
    }

    @Override
    public DBFunctionSymbol getNullIgnoringDBAvg(DBTermType dbType, boolean isDistinct) {
        Function<DBTermType, DBFunctionSymbol> creationFct = t -> this.createDBAvg(dbType, isDistinct);
        return isDistinct ? this.distinctAvgMap.computeIfAbsent(dbType, creationFct) : this.regularAvgMap.computeIfAbsent(dbType, creationFct);
    }

    @Override
    public DBFunctionSymbol getNullIgnoringDBStdev(DBTermType dbType, boolean isPop, boolean isDistinct) {
        Function<Map.Entry, DBFunctionSymbol> creationFct = entry -> this.createDBStdev(dbType, isPop, isDistinct);
        return isDistinct ? this.distinctStdevMap.computeIfAbsent(Maps.immutableEntry((Object)dbType, (Object)isPop), creationFct) : this.regularStdevMap.computeIfAbsent(Maps.immutableEntry((Object)dbType, (Object)isPop), creationFct);
    }

    @Override
    public DBFunctionSymbol getNullIgnoringDBVariance(DBTermType dbType, boolean isPop, boolean isDistinct) {
        Function<Map.Entry, DBFunctionSymbol> creationFct = entry -> this.createDBVariance(dbType, isPop, isDistinct);
        return isDistinct ? this.distinctVarianceMap.computeIfAbsent(Maps.immutableEntry((Object)dbType, (Object)isPop), creationFct) : this.regularVarianceMap.computeIfAbsent(Maps.immutableEntry((Object)dbType, (Object)isPop), creationFct);
    }

    @Override
    public DBFunctionSymbol getDBMin(DBTermType dbType) {
        return this.minMap.computeIfAbsent(dbType, this::createDBMin);
    }

    @Override
    public DBFunctionSymbol getDBMax(DBTermType dbType) {
        return this.maxMap.computeIfAbsent(dbType, this::createDBMax);
    }

    @Override
    public DBFunctionSymbol getDBSample(DBTermType dbType) {
        return this.sampleMap.computeIfAbsent(dbType, this::createDBSample);
    }

    @Override
    public DBFunctionSymbol getNullIgnoringDBGroupConcat(boolean isDistinct) {
        return isDistinct ? this.distinctGroupConcat : this.nonDistinctGroupConcat;
    }

    @Override
    public DBFunctionSymbol getDBIntIndex(int nbValues) {
        return new DBIntIndexFunctionSymbolImpl(this.dbIntegerType, this.rootDBType, nbValues);
    }

    @Override
    public DBFunctionSymbol getDBJsonElt(ImmutableList<String> path) {
        throw new UnsupportedOperationException("Json support unavailable for this DBMS");
    }

    @Override
    public DBFunctionSymbol getDBJsonEltAsText(ImmutableList<String> path) {
        throw new UnsupportedOperationException("Json support unavailable for this DBMS");
    }

    @Override
    public DBBooleanFunctionSymbol getDBJsonIsScalar(DBTermType dbType) {
        return this.jsonIsScalarMap.computeIfAbsent(dbType, this::createJsonIsScalar);
    }

    @Override
    public DBBooleanFunctionSymbol getDBJsonIsNumber(DBTermType dbType) {
        return this.jsonIsNumberMap.computeIfAbsent(dbType, this::createJsonIsNumber);
    }

    @Override
    public DBBooleanFunctionSymbol getDBJsonIsBoolean(DBTermType dbType) {
        return this.jsonIsBooleanMap.computeIfAbsent(dbType, this::createJsonIsBoolean);
    }

    @Override
    public DBBooleanFunctionSymbol getDBIsArray(DBTermType dbType) {
        return this.isArrayMap.computeIfAbsent(dbType, this::createIsArray);
    }

    @Override
    public IRISafenessDeclarationFunctionSymbol getIRISafenessDeclaration() {
        return this.iriSafenessDeclarationFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol checkAndConvertBoolean() {
        return this.checkAndConvertBooleanFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol checkAndConvertBooleanFromString() {
        return this.checkAndConvertBooleanFromStringFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol checkAndConvertDouble() {
        return this.checkAndConvertDoubleFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol checkAndConvertFloat() {
        return this.checkAndConvertFloatFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol checkAndConvertFloatFromBoolean() {
        return this.checkAndConvertFloatFromBooleanFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol checkAndConvertFloatFromDouble() {
        return this.checkAndConvertFloatFromDoubleFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol checkAndConvertFloatFromNonFPNumeric() {
        return this.checkAndConvertFloatFromNonFPNumericFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol checkAndConvertDecimal() {
        return this.checkAndConvertDecimalFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol checkAndConvertDecimalFromBoolean() {
        return this.checkAndConvertDecimalFromBooleanFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol checkAndConvertInteger() {
        return this.checkAndConvertIntegerFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol checkAndConvertIntegerFromBoolean() {
        return this.checkAndConvertIntegerFromBooleanFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol checkAndConvertStringFromDecimal() {
        return this.checkAndConvertStringFromDecimalFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol checkAndConvertDateTimeFromDate() {
        return this.checkAndConvertDateTimeFromDateFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol checkAndConvertDateTimeFromString() {
        return this.checkAndConvertDateTimeFromStringFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol checkAndConvertDateFromDatetime() {
        return this.checkAndConvertDateFromDateTimeFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol checkAndConvertDateFromString() {
        return this.checkAndConvertDateFromStringFunctionSymbol;
    }

    @Override
    public DBFunctionSymbol getDBArrayAccess() {
        throw new UnsupportedOperationException("Array support unavailable for this DBMS");
    }

    protected abstract DBFunctionSymbol createDBCount(boolean var1, boolean var2);

    protected abstract DBFunctionSymbol createDBSum(DBTermType var1, boolean var2);

    protected abstract DBFunctionSymbol createDBAvg(DBTermType var1, boolean var2);

    protected abstract DBFunctionSymbol createDBStdev(DBTermType var1, boolean var2, boolean var3);

    protected abstract DBFunctionSymbol createDBVariance(DBTermType var1, boolean var2, boolean var3);

    protected abstract DBFunctionSymbol createDBMin(DBTermType var1);

    protected abstract DBFunctionSymbol createDBMax(DBTermType var1);

    protected abstract DBFunctionSymbol createDBSample(DBTermType var1);

    protected DBFunctionSymbol createDBGroupConcat(DBTermType dbStringType, boolean isDistinct) {
        return new NullIgnoringDBGroupConcatFunctionSymbol(dbStringType, isDistinct, (terms, termConverter, termFactory) -> String.format("LISTAGG(%s%s,%s) WITHIN GROUP (ORDER BY %s)", isDistinct ? "DISTINCT " : "", termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)), termConverter.apply((ImmutableTerm)terms.get(0))));
    }

    protected abstract DBTypeConversionFunctionSymbol createDateTimeNormFunctionSymbol(DBTermType var1);

    protected abstract DBTypeConversionFunctionSymbol createBooleanNormFunctionSymbol(DBTermType var1);

    protected abstract DBTypeConversionFunctionSymbol createHexBinaryNormFunctionSymbol(DBTermType var1);

    protected abstract DBTypeConversionFunctionSymbol createDateTimeDenormFunctionSymbol(DBTermType var1);

    protected abstract DBTypeConversionFunctionSymbol createBooleanDenormFunctionSymbol();

    protected abstract DBTypeConversionFunctionSymbol createGeometryNormFunctionSymbol(DBTermType var1);

    protected abstract DBTypeConversionFunctionSymbol createHexBinaryDenormFunctionSymbol(DBTermType var1);

    protected DBBooleanFunctionSymbol createLikeFunctionSymbol() {
        return new DBLikeFunctionSymbolImpl(this.dbBooleanType, this.rootDBType);
    }

    protected DBBooleanFunctionSymbol createSimilarToFunctionSymbol() {
        return new DBSimilarToFunctionSymbolImpl(this.dbBooleanType, this.rootDBType);
    }

    protected DBIfElseNullFunctionSymbol createRegularIfElseNull() {
        return new DefaultDBIfElseNullFunctionSymbol(this.dbBooleanType, this.rootDBType);
    }

    protected DBBooleanFunctionSymbol createStrStartsFunctionSymbol() {
        return new DefaultDBStrStartsWithFunctionSymbol(this.rootDBType, this.dbBooleanType);
    }

    protected DBBooleanFunctionSymbol createStrEndsFunctionSymbol() {
        return new DefaultDBStrEndsWithFunctionSymbol(this.rootDBType, this.dbBooleanType);
    }

    protected DBMathBinaryOperator createDBBinaryMathOperator(String dbMathOperatorName, DBTermType dbNumericType) throws UnsupportedOperationException {
        switch (dbMathOperatorName) {
            case "*": {
                return this.createMultiplyOperator(dbNumericType);
            }
            case "/": {
                return this.createDivideOperator(dbNumericType);
            }
            case "+": {
                return this.createAddOperator(dbNumericType);
            }
            case "-": {
                return this.createSubtractOperator(dbNumericType);
            }
        }
        throw new UnsupportedOperationException("The math operator " + dbMathOperatorName + " is not supported");
    }

    protected DBMathBinaryOperator createDBBinaryMathOperator(String dbMathOperatorName, DBTermType arg1Type, DBTermType arg2Type) throws UnsupportedOperationException {
        DBTermType inferOutputType = this.inferOutputTypeMathOperator(dbMathOperatorName, arg1Type, arg2Type);
        return this.createDBBinaryMathOperator(dbMathOperatorName, inferOutputType);
    }

    protected DBTermType inferOutputTypeMathOperator(String dbMathOperatorName, DBTermType arg1Type, DBTermType arg2Type) {
        if (arg1Type.getCategory().equals((Object)arg2Type.getCategory())) {
            return arg1Type;
        }
        switch (arg1Type.getCategory()) {
            case INTEGER: {
                return arg2Type;
            }
            case FLOAT_DOUBLE: {
                return arg2Type.getCategory() == DBTermType.Category.INTEGER ? arg1Type : arg2Type;
            }
        }
        return arg1Type;
    }

    protected DBMathBinaryOperator createUntypedDBBinaryMathOperator(String dbMathOperatorName) throws UnsupportedOperationException {
        switch (dbMathOperatorName) {
            case "*": {
                return this.createUntypedMultiplyOperator();
            }
            case "/": {
                return this.createUntypedDivideOperator();
            }
            case "+": {
                return this.createUntypedAddOperator();
            }
            case "-": {
                return this.createUntypedSubtractOperator();
            }
        }
        throw new UnsupportedOperationException("The untyped math operator " + dbMathOperatorName + " is not supported");
    }

    protected DBBooleanFunctionSymbol createContainsFunctionSymbol() {
        return new DBContainsFunctionSymbolImpl(this.rootDBType, this.dbBooleanType, this::serializeContains);
    }

    protected DBFunctionSymbol createStrBeforeFunctionSymbol() {
        return new DBStrBeforeFunctionSymbolImpl(this.dbStringType, this.rootDBType, this::serializeStrBefore);
    }

    protected DBFunctionSymbol createStrAfterFunctionSymbol() {
        return new DBStrAfterFunctionSymbolImpl(this.dbStringType, this.rootDBType, this::serializeStrAfter);
    }

    protected FalseOrNullFunctionSymbol createFalseOrNullFunctionSymbol(int arity) {
        return new FalseOrNullFunctionSymbolImpl(arity, this.dbBooleanType);
    }

    protected TrueOrNullFunctionSymbol createTrueOrNullFunctionSymbol(int arity) {
        return new TrueOrNullFunctionSymbolImpl(arity, this.dbBooleanType);
    }

    protected StrictDBInFunctionSymbolImpl createStrictInFunctionSymbol(int arity) {
        return new StrictDBInFunctionSymbolImpl(arity, this.rootDBType, this.dbBooleanType);
    }

    protected DBFunctionSymbol createMD5FunctionSymbol() {
        return new DBHashFunctionSymbolImpl("DB_MD5", this.rootDBType, this.dbStringType, this::serializeMD5);
    }

    protected DBFunctionSymbol createSHA1FunctionSymbol() {
        return new DBHashFunctionSymbolImpl("DB_SHA1", this.rootDBType, this.dbStringType, this::serializeSHA1);
    }

    protected DBFunctionSymbol createSHA256FunctionSymbol() {
        return new DBHashFunctionSymbolImpl("DB_SHA256", this.rootDBType, this.dbStringType, this::serializeSHA256);
    }

    protected DBFunctionSymbol createSHA384FunctionSymbol() {
        return new DBHashFunctionSymbolImpl("DB_SHA384", this.rootDBType, this.dbStringType, this::serializeSHA384);
    }

    protected DBFunctionSymbol createSHA512FunctionSymbol() {
        return new DBHashFunctionSymbolImpl("DB_SHA512", this.rootDBType, this.dbStringType, this::serializeSHA512);
    }

    protected DBFunctionSymbol createYearFromDatetimeFunctionSymbol() {
        return new ExtractFromDateOrTimestampFunctionSymbolImpl("DB_YEAR_FROM_DATETIME", this.rootDBType, this.dbIntegerType, this::serializeYearFromDatetime);
    }

    protected DBFunctionSymbol createYearFromDateFunctionSymbol() {
        return new ExtractFromDateOrTimestampFunctionSymbolImpl("DB_YEAR_FROM_DATE", this.rootDBType, this.dbIntegerType, this::serializeYearFromDate);
    }

    protected DBFunctionSymbol createMonthFromDatetimeFunctionSymbol() {
        return new ExtractFromDateOrTimestampFunctionSymbolImpl("DB_MONTH_FROM_DATETIME", this.rootDBType, this.dbIntegerType, this::serializeMonthFromDatetime);
    }

    protected DBFunctionSymbol createMonthFromDateFunctionSymbol() {
        return new ExtractFromDateOrTimestampFunctionSymbolImpl("DB_MONTH_FROM_DATE", this.rootDBType, this.dbIntegerType, this::serializeMonthFromDate);
    }

    protected DBFunctionSymbol createDayFromDatetimeFunctionSymbol() {
        return new ExtractFromDateOrTimestampFunctionSymbolImpl("DB_DAY_FROM_DATETIME", this.rootDBType, this.dbIntegerType, this::serializeDayFromDatetime);
    }

    protected DBFunctionSymbol createDayFromDateFunctionSymbol() {
        return new ExtractFromDateOrTimestampFunctionSymbolImpl("DB_DAY_FROM_DATE", this.rootDBType, this.dbIntegerType, this::serializeDayFromDate);
    }

    protected DBFunctionSymbol createHoursFunctionSymbol() {
        return new ExtractFromDateOrTimestampFunctionSymbolImpl("DB_HOURS", this.rootDBType, this.dbIntegerType, this::serializeHours);
    }

    protected DBFunctionSymbol createMinutesFunctionSymbol() {
        return new ExtractFromDateOrTimestampFunctionSymbolImpl("DB_MINUTES", this.rootDBType, this.dbIntegerType, this::serializeMinutes);
    }

    protected DBFunctionSymbol createWeekFunctionSymbol() {
        return new ExtractFromDateOrTimestampFunctionSymbolImpl("DB_WEEK", this.rootDBType, this.dbIntegerType, this::serializeWeek);
    }

    protected DBFunctionSymbol createQuarterFunctionSymbol() {
        return new ExtractFromDateOrTimestampFunctionSymbolImpl("DB_QUARTER", this.rootDBType, this.dbIntegerType, this::serializeQuarter);
    }

    protected DBFunctionSymbol createDecadeFunctionSymbol() {
        return new ExtractFromDateOrTimestampFunctionSymbolImpl("DB_DECADE", this.rootDBType, this.dbIntegerType, this::serializeDecade);
    }

    protected DBFunctionSymbol createCenturyFunctionSymbol() {
        return new ExtractFromDateOrTimestampFunctionSymbolImpl("DB_CENTURY", this.rootDBType, this.dbIntegerType, this::serializeCentury);
    }

    protected DBFunctionSymbol createMillenniumFunctionSymbol() {
        return new ExtractFromDateOrTimestampFunctionSymbolImpl("DB_MILLENNIUM", this.rootDBType, this.dbIntegerType, this::serializeMillennium);
    }

    protected DBFunctionSymbol createMillisecondsFunctionSymbol() {
        return new ExtractFromDateOrTimestampFunctionSymbolImpl("DB_MILLISECONDS", this.rootDBType, this.dbDecimalType, this::serializeMilliseconds);
    }

    protected DBFunctionSymbol createMicrosecondsFunctionSymbol() {
        return new ExtractFromDateOrTimestampFunctionSymbolImpl("DB_MICROSECONDS", this.rootDBType, this.dbIntegerType, this::serializeMicroseconds);
    }

    protected DBFunctionSymbol createDateTruncFunctionSymbol() {
        return new DBFunctionSymbolWithSerializerImpl("DB_DATE_TRUNC", ImmutableList.of((Object)this.dbStringType, (Object)this.dbDateType), this.dbDateTimestampType, false, this::serializeDateTrunc){

            @Override
            protected boolean mayReturnNullWithoutNullArguments() {
                return false;
            }
        };
    }

    protected DBFunctionSymbol createSecondsFunctionSymbol() {
        return new UnaryDBFunctionSymbolWithSerializerImpl("DB_SECONDS", this.rootDBType, this.dbDecimalType, false, this::serializeSeconds);
    }

    protected DBFunctionSymbol createTzFunctionSymbol() {
        return new UnaryDBFunctionSymbolWithSerializerImpl("DB_TZ", this.rootDBType, this.dbStringType, false, this::serializeTz);
    }

    protected DBFunctionSymbol createExtractFunctionSymbol(String component) {
        return new UnaryDBFunctionSymbolWithSerializerImpl("EXTRACT_" + component, this.rootDBType, this.rootDBType, false, (t, c, f) -> this.serializeExtract(component, (ImmutableList<? extends ImmutableTerm>)t, c, f));
    }

    protected DBFunctionSymbol createCurrentDateTimeFunctionSymbol(String type) {
        return new DBFunctionSymbolWithSerializerImpl("CURRENT_" + type, (ImmutableList<TermType>)ImmutableList.of(), this.rootDBType, false, (t, c, f) -> this.serializeCurrentDateTime(type, (ImmutableList<? extends ImmutableTerm>)t, c, f));
    }

    protected DBFunctionSymbol createDBRowUniqueStr() {
        return new DBFunctionSymbolWithSerializerImpl("ROW_UNIQUE_STR", ImmutableList.of(), this.dbStringType, true, (t, c, f) -> this.serializeDBRowUniqueStr(c, f)){

            @Override
            public boolean isDeterministic() {
                return false;
            }
        };
    }

    protected DBFunctionSymbol createDBRowNumber() {
        return new DBFunctionSymbolWithSerializerImpl("ROW_NUMBER", (ImmutableList<TermType>)ImmutableList.of(), this.dbIntegerType, true, (t, c, f) -> this.serializeDBRowNumber(c, f));
    }

    protected DBFunctionSymbol createDBRowNumberWithOrderBy() {
        return new UnaryDBFunctionSymbolWithSerializerImpl("ROW_NUMBER_WITH_ORDERBY", this.rootDBType, this.dbIntegerType, true, this::serializeDBRowNumberWithOrderBy);
    }

    protected abstract DBMathBinaryOperator createMultiplyOperator(DBTermType var1);

    protected abstract DBMathBinaryOperator createDivideOperator(DBTermType var1);

    protected abstract DBMathBinaryOperator createAddOperator(DBTermType var1);

    protected abstract DBMathBinaryOperator createSubtractOperator(DBTermType var1);

    protected abstract DBMathBinaryOperator createUntypedMultiplyOperator();

    protected abstract DBMathBinaryOperator createUntypedDivideOperator();

    protected abstract DBMathBinaryOperator createUntypedAddOperator();

    protected abstract DBMathBinaryOperator createUntypedSubtractOperator();

    protected abstract DBBooleanFunctionSymbol createNonStrictNumericEquality();

    protected abstract DBBooleanFunctionSymbol createNonStrictStringEquality();

    protected abstract DBBooleanFunctionSymbol createNonStrictDatetimeEquality();

    protected abstract DBBooleanFunctionSymbol createNonStrictDateEquality();

    protected abstract DBBooleanFunctionSymbol createNonStrictDefaultEquality();

    protected abstract DBBooleanFunctionSymbol createNumericInequality(InequalityLabel var1);

    protected abstract DBBooleanFunctionSymbol createBooleanInequality(InequalityLabel var1);

    protected abstract DBBooleanFunctionSymbol createStringInequality(InequalityLabel var1);

    protected abstract DBBooleanFunctionSymbol createDatetimeInequality(InequalityLabel var1);

    protected abstract DBBooleanFunctionSymbol createDateInequality(InequalityLabel var1);

    protected abstract DBBooleanFunctionSymbol createDefaultInequality(InequalityLabel var1);

    protected String canonicalizeRegularFunctionSymbolName(String nameInDialect) {
        return nameInDialect.toUpperCase();
    }

    protected abstract DBFunctionSymbol createRegularUntypedFunctionSymbol(String var1, int var2);

    protected abstract DBBooleanFunctionSymbol createRegularBooleanFunctionSymbol(String var1, int var2);

    protected abstract DBTypeConversionFunctionSymbol createSimpleCastFunctionSymbol(DBTermType var1);

    protected abstract DBTypeConversionFunctionSymbol createSimpleCastFunctionSymbol(DBTermType var1, DBTermType var2);

    protected abstract DBFunctionSymbol createDBCase(int var1, boolean var2);

    protected abstract DBBooleanFunctionSymbol createDBBooleanCase(int var1, boolean var2);

    protected abstract DBFunctionSymbol createCoalesceFunctionSymbol(int var1);

    protected abstract DBBooleanFunctionSymbol createBooleanCoalesceFunctionSymbol(int var1);

    protected DBBooleanFunctionSymbol createDBBooleanIfElseNull() {
        return new BooleanDBIfElseNullFunctionSymbolImpl(this.dbBooleanType);
    }

    protected abstract DBStrictEqFunctionSymbol createDBStrictEquality(int var1);

    protected abstract DBBooleanFunctionSymbol createDBStrictNEquality(int var1);

    protected abstract DBNotFunctionSymbol createDBNotFunctionSymbol(DBTermType var1);

    protected abstract DBFunctionSymbol createEncodeURLorIRI(boolean var1);

    protected abstract Optional<DBFunctionSymbol> createAbsFunctionSymbol(DBTermType var1);

    protected abstract Optional<DBFunctionSymbol> createCeilFunctionSymbol(DBTermType var1);

    protected abstract Optional<DBFunctionSymbol> createFloorFunctionSymbol(DBTermType var1);

    protected abstract Optional<DBFunctionSymbol> createRoundFunctionSymbol(DBTermType var1);

    protected DBFunctionSymbol createTypeNullFunctionSymbol(DBTermType termType) {
        return new SimplifiableTypedNullFunctionSymbol(termType);
    }

    protected DBFunctionSymbol createDBIriStringResolver(IRI baseIRI) {
        return new DBIriStringResolverFunctionSymbolImpl(baseIRI, "^[a-zA-Z]+:", this.rootDBType, this.dbStringType);
    }

    protected abstract String serializeContains(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeStrBefore(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeStrAfter(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeMD5(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeSHA1(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeSHA256(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeSHA384(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeSHA512(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeYearFromDatetime(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeYearFromDate(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeMonthFromDatetime(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeMonthFromDate(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeDayFromDatetime(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeDayFromDate(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeHours(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeMinutes(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeSeconds(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeWeek(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeQuarter(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeDecade(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeCentury(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeMillennium(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeMilliseconds(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeMicroseconds(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeDateTrunc(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeTz(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected String serializeExtract(String component, ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return "EXTRACT(" + component + " FROM " + termConverter.apply((ImmutableTerm)terms.get(0)) + ")";
    }

    protected String serializeCurrentDateTime(String type, ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return "CURRENT_" + type;
    }

    protected abstract String serializeWeeksBetweenFromDateTime(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeWeeksBetweenFromDate(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeDaysBetweenFromDateTime(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeDaysBetweenFromDate(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeHoursBetween(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeMinutesBetween(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeSecondsBetween(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeMillisBetween(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected DBFunctionSymbol createWeeksBetweenFromDateTimeFunctionSymbol() {
        return new DBFunctionSymbolWithSerializerImpl("DB_WEEK_DIFF_FROM_DATETIME", (ImmutableList<TermType>)ImmutableList.of((Object)this.rootDBType, (Object)this.rootDBType), this.dbIntegerType, false, this::serializeWeeksBetweenFromDateTime);
    }

    protected DBFunctionSymbol createWeeksBetweenFromDateFunctionSymbol() {
        return new DBFunctionSymbolWithSerializerImpl("DB_WEEK_DIFF_FROM_DATETIME", (ImmutableList<TermType>)ImmutableList.of((Object)this.rootDBType, (Object)this.rootDBType), this.dbIntegerType, false, this::serializeWeeksBetweenFromDate);
    }

    protected DBFunctionSymbol createDaysBetweenFromDateTimeFunctionSymbol() {
        return new DBFunctionSymbolWithSerializerImpl("DB_DAY_DIFF_FROM_DATETIME", (ImmutableList<TermType>)ImmutableList.of((Object)this.rootDBType, (Object)this.rootDBType), this.dbIntegerType, false, this::serializeDaysBetweenFromDateTime);
    }

    protected DBFunctionSymbol createDaysBetweenFromDateFunctionSymbol() {
        return new DBFunctionSymbolWithSerializerImpl("DB_DAY_DIFF_FROM_DATETIME", (ImmutableList<TermType>)ImmutableList.of((Object)this.rootDBType, (Object)this.rootDBType), this.dbIntegerType, false, this::serializeDaysBetweenFromDate);
    }

    protected DBFunctionSymbol createHoursBetweenFromDateTimeFunctionSymbol() {
        return new DBFunctionSymbolWithSerializerImpl("DB_HOUR_DIFF_FROM_DATETIME", (ImmutableList<TermType>)ImmutableList.of((Object)this.rootDBType, (Object)this.rootDBType), this.dbIntegerType, false, this::serializeHoursBetween);
    }

    protected DBFunctionSymbol createMinutesBetweenFromDateTimeFunctionSymbol() {
        return new DBFunctionSymbolWithSerializerImpl("DB_MINUTE_DIFF_FROM_DATETIME", (ImmutableList<TermType>)ImmutableList.of((Object)this.rootDBType, (Object)this.rootDBType), this.dbIntegerType, false, this::serializeMinutesBetween);
    }

    protected DBFunctionSymbol createSecondsBetweenFromDateTimeFunctionSymbol() {
        return new DBFunctionSymbolWithSerializerImpl("DB_SECOND_DIFF_FROM_DATETIME", (ImmutableList<TermType>)ImmutableList.of((Object)this.rootDBType, (Object)this.rootDBType), this.dbIntegerType, false, this::serializeSecondsBetween);
    }

    protected DBFunctionSymbol createMillisBetweenFromDateTimeFunctionSymbol() {
        return new DBFunctionSymbolWithSerializerImpl("DB_MILLIS_DIFF_FROM_DATETIME", (ImmutableList<TermType>)ImmutableList.of((Object)this.rootDBType, (Object)this.rootDBType), this.dbIntegerType, false, this::serializeMillisBetween);
    }

    protected DBBooleanFunctionSymbol createIsArray(DBTermType dbType) {
        throw new UnsupportedOperationException("Unsupported nested datatype: " + dbType.getName());
    }

    protected DBBooleanFunctionSymbol createJsonIsNumber(DBTermType dbType) {
        throw new UnsupportedOperationException("Unsupported JSON-like datatype: " + dbType.getName());
    }

    protected DBBooleanFunctionSymbol createJsonIsBoolean(DBTermType dbType) {
        throw new UnsupportedOperationException("Unsupported JSON-like datatype: " + dbType.getName());
    }

    protected DBBooleanFunctionSymbol createJsonIsScalar(DBTermType dbType) {
        throw new UnsupportedOperationException("Unsupported JSON-like datatype: " + dbType.getName());
    }

    protected abstract String serializeCheckAndConvertBoolean(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeCheckAndConvertBooleanFromString(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeCheckAndConvertDouble(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeCheckAndConvertFloat(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeCheckAndConvertFloatFromBoolean(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeCheckAndConvertFloatFromDouble(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeCheckAndConvertFloatFromNonFPNumeric(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeCheckAndConvertDecimal(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeCheckAndConvertDecimalFromBoolean(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeCheckAndConvertInteger(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeCheckAndConvertIntegerFromBoolean(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeCheckAndConvertStringFromDecimal(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeCheckAndConvertDateTimeFromDate(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeCheckAndConvertDateTimeFromString(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeCheckAndConvertDateFromDateTime(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected abstract String serializeCheckAndConvertDateFromString(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    protected DBFunctionSymbol createCheckAndConvertBooleanFunctionSymbol() {
        return new UnaryCastDBFunctionSymbolWithSerializerImpl("DB_CHECK_AND_CONVERT_BOOLEAN", this.rootDBType, this.dbBooleanType, false, this::serializeCheckAndConvertBoolean);
    }

    protected DBFunctionSymbol createCheckAndConvertBooleanFromStringFunctionSymbol() {
        return new UnaryCastDBFunctionSymbolWithSerializerImpl("DB_CHECK_AND_CONVERT_BOOLEAN_FROM_STRING", this.dbStringType, this.dbBooleanType, false, this::serializeCheckAndConvertBooleanFromString);
    }

    protected DBFunctionSymbol createCheckAndConvertDoubleFunctionSymbol() {
        return new UnaryCastDBFunctionSymbolWithSerializerImpl("DB_CHECK_AND_CONVERT_DOUBLE", this.rootDBType, this.dbDoubleType, false, this::serializeCheckAndConvertDouble);
    }

    protected DBFunctionSymbol createCheckAndConvertFloatFunctionSymbol() {
        return new UnaryCastDBFunctionSymbolWithSerializerImpl("DB_CHECK_AND_CONVERT_FLOAT", this.rootDBType, this.dbDoubleType, false, this::serializeCheckAndConvertFloat);
    }

    protected DBFunctionSymbol createCheckAndConvertFloatFromBooleanFunctionSymbol() {
        return new UnaryCastDBFunctionSymbolWithSerializerImpl("DB_CHECK_AND_CONVERT_FLOAT_FROM_BOOLEAN", this.dbBooleanType, this.dbDoubleType, false, this::serializeCheckAndConvertFloatFromBoolean);
    }

    protected DBFunctionSymbol createCheckAndConvertFloatFromDoubleFunctionSymbol() {
        return new UnaryCastDBFunctionSymbolWithSerializerImpl("DB_CHECK_AND_CONVERT_FLOAT_FROM_DOUBLE", this.dbDoubleType, this.dbDoubleType, false, this::serializeCheckAndConvertFloatFromDouble);
    }

    protected DBFunctionSymbol createCheckAndConvertFloatFromNonFPNumericFunctionSymbol() {
        return new UnaryCastDBFunctionSymbolWithSerializerImpl("DB_CHECK_AND_CONVERT_FLOAT_FROM_NONFPNUMERIC", this.rootDBType, this.dbDoubleType, false, this::serializeCheckAndConvertFloatFromNonFPNumeric);
    }

    protected DBFunctionSymbol createCheckAndConvertDecimalFunctionSymbol() {
        return new UnaryCastDBFunctionSymbolWithSerializerImpl("DB_CHECK_AND_CONVERT_DECIMAL", this.rootDBType, this.dbDecimalType, false, this::serializeCheckAndConvertDecimal);
    }

    protected DBFunctionSymbol createCheckAndConvertDecimalFromBooleanFunctionSymbol() {
        return new UnaryCastDBFunctionSymbolWithSerializerImpl("DB_CHECK_AND_CONVERT_DECIMAL_FROM_BOOLEAN", this.dbBooleanType, this.dbDecimalType, false, this::serializeCheckAndConvertDecimalFromBoolean);
    }

    protected DBFunctionSymbol createCheckAndConvertIntegerFunctionSymbol() {
        return new UnaryCastDBFunctionSymbolWithSerializerImpl("DB_CHECK_AND_CONVERT_INTEGER", this.rootDBType, this.dbIntegerType, false, this::serializeCheckAndConvertInteger);
    }

    protected DBFunctionSymbol createCheckAndConvertIntegerFromBooleanFunctionSymbol() {
        return new UnaryCastDBFunctionSymbolWithSerializerImpl("DB_CHECK_AND_CONVERT_INTEGER_FROM_BOOLEAN", this.dbBooleanType, this.dbIntegerType, false, this::serializeCheckAndConvertIntegerFromBoolean);
    }

    protected DBFunctionSymbol createCheckAndConvertStringFromDecimalFunctionSymbol() {
        return new UnaryCastDBFunctionSymbolWithSerializerImpl("DB_CHECK_AND_CONVERT_STRING_FROM_DECIMAL", this.dbDecimalType, this.dbStringType, false, this::serializeCheckAndConvertStringFromDecimal);
    }

    protected DBFunctionSymbol createCheckAndConvertDateTimeFromDateFunctionSymbol() {
        return new UnaryCastDBFunctionSymbolWithSerializerImpl("DB_CHECK_AND_CONVERT_DATETIME_FROM_DATE", this.dbDateType, this.dbDateTimestampType, false, this::serializeCheckAndConvertDateTimeFromDate);
    }

    protected DBFunctionSymbol createCheckAndConvertDateTimeFromStringFunctionSymbol() {
        return new UnaryCastDBFunctionSymbolWithSerializerImpl("DB_CHECK_AND_CONVERT_DATETIME_FROM_STRING", this.dbStringType, this.dbDateTimestampType, false, this::serializeCheckAndConvertDateTimeFromString);
    }

    protected DBFunctionSymbol createCheckAndConvertDateFromDateTimeFunctionSymbol() {
        return new UnaryCastDBFunctionSymbolWithSerializerImpl("DB_DATE_FROM_DATETIME", this.dbDateTimestampType, this.dbDateType, false, this::serializeCheckAndConvertDateFromDateTime);
    }

    protected DBFunctionSymbol createCheckAndConvertDateFromStringFunctionSymbol() {
        return new UnaryCastDBFunctionSymbolWithSerializerImpl("DB_DATE_FROM_STRING", this.dbStringType, this.dbDateType, false, this::serializeCheckAndConvertDateFromString);
    }

    protected String serializeDBRowUniqueStr(Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        ImmutableFunctionalTerm newTerm = termFactory.getDBCastFunctionalTerm(this.dbStringType, termFactory.getImmutableFunctionalTerm((FunctionSymbol)this.getDBRowNumber(), new ImmutableTerm[0]));
        return termConverter.apply(newTerm);
    }

    protected abstract String serializeDBRowNumber(Function<ImmutableTerm, String> var1, TermFactory var2);

    protected abstract String serializeDBRowNumberWithOrderBy(ImmutableList<? extends ImmutableTerm> var1, Function<ImmutableTerm, String> var2, TermFactory var3);

    @Override
    public DBTypeConversionFunctionSymbol getConversion2RDFLexicalFunctionSymbol(DBTermType inputType, RDFTermType rdfTermType) {
        return Optional.of(rdfTermType).filter(t -> t instanceof RDFDatatype).map(t -> (RDFDatatype)t).flatMap(t -> Optional.ofNullable((DBTypeConversionFunctionSymbol)this.normalizationTable.get((Object)inputType, t))).orElseGet(() -> Optional.ofNullable((DBTypeConversionFunctionSymbol)this.normalizationMap.get((Object)inputType)).orElseGet(() -> this.getDBCastFunctionSymbol(inputType, this.dbStringType)));
    }

    @Override
    public DBTypeConversionFunctionSymbol getConversionFromRDFLexical2DBFunctionSymbol(DBTermType targetDBType, RDFTermType rdfTermType) {
        return Optional.of(rdfTermType).filter(t -> t instanceof RDFDatatype).map(t -> (RDFDatatype)t).flatMap(t -> Optional.ofNullable((DBTypeConversionFunctionSymbol)this.deNormalizationTable.get((Object)targetDBType, t))).orElseGet(() -> this.getConversionFromRDFLexical2DBFunctionSymbol(targetDBType));
    }

    @Override
    public DBTypeConversionFunctionSymbol getConversionFromRDFLexical2DBFunctionSymbol(DBTermType targetDBType) {
        return Optional.ofNullable((DBTypeConversionFunctionSymbol)this.deNormalizationMap.get((Object)targetDBType)).orElseGet(() -> this.getDBCastFunctionSymbol(this.dbStringType, targetDBType));
    }
}

