/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.InequalityLabel;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DBBooleanFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.TermType;
import java.util.function.Function;

public abstract class AbstractDBInequalityOperator
extends DBBooleanFunctionSymbolImpl {
    private final String template;
    protected final InequalityLabel inequalityLabel;

    protected AbstractDBInequalityOperator(InequalityLabel inequalityLabel, String functionSymbolName, DBTermType rootDBTermType, DBTermType dbBoolean) {
        super(functionSymbolName, (ImmutableList<TermType>)ImmutableList.of((Object)rootDBTermType, (Object)rootDBTermType), dbBoolean);
        this.inequalityLabel = inequalityLabel;
        this.template = "(%s " + inequalityLabel.getMathString() + " %s)";
    }

    @Override
    public String getNativeDBString(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format(this.template, termConverter.apply((ImmutableTerm)terms.get(0)), termConverter.apply((ImmutableTerm)terms.get(1)));
    }

    @Override
    protected boolean tolerateNulls() {
        return false;
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }

    @Override
    public boolean blocksNegation() {
        return false;
    }

    @Override
    public ImmutableExpression negate(ImmutableList<? extends ImmutableTerm> subTerms, TermFactory termFactory) {
        switch (this.inequalityLabel) {
            case LT: {
                return this.buildInequality(InequalityLabel.GTE, subTerms, termFactory);
            }
            case LTE: {
                return this.buildInequality(InequalityLabel.GT, subTerms, termFactory);
            }
            case GT: {
                return this.buildInequality(InequalityLabel.LTE, subTerms, termFactory);
            }
            case GTE: {
                return this.buildInequality(InequalityLabel.LT, subTerms, termFactory);
            }
        }
        throw new MinorOntopInternalBugException("Unexpected inequality label: " + this.inequalityLabel);
    }

    protected abstract ImmutableExpression buildInequality(InequalityLabel var1, ImmutableList<? extends ImmutableTerm> var2, TermFactory var3);
}

