/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractTypedDBFunctionSymbol;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public abstract class AbstractSimpleMultitypedDBFunctionSymbol
extends AbstractTypedDBFunctionSymbol {
    private static final String FUNCTIONAL_TEMPLATE = "%s(%s)";
    private final String nameInDialect;
    private final boolean isInjective;

    protected AbstractSimpleMultitypedDBFunctionSymbol(String nameInDialect, int arity, DBTermType targetType, boolean isInjective) {
        super(nameInDialect + targetType + arity, (ImmutableList<TermType>)((ImmutableList)IntStream.range(0, arity).mapToObj(i -> targetType).collect(ImmutableCollectors.toList())), targetType);
        this.nameInDialect = nameInDialect;
        this.isInjective = isInjective;
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return this.isInjective;
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return false;
    }

    @Override
    public String getNativeDBString(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format(FUNCTIONAL_TEMPLATE, this.nameInDialect, terms.stream().map(termConverter).collect(Collectors.joining(",")));
    }
}

