/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBBooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractTypedDBFunctionSymbol;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.TermType;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DBRegexMatchAsLikeFunctionSymbolImpl
extends AbstractTypedDBFunctionSymbol
implements DBBooleanFunctionSymbol {
    protected DBRegexMatchAsLikeFunctionSymbolImpl(String name, DBTermType dbStringType, DBTermType dbBooleanType, int arity) {
        super(name, (ImmutableList<TermType>)(arity == 2 ? ImmutableList.of((Object)dbStringType, (Object)dbStringType) : ImmutableList.of((Object)dbStringType, (Object)dbStringType, (Object)dbStringType)), dbBooleanType);
    }

    @Override
    public boolean blocksNegation() {
        return true;
    }

    @Override
    public ImmutableExpression negate(ImmutableList<? extends ImmutableTerm> subTerms, TermFactory termFactory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return false;
    }

    private ImmutableList<String> tokenizeRegEx(String regEx) {
        ImmutableList.Builder tokens = ImmutableList.builder();
        int bracketDepth = 0;
        Object current = "";
        for (char character : regEx.toCharArray()) {
            if (!((String)current).equals("\\") && bracketDepth == 0 && !ImmutableSet.of((Object)Character.valueOf('*'), (Object)Character.valueOf('+'), (Object)Character.valueOf('?')).contains((Object)Character.valueOf(character))) {
                tokens.add(current);
                current = "";
            }
            current = (String)current + character;
            if (character == '[' || character == '(') {
                ++bracketDepth;
            }
            if (character != ']' && character != ')') continue;
            --bracketDepth;
        }
        if (bracketDepth != 0) {
            throw new MinorOntopInternalBugException("Error parsing RegEx: expected ']' or ')'.");
        }
        if (((String)current).equals("\\")) {
            throw new MinorOntopInternalBugException("Error parsing RegEx: Invalid escape sequence.");
        }
        tokens.add(current);
        return tokens.build();
    }

    private String translateToken(String token) {
        if (token.equals("_")) {
            return "[_]";
        }
        if (token.equals("%")) {
            return "[%]";
        }
        if (token.equals(".*")) {
            return "%";
        }
        if (token.equals(".")) {
            return "_";
        }
        if (token.equals(".+")) {
            return "_%";
        }
        if (token.equals("\\d")) {
            return "[0-9]";
        }
        if (token.equals("\\w")) {
            return "[0-9A-z]";
        }
        if (token.equals("\\s")) {
            return "[ \\t\\n]";
        }
        if (token.equals("\\D")) {
            return "[^0-9]";
        }
        if (token.equals("\\W")) {
            return "[^0-9A-z]";
        }
        if (token.equals("\\S")) {
            return "[^ \\t\\n]";
        }
        if (token.equals("\\[") || token.equals("\\]")) {
            return String.format("[%s]", token.substring(1));
        }
        if (ImmutableSet.of((Object)"\\*", (Object)"\\.", (Object)"\\^", (Object)"\\$", (Object)"\\?", (Object)"\\+", (Object[])new String[]{"\\(", "\\)", "\\{", "\\}", "\\|", "\\\\"}).contains((Object)token)) {
            return token.substring(1);
        }
        if (token.endsWith("*") || token.endsWith("+") || token.endsWith("?")) {
            throw new MinorOntopInternalBugException("Multiplicity modifiers are only allowed after the '.' wildcard when translating a RegEx to a LIKE comparison.");
        }
        if (token.startsWith("[") && token.endsWith("]")) {
            return token;
        }
        if (token.startsWith("(") || token.endsWith(")")) {
            throw new MinorOntopInternalBugException("Round parentheses are not allowed when translating a RegEx to a LIKE comparison.");
        }
        if (token.startsWith("{") || token.endsWith("}")) {
            throw new MinorOntopInternalBugException("Curly parentheses are not allowed when translating a RegEx to a LIKE comparison.");
        }
        if (token.contains("|")) {
            throw new MinorOntopInternalBugException("The '|' operator is not allowed when translating a RegEx to a LIKE comparison.");
        }
        if (token.contains("$") || token.contains("^")) {
            throw new MinorOntopInternalBugException("The '^' and '$' operators are only allowed at the pattern start and end respectively, when translating a RegEx to a LIKE comparison.");
        }
        return token;
    }

    private String translateRegex(String regex) {
        ImmutableList<String> tokens = this.tokenizeRegEx(regex);
        return tokens.stream().map(this::translateToken).collect(Collectors.joining());
    }

    @Override
    public String getNativeDBString(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        if (!(terms.get(1) instanceof Constant)) {
            throw new MinorOntopInternalBugException("Regex patterns must be constants when used with SQLServer.");
        }
        String pattern = ((Constant)terms.get(1)).getValue();
        boolean forceStart = false;
        boolean forceEnd = false;
        if (pattern.startsWith("^")) {
            forceStart = true;
            pattern = pattern.substring(1);
        }
        if (pattern.endsWith("$")) {
            forceEnd = true;
            pattern = pattern.substring(0, pattern.length() - 1);
        }
        Object newPattern = this.translateRegex(pattern);
        if (!forceStart) {
            newPattern = "%" + (String)newPattern;
        }
        if (!forceEnd) {
            newPattern = (String)newPattern + "%";
        }
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        if (terms.size() == 2) {
            return String.format("(%s LIKE '%s')", str, newPattern);
        }
        return String.format("(CASE WHEN %s = 'i' THEN LOWER(%s) ELSE %s END LIKE CASE WHEN %s = 'i' THEN LOWER(%s) ELSE '%s' END)", termConverter.apply((ImmutableTerm)terms.get(2)), str, str, termConverter.apply((ImmutableTerm)terms.get(2)), newPattern, newPattern);
    }

    @Override
    protected boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }
}

