/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFTermTypeConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBIfThenFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.FunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.MetaRDFTermType;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import java.util.Optional;
import java.util.function.Function;

public class BinaryLatelyTypedFunctionSymbolImpl
extends FunctionSymbolImpl {
    private final DBTermType targetType;
    private final Function<DBTermType, Optional<DBFunctionSymbol>> dbFunctionSymbolFct;

    protected BinaryLatelyTypedFunctionSymbolImpl(DBTermType dbStringType0, DBTermType dbStringType1, MetaRDFTermType metaRDFTermType0, MetaRDFTermType metaRDFTermType1, DBTermType targetType, Function<DBTermType, Optional<DBFunctionSymbol>> dbFunctionSymbolFct) {
        super("BINARY_LATELY_TYPE_" + dbFunctionSymbolFct, (ImmutableList<TermType>)ImmutableList.of((Object)dbStringType0, (Object)dbStringType1, (Object)metaRDFTermType0, (Object)metaRDFTermType1));
        this.targetType = targetType;
        this.dbFunctionSymbolFct = dbFunctionSymbolFct;
    }

    @Override
    protected boolean tolerateNulls() {
        return false;
    }

    @Override
    protected boolean mayReturnNullWithoutNullArguments() {
        return false;
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }

    @Override
    public Optional<TermTypeInference> inferType(ImmutableList<? extends ImmutableTerm> terms) {
        return Optional.of(TermTypeInference.declareTermType(this.targetType));
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return false;
    }

    @Override
    protected ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableTerm rdfTypeTerm0 = (ImmutableTerm)newTerms.get(2);
        ImmutableTerm rdfTypeTerm1 = (ImmutableTerm)newTerms.get(3);
        if (rdfTypeTerm0 instanceof RDFTermTypeConstant && rdfTypeTerm1 instanceof RDFTermTypeConstant) {
            RDFTermType rdfType0 = ((RDFTermTypeConstant)rdfTypeTerm0).getRDFTermType();
            RDFTermType rdfType1 = ((RDFTermTypeConstant)rdfTypeTerm1).getRDFTermType();
            DBTermType dbType0 = rdfType0.getClosestDBType(termFactory.getTypeFactory().getDBTypeFactory());
            DBTermType dbType1 = rdfType1.getClosestDBType(termFactory.getTypeFactory().getDBTypeFactory());
            Optional<DBFunctionSymbol> subFunctionSymbol0 = this.dbFunctionSymbolFct.apply(dbType0);
            Optional<DBFunctionSymbol> subFunctionSymbol1 = this.dbFunctionSymbolFct.apply(dbType1);
            if (!subFunctionSymbol0.isPresent() || !subFunctionSymbol1.isPresent()) {
                return termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, newTerms);
            }
            ImmutableFunctionalTerm dbTerm = termFactory.getImmutableFunctionalTerm((FunctionSymbol)subFunctionSymbol0.get(), termFactory.getConversionFromRDFLexical2DB(dbType0, (ImmutableTerm)newTerms.get(0), rdfType0), termFactory.getConversionFromRDFLexical2DB(dbType1, (ImmutableTerm)newTerms.get(1), rdfType1));
            return this.transformNaturalDBTerm(dbTerm, dbType0, dbType1, rdfType0, rdfType1, termFactory).simplify(variableNullability);
        }
        return Optional.of(rdfTypeTerm0 instanceof RDFTermTypeConstant ? rdfTypeTerm1 : rdfTypeTerm0).filter(t -> t instanceof ImmutableFunctionalTerm).map(t -> (ImmutableFunctionalTerm)t).filter(t -> t.getFunctionSymbol() instanceof DBIfThenFunctionSymbol).map(t -> ((DBIfThenFunctionSymbol)t.getFunctionSymbol()).pushDownRegularFunctionalTerm(termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, (ImmutableList<? extends ImmutableTerm>)newTerms), newTerms.indexOf(t), termFactory)).map(t -> t.simplify(variableNullability)).orElseGet(() -> this.tryToLiftMagicNumbers(newTerms, termFactory, variableNullability, false).orElseGet(() -> super.buildTermAfterEvaluation(newTerms, termFactory, variableNullability)));
    }

    protected ImmutableTerm transformNaturalDBTerm(ImmutableFunctionalTerm dbTerm, DBTermType inputDBType0, DBTermType inputDBType1, RDFTermType rdfType0, RDFTermType rdfType1, TermFactory termFactory) {
        return dbTerm;
    }
}

