/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.request.DefinitionPushDownRequest;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.InequalityLabel;
import it.unibz.inf.ontop.model.term.functionsymbol.SPARQLAggregationFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.SPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;
import java.util.stream.Stream;

public class GroupConcatSPARQLFunctionSymbolImpl
extends SPARQLFunctionSymbolImpl
implements SPARQLAggregationFunctionSymbol {
    private final RDFDatatype xsdStringType;
    private final String separator;
    private final boolean isDistinct;

    protected GroupConcatSPARQLFunctionSymbolImpl(RDFDatatype xsdStringType, String separator, boolean isDistinct) {
        super("SP_GROUP_CONCAT" + (isDistinct ? "_DISTINCT" : "") + (separator.equals(" ") ? "" : separator), "GROUP_CONCAT", (ImmutableList<TermType>)ImmutableList.of((Object)xsdStringType));
        this.xsdStringType = xsdStringType;
        this.separator = separator;
        this.isDistinct = isDistinct;
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    @Override
    protected boolean tolerateNulls() {
        return true;
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }

    @Override
    public Optional<TermTypeInference> inferType(ImmutableList<? extends ImmutableTerm> terms) {
        return Optional.of(TermTypeInference.declareTermType(this.xsdStringType));
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return false;
    }

    @Override
    public boolean isNullable(ImmutableSet<Integer> nullableIndexes) {
        return true;
    }

    @Override
    public boolean isAggregation() {
        return true;
    }

    @Override
    public Optional<SPARQLAggregationFunctionSymbol.AggregationSimplification> decomposeIntoDBAggregation(ImmutableList<? extends ImmutableTerm> subTerms, ImmutableList<ImmutableSet<RDFTermType>> possibleRDFTypes, boolean hasGroupBy, VariableNullability variableNullability, VariableGenerator variableGenerator, TermFactory termFactory) {
        if (possibleRDFTypes.size() != this.getArity()) {
            throw new IllegalArgumentException("The size of possibleRDFTypes is expected to match the arity of the function symbol");
        }
        ImmutableTerm firstSubTerm = (ImmutableTerm)subTerms.get(0);
        ImmutableSet subTermPossibleTypes = (ImmutableSet)possibleRDFTypes.get(0);
        return subTermPossibleTypes.stream().allMatch(t -> t.isA(this.xsdStringType)) ? Optional.of(this.decomposeString(firstSubTerm, hasGroupBy, variableNullability, variableGenerator, termFactory)) : Optional.of(this.decomposeWithNonString(firstSubTerm, variableNullability, variableGenerator, termFactory));
    }

    private SPARQLAggregationFunctionSymbol.AggregationSimplification decomposeString(ImmutableTerm firstSubTerm, boolean hasGroupBy, VariableNullability variableNullability, VariableGenerator variableGenerator, TermFactory termFactory) {
        ImmutableTerm subTermLexicalTerm = this.extractLexicalTerm(firstSubTerm, termFactory);
        ImmutableFunctionalTerm dbAggTerm = this.createAggregate(subTermLexicalTerm, this.separator, termFactory);
        Variable dbAggregationVariable = variableGenerator.generateNewVariable("str");
        boolean isSubTermNullable = subTermLexicalTerm.isNullable(variableNullability.getNullableVariables());
        DBConstant emptyString = termFactory.getDBStringConstant("");
        boolean dbAggMayReturnNull = !hasGroupBy || isSubTermNullable;
        Variable nonNullDBAggregate = dbAggMayReturnNull ? termFactory.getDBCoalesce(dbAggregationVariable, emptyString, new ImmutableTerm[0]) : dbAggregationVariable;
        ImmutableFunctionalTerm liftedTerm = termFactory.getRDFFunctionalTerm(nonNullDBAggregate, termFactory.getRDFTermTypeConstant(this.xsdStringType));
        ImmutableFunctionalTerm.FunctionalTermDecomposition decomposition = termFactory.getFunctionalTermDecomposition(liftedTerm, termFactory.getSubstitution(ImmutableMap.of((Object)dbAggregationVariable, (Object)dbAggTerm)));
        return SPARQLAggregationFunctionSymbol.AggregationSimplification.create(decomposition);
    }

    private ImmutableFunctionalTerm createAggregate(ImmutableTerm subTermLexicalTerm, String separator, TermFactory termFactory) {
        return termFactory.getDBGroupConcat(subTermLexicalTerm, separator, this.isDistinct);
    }

    private SPARQLAggregationFunctionSymbol.AggregationSimplification decomposeWithNonString(ImmutableTerm subTerm, VariableNullability variableNullability, VariableGenerator variableGenerator, TermFactory termFactory) {
        ImmutableTerm subTermLexicalTerm = this.extractLexicalTerm(subTerm, termFactory);
        ImmutableTerm subTermTypeTerm = this.extractRDFTermTypeTerm(subTerm, termFactory);
        Variable stringSubVar = variableGenerator.generateNewVariable("s");
        Variable incompatibleSubVariable = variableGenerator.generateNewVariable("nonStr");
        ImmutableSet<DefinitionPushDownRequest> pushDownRequests = this.computeRequests(subTermLexicalTerm, subTermTypeTerm, stringSubVar, incompatibleSubVariable, variableNullability, termFactory);
        Variable strAggregateVar = variableGenerator.generateNewVariable("agg");
        Variable incompatibleCountVariable = variableGenerator.generateNewVariable("nonStrCount");
        Substitution<ImmutableFunctionalTerm> substitution = this.computeSubstitutionMap(strAggregateVar, stringSubVar, incompatibleCountVariable, incompatibleSubVariable, termFactory, this.separator);
        ImmutableFunctionalTerm liftableTerm = this.computeLiftableTerm(strAggregateVar, incompatibleCountVariable, termFactory);
        return SPARQLAggregationFunctionSymbol.AggregationSimplification.create(termFactory.getFunctionalTermDecomposition(liftableTerm, substitution), pushDownRequests);
    }

    private ImmutableSet<DefinitionPushDownRequest> computeRequests(ImmutableTerm subTermLexicalTerm, ImmutableTerm subTermTypeTerm, Variable strSubTermVar, Variable incompatibleVariable, VariableNullability variableNullability, TermFactory termFactory) {
        return ImmutableSet.of((Object)this.createStrRequest(strSubTermVar, subTermLexicalTerm, subTermTypeTerm, variableNullability, termFactory), (Object)this.createNonStrRequest(subTermTypeTerm, incompatibleVariable, termFactory));
    }

    private DefinitionPushDownRequest createStrRequest(Variable strVariable, ImmutableTerm subTermLexicalTerm, ImmutableTerm subTermTypeTerm, VariableNullability variableNullability, TermFactory termFactory) {
        ImmutableTerm definition = subTermLexicalTerm.simplify(variableNullability);
        ImmutableExpression condition = termFactory.getIsAExpression(subTermTypeTerm, this.xsdStringType);
        return DefinitionPushDownRequest.create(strVariable, definition, condition);
    }

    protected DefinitionPushDownRequest createNonStrRequest(ImmutableTerm subTermTypeTerm, Variable nonStrVariable, TermFactory termFactory) {
        DBConstant definition = termFactory.getDBBooleanConstant(true);
        ImmutableExpression condition = termFactory.getDBNot(termFactory.getIsAExpression(subTermTypeTerm, this.xsdStringType));
        return DefinitionPushDownRequest.create(nonStrVariable, definition, condition);
    }

    private Substitution<ImmutableFunctionalTerm> computeSubstitutionMap(Variable strAggregateVar, Variable strSubTermVar, Variable incompatibleCountVariable, Variable incompatibleSubVariable, TermFactory termFactory, String separator) {
        return termFactory.getSubstitution(ImmutableMap.of((Object)strAggregateVar, (Object)this.createAggregate(strSubTermVar, separator, termFactory), (Object)incompatibleCountVariable, (Object)termFactory.getDBCount(incompatibleSubVariable, false)));
    }

    private ImmutableFunctionalTerm computeLiftableTerm(Variable strAggregateVar, Variable incompatibleCountVariable, TermFactory termFactory) {
        DBConstant zero = termFactory.getDBIntegerConstant(0);
        ImmutableExpression incompatibleCondition = termFactory.getDBNumericInequality(InequalityLabel.GT, incompatibleCountVariable, zero);
        ImmutableFunctionalTerm lexicalTerm = termFactory.getDBCase(Stream.of(Maps.immutableEntry((Object)incompatibleCondition, (Object)termFactory.getNullConstant()), Maps.immutableEntry((Object)termFactory.getDBIsNotNull(strAggregateVar), (Object)strAggregateVar)), termFactory.getDBStringConstant(""), true);
        ImmutableFunctionalTerm typeTerm = termFactory.getIfElseNull(incompatibleCondition.negate(termFactory), termFactory.getRDFTermTypeConstant(this.xsdStringType));
        return termFactory.getRDFFunctionalTerm(lexicalTerm, typeTerm);
    }

    @Override
    public Constant evaluateEmptyBag(TermFactory termFactory) {
        return termFactory.getRDFLiteralConstant("", this.xsdStringType);
    }

    @Override
    protected ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableTerm newTerm = (ImmutableTerm)newTerms.get(0);
        return newTerm.isNull() ? this.evaluateEmptyBag(termFactory) : super.buildTermAfterEvaluation(newTerms, termFactory, variableNullability);
    }
}

