/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl.ofn;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.ReduciblePositiveAritySPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.commons.rdf.api.IRI;

public class OfnMultitypedInputBinarySPARQLFunctionSymbolImpl
extends ReduciblePositiveAritySPARQLFunctionSymbolImpl {
    private final RDFTermType targetType;
    private final boolean isAlwaysInjective;
    private final PentaFunction<TermFactory, ImmutableTerm, ImmutableTerm, ImmutableTerm, ImmutableTerm, ImmutableFunctionalTerm> lexicalTermFct;

    public OfnMultitypedInputBinarySPARQLFunctionSymbolImpl(@Nonnull String functionSymbolName, @Nonnull IRI functionIRI, @Nonnull RDFTermType inputBaseType, @Nonnull RDFTermType targetType, boolean isAlwaysInjective, PentaFunction<TermFactory, ImmutableTerm, ImmutableTerm, ImmutableTerm, ImmutableTerm, ImmutableFunctionalTerm> lexicalTermFct) {
        super(functionSymbolName, functionIRI, (ImmutableList<TermType>)ImmutableList.of((Object)inputBaseType, (Object)inputBaseType));
        this.targetType = targetType;
        this.isAlwaysInjective = isAlwaysInjective;
        this.lexicalTermFct = lexicalTermFct;
        if (targetType.isAbstract()) {
            throw new IllegalArgumentException("The target type must be concrete");
        }
    }

    public OfnMultitypedInputBinarySPARQLFunctionSymbolImpl(@Nonnull String functionSymbolName, @Nonnull IRI functionIRI, @Nonnull RDFTermType inputBaseType, @Nonnull RDFTermType targetType, boolean isAlwaysInjective, DBTypeFactory dbTypeFactory, Function<DBTermType, Optional<DBFunctionSymbol>> dbFunctionSymbolFct) {
        this(functionSymbolName, functionIRI, inputBaseType, targetType, isAlwaysInjective, OfnMultitypedInputBinarySPARQLFunctionSymbolImpl.createLatelyTypedFct(targetType, dbTypeFactory, dbFunctionSymbolFct));
    }

    public OfnMultitypedInputBinarySPARQLFunctionSymbolImpl(@Nonnull String functionSymbolName, @Nonnull String officialName, @Nonnull RDFTermType inputBaseType, @Nonnull RDFTermType targetType, boolean isAlwaysInjective, PentaFunction<TermFactory, ImmutableTerm, ImmutableTerm, ImmutableTerm, ImmutableTerm, ImmutableFunctionalTerm> lexicalTermFct) {
        super(functionSymbolName, officialName, (ImmutableList<TermType>)ImmutableList.of((Object)inputBaseType, (Object)inputBaseType));
        this.lexicalTermFct = lexicalTermFct;
        this.targetType = targetType;
        this.isAlwaysInjective = isAlwaysInjective;
        if (targetType.isAbstract()) {
            throw new IllegalArgumentException("The target type must be concrete");
        }
    }

    public OfnMultitypedInputBinarySPARQLFunctionSymbolImpl(@Nonnull String functionSymbolName, @Nonnull String officialName, @Nonnull RDFTermType inputBaseType, @Nonnull RDFTermType targetType, boolean isAlwaysInjective, DBTypeFactory dbTypeFactory, Function<DBTermType, Optional<DBFunctionSymbol>> dbFunctionSymbolFct) {
        this(functionSymbolName, officialName, inputBaseType, targetType, isAlwaysInjective, OfnMultitypedInputBinarySPARQLFunctionSymbolImpl.createLatelyTypedFct(targetType, dbTypeFactory, dbFunctionSymbolFct));
    }

    private static PentaFunction<TermFactory, ImmutableTerm, ImmutableTerm, ImmutableTerm, ImmutableTerm, ImmutableFunctionalTerm> createLatelyTypedFct(RDFTermType targetType, DBTypeFactory dbTypeFactory, Function<DBTermType, Optional<DBFunctionSymbol>> dbFunctionSymbolFct) {
        return (termFactory, lexicalTerm0, lexicalTerm1, rdfTermTypeTerm0, rdfTermTypeTerm1) -> termFactory.getBinaryLatelyTypedFunctionalTerm((ImmutableTerm)lexicalTerm0, (ImmutableTerm)lexicalTerm1, (ImmutableTerm)rdfTermTypeTerm0, (ImmutableTerm)rdfTermTypeTerm1, targetType.getClosestDBType(dbTypeFactory), dbFunctionSymbolFct);
    }

    @Override
    protected ImmutableTerm computeLexicalTerm(ImmutableList<ImmutableTerm> subLexicalTerms, ImmutableList<ImmutableTerm> typeTerms, TermFactory termFactory, ImmutableTerm returnedTypeTerm) {
        return termFactory.getConversion2RDFLexical(this.lexicalTermFct.apply(termFactory, (ImmutableTerm)subLexicalTerms.get(1), (ImmutableTerm)subLexicalTerms.get(0), (ImmutableTerm)typeTerms.get(0), (ImmutableTerm)typeTerms.get(1)), this.targetType);
    }

    @Override
    protected ImmutableTerm computeTypeTerm(ImmutableList<? extends ImmutableTerm> subLexicalTerms, ImmutableList<ImmutableTerm> typeTerms, TermFactory termFactory, VariableNullability variableNullability) {
        return termFactory.getRDFTermTypeConstant(this.targetType);
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return this.isAlwaysInjective;
    }

    @Override
    public Optional<TermTypeInference> inferType(ImmutableList<? extends ImmutableTerm> terms) {
        return Optional.of(TermTypeInference.declareTermType(this.targetType));
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return false;
    }

    @FunctionalInterface
    public static interface PentaFunction<S, T, U, V, W, R> {
        public R apply(S var1, T var2, U var3, V var4, W var5);
    }
}

