/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.type.impl;

import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermTypeAncestry;
import it.unibz.inf.ontop.model.type.impl.RDFTermTypeImpl;
import java.util.function.Function;
import org.apache.commons.rdf.api.IRI;

public abstract class AbstractRDFDatatype
extends RDFTermTypeImpl
implements RDFDatatype {
    private final IRI datatypeIRI;

    protected AbstractRDFDatatype(IRI datatypeIRI, TermTypeAncestry parentAncestry, Function<DBTypeFactory, DBTermType> closestDBTypeFct) {
        super(AbstractRDFDatatype.extractIRIString(datatypeIRI), parentAncestry, closestDBTypeFct);
        this.datatypeIRI = datatypeIRI;
    }

    protected AbstractRDFDatatype(IRI datatypeIRI, TermTypeAncestry parentAncestry) {
        super(AbstractRDFDatatype.extractIRIString(datatypeIRI), parentAncestry);
        this.datatypeIRI = datatypeIRI;
    }

    private static String extractIRIString(IRI datatypeIRI) {
        String iriString = datatypeIRI.getIRIString();
        if (iriString.startsWith("http://www.w3.org/2001/XMLSchema#")) {
            return "xsd:" + iriString.substring("http://www.w3.org/2001/XMLSchema#".length());
        }
        if (iriString.startsWith("http://www.w3.org/2000/01/rdf-schema#")) {
            return "rdfs:" + iriString.substring("http://www.w3.org/2000/01/rdf-schema#".length());
        }
        return iriString;
    }

    @Override
    public boolean isA(IRI baseDatatypeIri) {
        return this.getAncestry().getTermTypes().filter(t -> t instanceof RDFDatatype).map(t -> ((RDFDatatype)t).getIRI()).anyMatch(arg_0 -> ((IRI)baseDatatypeIri).equals(arg_0));
    }

    @Override
    public IRI getIRI() {
        return this.datatypeIRI;
    }
}

