/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.type.impl;

import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.TermTypeAncestry;
import it.unibz.inf.ontop.model.type.impl.TermTypeImpl;
import it.unibz.inf.ontop.model.type.lexical.DefaultLexicalSpaces;
import it.unibz.inf.ontop.model.type.lexical.LexicalSpace;
import java.util.Optional;

public abstract class DBTermTypeImpl
extends TermTypeImpl
implements DBTermType {
    private final String name;
    private final LexicalSpace lexicalSpace;
    private final DBTermType.Category category;

    protected DBTermTypeImpl(String name, TermTypeAncestry parentAncestry, boolean isAbstract, DBTermType.Category category) {
        super(name, parentAncestry, isAbstract);
        this.name = name;
        this.category = category;
        this.lexicalSpace = DefaultLexicalSpaces.getDefaultSpace(category);
    }

    @Override
    public DBTermType.Category getCategory() {
        return this.category;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCastName() {
        return this.name;
    }

    @Override
    public Optional<Boolean> isValidLexicalValue(String lexicalValue) {
        return this.lexicalSpace.includes(lexicalValue);
    }

    @Override
    public boolean isPreventDistinctRecommended() {
        return false;
    }
}

