/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.type.impl;

import it.unibz.inf.ontop.model.type.LanguageTag;
import java.util.IllformedLocaleException;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

public class LanguageTagImpl
implements LanguageTag {
    private final String prefix;
    private final Optional<String> optionalSuffix;
    private final String fullString;

    protected LanguageTagImpl(String fullString) {
        this.fullString = Objects.requireNonNull(fullString).toLowerCase(Locale.ENGLISH);
        if (fullString.isEmpty()) {
            throw new IllegalArgumentException("A language tag cannot be empty");
        }
        try {
            Locale locale = new Locale.Builder().setLanguageTag(fullString).build();
            this.prefix = locale.getLanguage();
            if (this.prefix.length() < 2 || this.prefix.length() > 3) {
                throw new IllegalStateException("Invalid language tag found: " + fullString + ". The language code can only have 2 or 3 chars.");
            }
            this.optionalSuffix = Optional.of(locale.getCountry()).filter(v -> !v.isEmpty()).map(v -> v.toLowerCase(Locale.ENGLISH));
        }
        catch (IllformedLocaleException ex) {
            throw new IllegalStateException("Invalid language tag found: " + fullString);
        }
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public Optional<String> getOptionalSuffix() {
        return this.optionalSuffix;
    }

    @Override
    public String getFullString() {
        return this.fullString;
    }

    @Override
    public Optional<LanguageTag> getCommonDenominator(LanguageTag otherTag) {
        if (this.equals(otherTag)) {
            return Optional.of(this);
        }
        if (this.prefix.equals(otherTag.getPrefix())) {
            return Optional.of(new LanguageTagImpl(this.prefix));
        }
        return Optional.empty();
    }

    public int hashCode() {
        return this.fullString.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof LanguageTag) {
            return this.fullString.equals(((LanguageTag)other).getFullString());
        }
        return false;
    }

    public String toString() {
        return this.fullString;
    }
}

