/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.substitution.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionBasicOperations;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;

public abstract class AbstractSubstitutionBasicOperations<T extends ImmutableTerm>
implements SubstitutionBasicOperations<T> {
    protected final TermFactory termFactory;

    AbstractSubstitutionBasicOperations(TermFactory termFactory) {
        this.termFactory = termFactory;
    }

    static <T extends ImmutableTerm> Substitution<T> covariantCast(Substitution<? extends T> substitution) {
        return substitution;
    }

    @Override
    public ImmutableList<T> applyToTerms(Substitution<? extends T> substitution, ImmutableList<? extends T> terms) {
        return (ImmutableList)terms.stream().map(t -> this.applyToTerm(substitution, t)).collect(ImmutableCollectors.toList());
    }

    @Override
    public ImmutableMap<Integer, T> applyToTerms(Substitution<? extends T> substitution, ImmutableMap<Integer, ? extends T> argumentMap) {
        return argumentMap.entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> this.applyToTerm(substitution, (ImmutableTerm)e.getValue())));
    }

    @Override
    public Substitution<T> compose(Substitution<? extends T> g, Substitution<? extends T> f) {
        if (g.isEmpty()) {
            return AbstractSubstitutionBasicOperations.covariantCast(f);
        }
        if (f.isEmpty()) {
            return AbstractSubstitutionBasicOperations.covariantCast(g);
        }
        ImmutableMap<Variable, ImmutableTerm> map = Stream.concat(f.stream().map(e -> Maps.immutableEntry((Object)((Variable)e.getKey()), (Object)this.applyToTerm(g, (ImmutableTerm)e.getValue()))), g.stream()).filter(e -> !((Variable)e.getKey()).equals(e.getValue())).collect(ImmutableCollectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (fValue, gValue) -> fValue));
        return this.termFactory.getSubstitution(map);
    }

    protected static <T extends ImmutableTerm> T applyToVariable(Substitution<? extends T> substitution, Variable v, Function<Variable, T> typeCast) {
        T t = substitution.get(v);
        if (t != null) {
            return t;
        }
        return (T)((ImmutableTerm)typeCast.apply(v));
    }

    @Override
    public Substitution<T> rename(InjectiveSubstitution<Variable> renaming, Substitution<? extends T> substitution) {
        if (renaming.isEmpty()) {
            return AbstractSubstitutionBasicOperations.covariantCast(substitution);
        }
        ImmutableMap map = substitution.stream().map(e -> Maps.immutableEntry((Object)AbstractSubstitutionBasicOperations.applyToVariable(renaming, (Variable)e.getKey(), v -> v), (Object)this.rename(renaming, (ImmutableTerm)e.getValue()))).filter(e -> !((Variable)e.getKey()).equals(e.getValue())).collect(ImmutableCollectors.toMap());
        return this.termFactory.getSubstitution(map);
    }
}

