/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.substitution.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionBasicOperations;
import it.unibz.inf.ontop.substitution.UnifierBuilder;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public abstract class AbstractUnifierBuilder<T extends ImmutableTerm>
implements UnifierBuilder<T> {
    private final TermFactory termFactory;
    private final SubstitutionBasicOperations<T> operations;
    private Optional<Substitution<T>> optionalSubstitution;

    AbstractUnifierBuilder(TermFactory termFactory, SubstitutionBasicOperations<T> operations, Substitution<T> substitution) {
        this.termFactory = termFactory;
        this.operations = operations;
        this.optionalSubstitution = Optional.of(substitution);
    }

    @Override
    public UnifierBuilder<T> unify(ImmutableList<? extends T> args1, ImmutableList<? extends T> args2) {
        if (args1.size() == args2.size()) {
            return this.unify(IntStream.range(0, args1.size()), arg_0 -> args1.get(arg_0), arg_0 -> args2.get(arg_0));
        }
        return this.empty();
    }

    @Override
    public UnifierBuilder<T> unify(IntStream indexes, IntFunction<? extends T> args1, IntFunction<? extends T> args2) {
        return indexes.collect(() -> this, (s, i) -> s.unify((ImmutableTerm)args1.apply(i), (ImmutableTerm)args2.apply(i)), AbstractUnifierBuilder::merge);
    }

    @Override
    public <B> UnifierBuilder<T> unify(Stream<B> stream, Function<B, T> args1, Function<B, T> args2) {
        return stream.collect(() -> this, (s, i) -> s.unify((ImmutableTerm)args1.apply(i), (ImmutableTerm)args2.apply(i)), AbstractUnifierBuilder::merge);
    }

    @Override
    public UnifierBuilder<T> unify(T t1, T t2) {
        T term2;
        if (this.optionalSubstitution.isEmpty()) {
            return this;
        }
        T term1 = this.operations.applyToTerm(this.optionalSubstitution.get(), t1);
        if (term1.equals(term2 = this.operations.applyToTerm(this.optionalSubstitution.get(), t2))) {
            return this;
        }
        return this.unifyUnequalTerms(term1, term2);
    }

    protected abstract UnifierBuilder<T> unifyUnequalTerms(T var1, T var2);

    protected boolean doesNotContainVariable(Variable variable, T term) {
        return true;
    }

    protected Optional<UnifierBuilder<T>> attemptUnifying(T term1, T term2) {
        Variable variable;
        if (term1 instanceof Variable && this.doesNotContainVariable(variable = (Variable)term1, term2)) {
            Substitution s = this.termFactory.getSubstitution(ImmutableMap.of((Object)variable, term2));
            this.optionalSubstitution = Optional.of(this.operations.compose(s, this.optionalSubstitution.get()));
            return Optional.of(this);
        }
        return Optional.empty();
    }

    protected UnifierBuilder<T> empty() {
        this.optionalSubstitution = Optional.empty();
        return this;
    }

    @Override
    public Optional<Substitution<T>> build() {
        return this.optionalSubstitution;
    }

    AbstractUnifierBuilder<T> merge(UnifierBuilder<T> another) {
        throw new MinorOntopInternalBugException("Not expected to be run in parallel");
    }
}

