/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.substitution.impl;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.impl.SubstitutionImpl;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public class InjectiveSubstitutionImpl<T extends ImmutableTerm>
extends SubstitutionImpl<T>
implements InjectiveSubstitution<T> {
    InjectiveSubstitutionImpl(ImmutableMap<Variable, T> map, TermFactory termFactory, boolean checkEntries) {
        super(map, termFactory, checkEntries);
        if (checkEntries && !InjectiveSubstitutionImpl.isInjective(this.map)) {
            throw new IllegalArgumentException("Non-injective map given: " + map);
        }
    }

    @Override
    public String toString() {
        return "injective " + super.toString();
    }

    @Override
    protected <T extends ImmutableTerm, S extends ImmutableTerm> InjectiveSubstitution<S> createSubstitution(Stream<Map.Entry<Variable, T>> stream, Function<Map.Entry<Variable, T>, S> mapper, boolean checkEntries) {
        return new InjectiveSubstitutionImpl<S>(stream.collect(ImmutableCollectors.toMap(Map.Entry::getKey, mapper)), this.termFactory, checkEntries);
    }

    @Override
    public InjectiveSubstitution<T> restrictDomainTo(Set<Variable> set) {
        return this.createSubstitution(this.stream().filter(e -> set.contains(e.getKey())), Map.Entry::getValue, false);
    }

    @Override
    public InjectiveSubstitution<T> removeFromDomain(Set<Variable> set) {
        return this.createSubstitution(this.stream().filter(e -> !set.contains(e.getKey())), Map.Entry::getValue, false);
    }

    @Override
    public <S extends ImmutableTerm> InjectiveSubstitution<S> restrictRangeTo(Class<? extends S> type) {
        return this.createSubstitution(this.stream().filter(e -> type.isInstance(e.getValue())), (T e) -> (ImmutableTerm)type.cast(e.getValue()), false);
    }

    @Override
    public <S extends ImmutableTerm> InjectiveSubstitution<S> transform(Function<T, S> function) {
        return this.createSubstitution(this.stream(), (T e) -> (ImmutableTerm)function.apply((ImmutableTerm)e.getValue()), true);
    }

    static <T> boolean isInjective(ImmutableMap<Variable, T> map) {
        ImmutableCollection values = map.values();
        return values.size() == ImmutableSet.copyOf((Collection)values).size();
    }

    @Override
    public InjectiveSubstitution.Builder<T, ? extends InjectiveSubstitution.Builder<T, ?>> builder() {
        return new BuilderImpl(this.map.entrySet().stream(), false);
    }

    protected class BuilderImpl<BT extends ImmutableTerm, B extends InjectiveSubstitution.Builder<BT, ? extends B>>
    extends SubstitutionImpl.AbstractBuilderImpl<BT, BuilderImpl<BT, B>>
    implements InjectiveSubstitution.Builder<BT, BuilderImpl<BT, B>> {
        BuilderImpl(Stream<Map.Entry<Variable, BT>> stream, boolean checkEntries) {
            super(stream, checkEntries);
        }

        @Override
        protected BuilderImpl<BT, B> createBuilder(Stream<Map.Entry<Variable, BT>> stream, boolean checkEntries) {
            return new BuilderImpl<BT, B>(stream, checkEntries);
        }

        @Override
        public InjectiveSubstitution<BT> build() {
            return InjectiveSubstitutionImpl.this.createSubstitution(this.stream, Map.Entry::getValue, this.checkEntries);
        }
    }
}

