/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.frontier;

import com.google.common.primitives.Ints;
import it.unimi.di.law.bubing.frontier.Frontier;
import it.unimi.di.law.bubing.frontier.ParsingThread;
import it.unimi.di.law.bubing.frontier.VisitState;
import it.unimi.di.law.bubing.util.BURL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DNSThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(DNSThread.class);
    public volatile boolean stop;
    private final Frontier frontier;

    public DNSThread(Frontier frontier, int index) {
        this.setName(this.getClass().getSimpleName() + '-' + index);
        this.frontier = frontier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stop) {
            try {
                this.frontier.rc.ensureNotPaused();
                VisitState visitState = (VisitState)this.frontier.unknownHosts.poll();
                if (visitState == null) {
                    visitState = this.frontier.newVisitStates.poll(1L, TimeUnit.SECONDS);
                }
                if (visitState == null) continue;
                String host = BURL.hostFromSchemeAndAuthority(visitState.schemeAuthority);
                try {
                    byte[] address;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Resolving host {} with DNS because of URL {}", (Object)host, (Object)BURL.fromNormalizedSchemeAuthorityAndPathQuery(visitState.schemeAuthority, visitState.firstPath()));
                    }
                    if ((address = this.frontier.rc.dnsResolver.resolve(host)[0].getAddress()).length == 4) {
                        Lock lock = this.frontier.rc.blackListedIPv4Lock.readLock();
                        lock.lock();
                        try {
                            if (this.frontier.rc.blackListedIPv4Addresses.contains(Ints.fromByteArray((byte[])address))) {
                                LOGGER.warn("Visit state for host {} was not created and rather scheduled for purge because its IP {} was blacklisted", (Object)host, (Object)Arrays.toString(address));
                                visitState.schedulePurge();
                                continue;
                            }
                        }
                        finally {
                            lock.unlock();
                            continue;
                        }
                    }
                    visitState.lastExceptionClass = null;
                    visitState.setWorkbenchEntry(this.frontier.workbench.getWorkbenchEntry(address));
                }
                catch (UnknownHostException e) {
                    LOGGER.warn("Unknown host " + host + " for visit state " + visitState);
                    visitState.retries = visitState.lastExceptionClass != UnknownHostException.class ? 0 : ++visitState.retries;
                    visitState.lastExceptionClass = UnknownHostException.class;
                    if (visitState.retries < ParsingThread.EXCEPTION_TO_MAX_RETRIES.getInt(UnknownHostException.class)) {
                        long delay = ParsingThread.EXCEPTION_TO_WAIT_TIME.getLong(UnknownHostException.class) << visitState.retries;
                        visitState.nextFetch = System.currentTimeMillis() + delay;
                        LOGGER.info("Will retry DNS resolution of state " + visitState + " with delay " + delay);
                        this.frontier.unknownHosts.add(visitState);
                        continue;
                    }
                    visitState.schedulePurge();
                    LOGGER.warn("Visit state " + visitState + " killed by " + UnknownHostException.class.getSimpleName());
                }
            }
            catch (Throwable t) {
                LOGGER.error("Unexpected exception", t);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Completed");
        }
    }
}

