/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.frontier;

import it.unimi.di.law.bubing.frontier.Distributor;
import it.unimi.di.law.bubing.frontier.Frontier;
import it.unimi.di.law.bubing.frontier.VisitState;
import it.unimi.di.law.bubing.frontier.WorkbenchEntry;
import it.unimi.dsi.Util;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.stat.SummaryStats;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StatsThread
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatsThread.class);
    private final Frontier frontier;
    private final Distributor distributor;
    public final ProgressLogger requestLogger;
    public final ProgressLogger resourceLogger;
    public final ProgressLogger transferredBytesLogger;
    public final ProgressLogger receivedURLsLogger;
    public volatile int[] dist = new int[0];
    public volatile long unresolved = 0L;
    public volatile long brokenPathQueryCount = 0L;
    public volatile SummaryStats entrySummaryStats;
    public volatile long resolvedVisitStates;
    public volatile long brokenVisitStatesOnWorkbench;

    public StatsThread(Frontier frontier, Distributor distributor) {
        this.frontier = frontier;
        this.distributor = distributor;
        this.requestLogger = new ProgressLogger(LOGGER, Long.MAX_VALUE, TimeUnit.MILLISECONDS, "requests");
        this.requestLogger.displayLocalSpeed = true;
        this.requestLogger.displayFreeMemory = true;
        this.requestLogger.speedTimeUnit = TimeUnit.SECONDS;
        this.requestLogger.itemTimeUnit = TimeUnit.MILLISECONDS;
        this.resourceLogger = new ProgressLogger(LOGGER, Long.MAX_VALUE, TimeUnit.MILLISECONDS, "resources");
        this.resourceLogger.displayLocalSpeed = true;
        this.resourceLogger.speedTimeUnit = TimeUnit.SECONDS;
        this.resourceLogger.itemTimeUnit = TimeUnit.MILLISECONDS;
        this.transferredBytesLogger = new ProgressLogger(LOGGER, Long.MAX_VALUE, TimeUnit.MILLISECONDS, "bytes");
        this.transferredBytesLogger.displayLocalSpeed = true;
        this.transferredBytesLogger.speedTimeUnit = TimeUnit.SECONDS;
        this.transferredBytesLogger.itemTimeUnit = TimeUnit.NANOSECONDS;
        this.receivedURLsLogger = new ProgressLogger(LOGGER, Long.MAX_VALUE, TimeUnit.MILLISECONDS, "receivedURLs");
        this.receivedURLsLogger.displayLocalSpeed = true;
        this.receivedURLsLogger.speedTimeUnit = TimeUnit.SECONDS;
    }

    public void start(long previousCrawlDuration) {
        this.requestLogger.start(previousCrawlDuration);
        this.resourceLogger.start(previousCrawlDuration);
        this.transferredBytesLogger.start(previousCrawlDuration);
        this.receivedURLsLogger.start(previousCrawlDuration);
    }

    public static String toString(int[] a) {
        int i = a.length;
        while (i-- != 0 && a[i] == 0) {
        }
        return Arrays.toString(Arrays.copyOfRange(a, 0, i + 1));
    }

    public static String toString(AtomicLongArray a) {
        int i = a.length();
        while (i-- != 0 && a.get(i) == 0L) {
        }
        long[] b = new long[i + 1];
        while (true) {
            int n = ++i;
            --i;
            if (n == 0) break;
            b[i] = a.get(i);
        }
        return Arrays.toString(b);
    }

    public void emit() {
        this.requestLogger.setAndDisplay(this.frontier.fetchedResources.get() + this.frontier.fetchedRobots.get());
        long duplicates = this.frontier.duplicates.get();
        long archetypes = this.frontier.archetypes();
        this.resourceLogger.setAndDisplay(archetypes + duplicates);
        this.transferredBytesLogger.setAndDisplay(this.frontier.transferredBytes.get());
        this.receivedURLsLogger.setAndDisplay(this.frontier.numberOfReceivedURLs.get());
        LOGGER.info("Duplicates: " + Util.format((long)duplicates) + " (" + Util.format((double)(100.0 * (double)duplicates / (double)(duplicates + archetypes))) + "%)");
        LOGGER.info("Archetypes 1XX/2XX/3XX/4XX/5XX/Other: " + Util.format((long)this.frontier.archetypesStatus[1].get()) + "/" + Util.format((long)this.frontier.archetypesStatus[2].get()) + "/" + Util.format((long)this.frontier.archetypesStatus[3].get()) + "/" + Util.format((long)this.frontier.archetypesStatus[4].get()) + "/" + Util.format((long)this.frontier.archetypesStatus[5].get()) + "/" + Util.format((long)this.frontier.archetypesStatus[0].get()));
        LOGGER.info("Outdegree stats: " + this.frontier.outdegree.toString());
        LOGGER.info("External outdegree stats: " + this.frontier.externalOutdegree.toString());
        LOGGER.info("Archetype content-length stats: " + this.frontier.contentLength.toString());
        LOGGER.info("Archetypes text/image/application/other: " + Util.format((long)this.frontier.contentTypeText.get()) + "/" + Util.format((long)this.frontier.contentTypeImage.get()) + "/" + Util.format((long)this.frontier.contentTypeApplication.get()) + "/" + Util.format((long)this.frontier.contentTypeOthers.get()));
        LOGGER.info("Ready URLs: " + Util.format((long)this.frontier.readyURLs.size64()));
        LOGGER.info("FetchingThread waits: " + this.frontier.fetchingThreadWaits.get() + "; total wait time: " + this.frontier.fetchingThreadWaitingTimeSum.get());
        this.frontier.resetFetchingThreadsWaitingStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkState() {
        for (VisitState visitState : this.distributor.schemeAuthority2VisitState.visitStates()) {
            if (visitState == null) continue;
            VisitState visitState2 = visitState;
            synchronized (visitState2) {
                if (visitState.workbenchEntry == null && visitState.acquired) {
                    LOGGER.error("Acquired visit state with empty workbench entry: " + visitState);
                }
                if (visitState.workbenchEntry == null && visitState.nextFetch != Long.MAX_VALUE && visitState.isEmpty()) {
                    LOGGER.error("Empty visit state with empty workbench entry: " + visitState);
                }
            }
        }
        long c = 0L;
        for (WorkbenchEntry workbenchEntry : this.frontier.workbench.workbenchEntries()) {
            if (workbenchEntry == null) continue;
            WorkbenchEntry workbenchEntry2 = workbenchEntry;
            synchronized (workbenchEntry2) {
                if (workbenchEntry.isEntirelyBroken()) {
                    ++c;
                }
            }
        }
        long broken = this.frontier.workbench.broken.get();
        if ((double)Math.abs(c - broken) > Math.max(4.0, 0.1 * (double)(c + 1L))) {
            LOGGER.error("Broken count (counter): " + broken + " Broken count (counted): " + c + " (not a problem if it doesn't appear often)");
        }
        return true;
    }

    @Override
    public void run() {
        this.frontier.workbenchSizeInPathQueries = this.frontier.rc.workbenchMaxByteSize / Math.max(1L, this.frontier.weightOfpathQueriesInQueues.get() / (1L + this.frontier.pathQueriesInQueues.get()));
        LOGGER.info("There are now " + this.frontier.pathQueriesInQueues.get() + " URLs in queues (" + Util.formatSize((long)this.frontier.weightOfpathQueriesInQueues.get()) + "B, " + Util.format((double)(100.0 * (double)this.frontier.weightOfpathQueriesInQueues.get() / (double)this.frontier.rc.workbenchMaxByteSize)) + "%)");
        double totalSpeed = 0.0;
        long nonEmptyResolvedVisitStates = 0L;
        int[] dist = new int[32];
        int[] distUnresolved = new int[32];
        int[] distBroken = new int[32];
        long resolvedVisitStates = 0L;
        long brokenVisitStatesOnWorkbench = 0L;
        long unresolved = 0L;
        long brokenPathQueryCount = 0L;
        for (VisitState visitState : this.distributor.schemeAuthority2VisitState.visitStates()) {
            if (visitState == null) continue;
            int size = visitState.size();
            if (visitState.workbenchEntry != null) {
                ++resolvedVisitStates;
                if (visitState.lastExceptionClass != null) {
                    ++brokenVisitStatesOnWorkbench;
                    int n = Fast.mostSignificantBit((int)size) + 1;
                    distBroken[n] = distBroken[n] + 1;
                    brokenPathQueryCount += (long)size;
                    continue;
                }
                int n = Fast.mostSignificantBit((int)size) + 1;
                dist[n] = dist[n] + 1;
                if (size == 0) continue;
                ++nonEmptyResolvedVisitStates;
                continue;
            }
            int n = Fast.mostSignificantBit((int)size) + 1;
            distUnresolved[n] = distUnresolved[n] + 1;
            unresolved += (long)size;
        }
        this.dist = dist;
        this.unresolved = unresolved;
        this.brokenPathQueryCount = brokenPathQueryCount;
        LOGGER.info("Queue dist: " + StatsThread.toString(dist) + " (unresolved: " + unresolved + ", broken: " + brokenPathQueryCount + ")");
        LOGGER.info("BrokenQueue dist: " + StatsThread.toString(distBroken));
        LOGGER.info("UnresolvedQueue dist: " + StatsThread.toString(distUnresolved));
        if (nonEmptyResolvedVisitStates != 0L) {
            this.frontier.averageSpeed = totalSpeed / (double)nonEmptyResolvedVisitStates;
        }
        assert (this.checkState());
        SummaryStats entrySummaryStats = new SummaryStats();
        Iterator<WorkbenchEntry> iterator = this.frontier.workbench.iterator();
        while (iterator.hasNext()) {
            int numVisitStates = iterator.next().size();
            if (numVisitStates == 0) continue;
            entrySummaryStats.add((double)numVisitStates);
        }
        this.entrySummaryStats = entrySummaryStats;
        this.resolvedVisitStates = resolvedVisitStates;
        this.brokenVisitStatesOnWorkbench = brokenVisitStatesOnWorkbench;
        LOGGER.info("Entry stats: " + entrySummaryStats);
        LOGGER.info("Virtualizer stats: " + this.frontier.virtualizer);
        LOGGER.info("Visit states: " + this.distributor.schemeAuthority2VisitState.size() + "; resolved: " + resolvedVisitStates + "; on workbench (IP): " + this.frontier.workbench.approximatedSize() + "; broken on workbench (IP): " + this.frontier.workbench.broken.get() + "; on workbench (S+A): " + (long)entrySummaryStats.sum() + "; to do: " + this.frontier.todo.size() + "; active: " + ((long)this.frontier.rc.fetchingThreads - this.frontier.results.size()) + "; ready to parse: " + this.frontier.results.size() + "; unknown hosts: " + this.frontier.unknownHosts.size() + "; broken: " + this.frontier.brokenVisitStates.get() + " (" + brokenVisitStatesOnWorkbench + " on workbench); waiting: " + this.frontier.newVisitStates.size() + "; on disk: " + this.frontier.virtualizer.onDisk());
        LOGGER.info("Speed dist: " + StatsThread.toString(this.frontier.speedDist));
        int i = this.frontier.speedDist.length();
        while (i-- != 0) {
            this.frontier.speedDist.set(i, 0L);
        }
        LOGGER.info("Cache hits: " + this.frontier.urlCache.hits() + " misses: " + this.frontier.urlCache.misses());
        this.distributor.lastHighCostStat = System.currentTimeMillis();
    }

    public long getVisitStatesOnDisk() {
        return this.frontier.virtualizer.onDisk();
    }

    public int getVisitStates() {
        return this.distributor.schemeAuthority2VisitState.size();
    }

    public void done() {
        this.requestLogger.done();
        this.resourceLogger.done();
        this.transferredBytesLogger.done();
        this.receivedURLsLogger.done();
    }
}

