/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.frontier;

import it.unimi.di.law.bubing.frontier.Frontier;
import it.unimi.di.law.bubing.frontier.VisitState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TodoThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(TodoThread.class);
    private final Frontier frontier;

    public TodoThread(Frontier frontier) {
        this.frontier = frontier;
        this.setName(this.getClass().getSimpleName());
        this.setPriority(10);
    }

    @Override
    public void run() {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                VisitState visitState = this.frontier.workbench.acquire();
                assert (this.frontier.schemeAuthority2Count.get(visitState.schemeAuthority) <= this.frontier.rc.maxUrlsPerSchemeAuthority) : this.frontier.schemeAuthority2Count.get(visitState.schemeAuthority) + " > " + this.frontier.rc.maxUrlsPerSchemeAuthority;
                this.frontier.todo.add(visitState);
            }
        }
        catch (InterruptedException e) {
            LOGGER.info("Interrupted");
        }
        catch (Throwable t) {
            LOGGER.error("Unexpected exception", t);
        }
        LOGGER.info("Completed");
    }
}

