/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.frontier;

import it.unimi.di.law.bubing.frontier.Frontier;
import it.unimi.di.law.bubing.frontier.WorkbenchEntry;
import it.unimi.di.law.bubing.util.BURL;
import it.unimi.di.law.bubing.util.Util;
import it.unimi.dsi.fastutil.objects.ObjectArrayFIFOQueue;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.shorts.Short2ShortMap;
import it.unimi.dsi.fastutil.shorts.Short2ShortOpenHashMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.http.cookie.Cookie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisitState
implements Delayed,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(VisitState.class);
    private static final long serialVersionUID = 1L;
    public static final byte[] ROBOTS_PATH = new byte[]{47, 114, 111, 98, 111, 116, 115, 46, 116, 120, 116};
    public static final Cookie[] EMPTY_COOKIE_ARRAY = new Cookie[0];
    private static final long DEATH_INTERVAL = TimeUnit.HOURS.toMillis(2L);
    public static final long MOVING_AVERAGE_WINDOW = TimeUnit.HOURS.toMillis(1L);
    public final byte[] schemeAuthority;
    public volatile long nextFetch;
    public volatile long lastRobotsFetch;
    public volatile char[][] robotsFilter;
    public volatile transient WorkbenchEntry workbenchEntry;
    public Cookie[] cookies;
    public volatile Class<? extends Throwable> lastExceptionClass;
    public volatile int retries;
    protected volatile transient boolean acquired;
    public transient Frontier frontier;
    private final transient ObjectArrayFIFOQueue<byte[]> pathQueries;
    public final Short2ShortOpenHashMap termCount;
    public volatile int termCountUpdates;
    public volatile float spammicity;

    public VisitState(Frontier frontier, byte[] schemeAuthority) {
        this.frontier = frontier;
        this.schemeAuthority = schemeAuthority;
        this.cookies = EMPTY_COOKIE_ARRAY;
        this.pathQueries = new ObjectArrayFIFOQueue();
        this.termCount = frontier != null && frontier.rc.spamDetector == null ? null : new Short2ShortOpenHashMap();
        this.spammicity = -1.0f;
    }

    public synchronized void setWorkbenchEntry(WorkbenchEntry workbenchEntry) {
        assert (!this.acquired) : this;
        this.workbenchEntry = workbenchEntry;
        if (!this.isEmpty()) {
            workbenchEntry.add(this, this.frontier.workbench);
        }
    }

    private void putInEntryIfNotAcquired() {
        assert (!this.isEmpty()) : this;
        if (!this.acquired && this.workbenchEntry != null) {
            this.workbenchEntry.add(this, this.frontier.workbench);
        }
    }

    public synchronized void putInEntryIfNotEmpty() {
        assert (this.workbenchEntry != null) : this;
        assert (this.acquired) : this;
        assert (this.workbenchEntry.acquired) : this.workbenchEntry;
        if (!this.isEmpty()) {
            this.workbenchEntry.add(this);
        }
        this.acquired = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void enqueueRobots() {
        if (this.nextFetch == Long.MAX_VALUE) {
            return;
        }
        VisitState visitState = this;
        synchronized (visitState) {
            if (this.pathQueries.isEmpty()) {
                this.pathQueries.enqueueFirst((Object)ROBOTS_PATH);
                this.putInEntryIfNotAcquired();
            } else {
                byte[] first = (byte[])this.pathQueries.dequeue();
                this.pathQueries.enqueueFirst((Object)ROBOTS_PATH);
                this.pathQueries.enqueueFirst((Object)first);
            }
        }
    }

    public synchronized void forciblyEnqueueRobotsFirst() {
        this.pathQueries.enqueueFirst((Object)ROBOTS_PATH);
    }

    void removeRobots() {
        if (this.pathQueries.isEmpty()) {
            return;
        }
        byte[] firstPath = (byte[])this.pathQueries.dequeue();
        if (firstPath == ROBOTS_PATH) {
            this.lastRobotsFetch = Long.MAX_VALUE;
            return;
        }
        if (this.isEmpty()) {
            this.pathQueries.enqueueFirst((Object)firstPath);
            return;
        }
        byte[] secondPath = (byte[])this.pathQueries.dequeue();
        if (secondPath == ROBOTS_PATH) {
            this.pathQueries.enqueueFirst((Object)firstPath);
            this.lastRobotsFetch = Long.MAX_VALUE;
            return;
        }
        this.pathQueries.enqueueFirst((Object)secondPath);
        this.pathQueries.enqueueFirst((Object)firstPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueuePathQuery(byte[] pathQuery) {
        VisitState visitState = this;
        synchronized (visitState) {
            if (this.nextFetch == Long.MAX_VALUE) {
                return;
            }
            boolean wasEmpty = this.pathQueries.isEmpty();
            this.pathQueries.enqueue((Object)pathQuery);
            if (wasEmpty) {
                this.putInEntryIfNotAcquired();
            }
        }
        this.frontier.pathQueriesInQueues.incrementAndGet();
        this.frontier.weightOfpathQueriesInQueues.addAndGet(BURL.memoryUsageOf(pathQuery));
    }

    public synchronized byte[] firstPath() {
        return (byte[])this.pathQueries.first();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] dequeue() {
        byte[] array;
        VisitState visitState = this;
        synchronized (visitState) {
            array = (byte[])this.pathQueries.dequeue();
        }
        if (array != ROBOTS_PATH) {
            this.frontier.pathQueriesInQueues.decrementAndGet();
            this.frontier.weightOfpathQueriesInQueues.addAndGet(-BURL.memoryUsageOf(array));
        }
        return array;
    }

    public synchronized void clear() {
        while (!this.isEmpty()) {
            this.dequeue();
        }
        this.pathQueries.trim();
    }

    public synchronized int size() {
        return this.pathQueries.size();
    }

    public synchronized boolean isEmpty() {
        return this.pathQueries.isEmpty();
    }

    public boolean isAlive(long time) {
        return this.size() != 0 || this.nextFetch >= time - DEATH_INTERVAL;
    }

    public String toString() {
        return "[" + Util.toString(this.schemeAuthority) + " (" + this.size() + (this.lastExceptionClass != null ? ", " + this.lastExceptionClass.getSimpleName() : "") + ")]";
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(Math.max(0L, this.nextFetch - System.currentTimeMillis()), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        return Long.signum(this.nextFetch - ((VisitState)o).nextFetch);
    }

    public synchronized void schedulePurge() {
        assert (this.acquired || this.workbenchEntry == null) : this.acquired + " " + this.workbenchEntry;
        this.frontier.schemeAuthority2Count.put(this.schemeAuthority, Integer.MAX_VALUE);
        this.nextFetch = Long.MAX_VALUE;
        this.clear();
    }

    public void checkRobots(long time) {
        long robotsExpiration;
        if (this.robotsFilter == null && this.lastRobotsFetch != Long.MAX_VALUE && (this.isEmpty() || this.firstPath() != ROBOTS_PATH)) {
            LOGGER.error("No robots filter and no robots path for " + this);
            this.lastRobotsFetch = Long.MAX_VALUE;
            this.enqueueRobots();
            return;
        }
        if (this.lastExceptionClass == null && time - (robotsExpiration = this.frontier.rc.robotsExpiration) >= this.lastRobotsFetch) {
            if (this.robotsFilter == null) {
                if (this.lastRobotsFetch == 0L) {
                    LOGGER.info("Going to get robots for {} for the first time", (Object)Util.toString(this.schemeAuthority));
                } else {
                    LOGGER.info("Going to try again to get robots for {}", (Object)Util.toString(this.schemeAuthority));
                }
            } else {
                LOGGER.info("Going to get robots for {} because it has expired ({} >= {} ms have passed)", new Object[]{Util.toString(this.schemeAuthority), time - this.lastRobotsFetch, robotsExpiration});
            }
            this.lastRobotsFetch = Long.MAX_VALUE;
            this.enqueueRobots();
        }
    }

    public int pathQueryLimit() {
        double delayRatio = Math.max(1.0, ((double)this.frontier.rc.schemeAuthorityDelay + 1.0) / ((double)this.frontier.rc.ipDelay + 1.0));
        double scalingFactor = this.workbenchEntry == null ? 1.0 : Math.max(1.0, (double)this.workbenchEntry.size() / delayRatio);
        return (int)Math.min(300000L / (this.frontier.rc.schemeAuthorityDelay + 1L), Math.max(4L, (long)Math.ceil((double)this.frontier.workbenchSizeInPathQueries / (scalingFactor * (double)this.frontier.requiredFrontSize.get()))));
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        int size = this.pathQueries.size();
        s.writeInt(size);
        while (size-- != 0) {
            Util.writeByteArray((byte[])this.pathQueries.dequeue(), s);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        s.defaultReadObject();
        int size = s.readInt();
        Field field = this.getClass().getDeclaredField("pathQueries");
        field.setAccessible(true);
        field.set(this, new ObjectArrayFIFOQueue(size));
        while (size-- != 0) {
            this.pathQueries.enqueue((Object)Util.readByteArray(s));
        }
    }

    private void updateTermCountEntry(Short2ShortMap.Entry e) {
        short oldValue = this.termCount.get(e.getShortKey());
        this.termCount.put(e.getShortKey(), (short)Math.min(oldValue + e.getShortValue(), Short.MAX_VALUE));
    }

    public void updateTermCount(Short2ShortMap termCount) {
        ++this.termCountUpdates;
        if (termCount instanceof Short2ShortOpenHashMap) {
            ObjectIterator fastIterator = ((Short2ShortOpenHashMap)termCount).short2ShortEntrySet().fastIterator();
            while (fastIterator.hasNext()) {
                this.updateTermCountEntry((Short2ShortMap.Entry)fastIterator.next());
            }
        } else {
            for (Short2ShortMap.Entry e : termCount.short2ShortEntrySet()) {
                this.updateTermCountEntry(e);
            }
        }
    }
}

