/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.frontier;

import com.google.common.collect.Iterators;
import it.unimi.di.law.bubing.frontier.VisitState;
import it.unimi.di.law.bubing.frontier.WorkbenchEntry;
import it.unimi.di.law.bubing.frontier.WorkbenchEntrySet;
import java.util.Iterator;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.atomic.AtomicLong;

public class Workbench
implements Iterable<WorkbenchEntry> {
    protected final WorkbenchEntrySet address2WorkbenchEntry;
    private final DelayQueue<WorkbenchEntry> entries = new DelayQueue();
    private final AtomicLong approximatedSize;
    public final AtomicLong broken;

    public Workbench() {
        this.address2WorkbenchEntry = new WorkbenchEntrySet();
        this.approximatedSize = new AtomicLong();
        this.broken = new AtomicLong();
    }

    @Override
    public Iterator<WorkbenchEntry> iterator() {
        return Iterators.unmodifiableIterator(this.entries.iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkbenchEntry[] workbenchEntries() {
        WorkbenchEntrySet workbenchEntrySet = this.address2WorkbenchEntry;
        synchronized (workbenchEntrySet) {
            return this.address2WorkbenchEntry.workbenchEntries();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkbenchEntry getWorkbenchEntry(byte[] address) {
        WorkbenchEntry workbenchEntry;
        WorkbenchEntrySet workbenchEntrySet = this.address2WorkbenchEntry;
        synchronized (workbenchEntrySet) {
            workbenchEntry = this.address2WorkbenchEntry.get(address);
            if (workbenchEntry == null) {
                workbenchEntry = new WorkbenchEntry(address, this.broken);
                this.address2WorkbenchEntry.add(workbenchEntry);
            }
        }
        return workbenchEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numberOfWorkbenchEntries() {
        WorkbenchEntrySet workbenchEntrySet = this.address2WorkbenchEntry;
        synchronized (workbenchEntrySet) {
            return this.address2WorkbenchEntry.size();
        }
    }

    public void add(WorkbenchEntry entry) {
        assert (!entry.isEmpty()) : entry;
        assert (!entry.acquired) : entry;
        this.entries.add(entry);
        this.approximatedSize.incrementAndGet();
    }

    public VisitState acquire() throws InterruptedException {
        WorkbenchEntry entry = (WorkbenchEntry)this.entries.take();
        assert (!entry.isEmpty());
        assert (!entry.acquired);
        entry.acquired = true;
        VisitState visitState = entry.remove();
        assert (visitState.workbenchEntry == entry);
        assert (!visitState.isEmpty());
        assert (!visitState.acquired);
        visitState.acquired = true;
        this.approximatedSize.decrementAndGet();
        return visitState;
    }

    public void release(VisitState visitState) {
        assert (visitState.acquired) : visitState;
        WorkbenchEntry workbenchEntry = visitState.workbenchEntry;
        assert (workbenchEntry != null);
        assert (workbenchEntry.acquired) : workbenchEntry;
        visitState.putInEntryIfNotEmpty();
        workbenchEntry.putOnWorkbenchIfNotEmpty(this);
    }

    public long approximatedSize() {
        return this.approximatedSize.get();
    }
}

