/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.frontier;

import it.unimi.di.law.bubing.frontier.VisitState;
import it.unimi.di.law.bubing.frontier.Workbench;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.PriorityQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WorkbenchEntry
implements Delayed {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbenchEntry.class);
    private static final boolean ASSERTS = false;
    private final PriorityQueue<VisitState> visitStates;
    public final byte[] ipAddress;
    private final AtomicLong workbenchBroken;
    private int brokenVisitStates;
    protected boolean acquired;
    protected volatile long nextFetch;

    public WorkbenchEntry(byte[] ipAddress, AtomicLong brokenVisitStates) {
        this.ipAddress = ipAddress;
        this.workbenchBroken = brokenVisitStates;
        this.visitStates = new PriorityQueue();
    }

    public synchronized boolean isEntirelyBroken() {
        return this.brokenVisitStates != 0 && this.brokenVisitStates == this.visitStates.size();
    }

    public synchronized void add(VisitState visitState) {
        boolean wasEntirelyBroken = this.isEntirelyBroken();
        if (visitState.lastExceptionClass != null) {
            ++this.brokenVisitStates;
        }
        this.visitStates.add(visitState);
        assert (this.brokenVisitStates <= this.visitStates.size());
        if (wasEntirelyBroken && !this.isEntirelyBroken()) {
            this.workbenchBroken.decrementAndGet();
        }
        if (!wasEntirelyBroken && this.isEntirelyBroken()) {
            this.workbenchBroken.incrementAndGet();
        }
    }

    public synchronized VisitState remove() {
        boolean wasEntirelyBroken = this.isEntirelyBroken();
        VisitState visitState = (VisitState)this.visitStates.remove();
        if (visitState.lastExceptionClass != null) {
            --this.brokenVisitStates;
        }
        assert (this.brokenVisitStates >= 0);
        assert (this.brokenVisitStates <= this.visitStates.size());
        if (wasEntirelyBroken && !this.isEntirelyBroken()) {
            this.workbenchBroken.decrementAndGet();
        }
        if (!wasEntirelyBroken && this.isEntirelyBroken()) {
            this.workbenchBroken.incrementAndGet();
        }
        return visitState;
    }

    public synchronized void putOnWorkbenchIfNotEmpty(Workbench workbench) {
        assert (this.acquired) : this;
        this.acquired = false;
        if (!this.isEmpty()) {
            workbench.add(this);
        }
    }

    public synchronized void add(VisitState visitState, Workbench workbench) {
        assert (!visitState.isEmpty()) : visitState;
        boolean wasEmpty = this.isEmpty();
        this.add(visitState);
        if (wasEmpty && !this.acquired) {
            workbench.add(this);
        }
    }

    public synchronized int size() {
        return this.visitStates.size();
    }

    public synchronized VisitState[] visitStates() {
        return this.visitStates.toArray(new VisitState[this.visitStates.size()]);
    }

    public synchronized boolean isEmpty() {
        return this.visitStates.isEmpty();
    }

    public synchronized long nextFetch() {
        assert (this.visitStates.peek() != null);
        return Math.max(this.nextFetch, this.visitStates.peek().nextFetch);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(Math.max(0L, this.nextFetch() - System.currentTimeMillis()), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        return Long.signum(this.nextFetch() - ((WorkbenchEntry)o).nextFetch());
    }

    public synchronized String toString() {
        try {
            return "[" + InetAddress.getByAddress(this.ipAddress) + " (" + this.visitStates.size() + ")]";
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

