/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.frontier;

import it.unimi.di.law.bubing.frontier.WorkbenchEntry;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class WorkbenchEntrySet
implements Serializable,
Hash {
    private static final long serialVersionUID = 0L;
    protected transient WorkbenchEntry[] workbenchEntry;
    protected transient int n = 1024;
    protected transient int mask = this.n - 1;
    protected int size;
    protected int maxFill = 3 * (this.n / 4);

    public WorkbenchEntrySet() {
        this.workbenchEntry = new WorkbenchEntry[this.n];
    }

    public WorkbenchEntry[] workbenchEntries() {
        return this.workbenchEntry;
    }

    public void ensureCapacity(int capacity) {
        this.rehash(HashCommon.arraySize((int)capacity, (float)0.75f));
    }

    private static final int hashCode(byte[] a) {
        return HashCommon.murmurHash3((int)Arrays.hashCode(a));
    }

    public boolean add(WorkbenchEntry e) {
        int pos = WorkbenchEntrySet.hashCode(e.ipAddress) & this.mask;
        while (this.workbenchEntry[pos] != null) {
            if (Arrays.equals(this.workbenchEntry[pos].ipAddress, e.ipAddress)) {
                return false;
            }
            pos = pos + 1 & this.mask;
        }
        this.workbenchEntry[pos] = e;
        if (++this.size >= this.maxFill && this.n < 0x40000000) {
            this.rehash(2 * this.n);
        }
        return true;
    }

    protected final int shiftKeys(int pos) {
        int last;
        while (true) {
            last = pos;
            pos = last + 1 & this.mask;
            while (this.workbenchEntry[pos] != null) {
                int slot = WorkbenchEntrySet.hashCode(this.workbenchEntry[pos].ipAddress) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (this.workbenchEntry[pos] == null) break;
            this.workbenchEntry[last] = this.workbenchEntry[pos];
        }
        this.workbenchEntry[last] = null;
        return last;
    }

    public boolean remove(WorkbenchEntry e) {
        int pos = WorkbenchEntrySet.hashCode(e.ipAddress) & this.mask;
        while (this.workbenchEntry[pos] != null) {
            if (this.workbenchEntry[pos] == e) {
                --this.size;
                this.shiftKeys(pos);
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    public WorkbenchEntry get(byte[] address) {
        int pos = WorkbenchEntrySet.hashCode(address) & this.mask;
        while (this.workbenchEntry[pos] != null) {
            if (Arrays.equals(this.workbenchEntry[pos].ipAddress, address)) {
                return this.workbenchEntry[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        Arrays.fill(this.workbenchEntry, null);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    protected void rehash(int newN) {
        int i = 0;
        WorkbenchEntry[] workbenchEntry = this.workbenchEntry;
        int newMask = newN - 1;
        WorkbenchEntry[] newWorkbenchEntry = new WorkbenchEntry[newN];
        int j = this.size;
        while (j-- != 0) {
            while (workbenchEntry[i] == null) {
                ++i;
            }
            WorkbenchEntry e = workbenchEntry[i];
            int pos = WorkbenchEntrySet.hashCode(e.ipAddress) & newMask;
            while (newWorkbenchEntry[pos] != null) {
                pos = pos + 1 & newMask;
            }
            newWorkbenchEntry[pos] = e;
            ++i;
        }
        this.n = newN;
        this.mask = newMask;
        this.maxFill = 3 * (this.n / 4);
        this.workbenchEntry = newWorkbenchEntry;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        int i = this.workbenchEntry.length;
        while (i-- != 0) {
            if (this.workbenchEntry[i] == null) continue;
            s.writeObject(this.workbenchEntry[i]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize((int)this.size, (float)0.75f);
        this.maxFill = 3 * (this.n / 4);
        this.mask = this.n - 1;
        this.workbenchEntry = new WorkbenchEntry[this.n];
        WorkbenchEntry[] workbenchEntry = this.workbenchEntry;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            WorkbenchEntry e = (WorkbenchEntry)s.readObject();
            pos = WorkbenchEntrySet.hashCode(e.ipAddress) & this.mask;
            while (workbenchEntry[pos] != null) {
                pos = pos + 1 & this.mask;
            }
        }
    }
}

