/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.frontier;

import it.unimi.di.law.bubing.frontier.Frontier;
import it.unimi.di.law.bubing.frontier.VisitState;
import it.unimi.di.law.bubing.frontier.VisitStateSet;
import it.unimi.di.law.bubing.util.BURL;
import it.unimi.di.law.bubing.util.ByteArrayDiskQueues;
import it.unimi.di.law.bubing.util.Util;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkbenchVirtualizer
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbenchVirtualizer.class);
    private final ByteArrayDiskQueues byteArrayDiskQueues;
    private final Frontier frontier;
    private final File directory;

    public WorkbenchVirtualizer(Frontier frontier) {
        this.frontier = frontier;
        this.directory = new File(frontier.rc.frontierDir, "virtualizer");
        this.directory.mkdir();
        this.byteArrayDiskQueues = new ByteArrayDiskQueues(this.directory);
    }

    public int dequeuePathQueries(VisitState visitState, int maxUrls) throws IOException {
        int dequeued;
        if (maxUrls == 0) {
            return 0;
        }
        int i = dequeued = (int)Math.min((long)maxUrls, this.byteArrayDiskQueues.count(visitState));
        while (i-- != 0) {
            visitState.enqueuePathQuery(this.byteArrayDiskQueues.dequeue(visitState));
        }
        return dequeued;
    }

    public long count(VisitState visitState) {
        return this.byteArrayDiskQueues.count(visitState);
    }

    public int onDisk() {
        return this.byteArrayDiskQueues.numKeys();
    }

    public void remove(VisitState visitState) throws IOException {
        this.byteArrayDiskQueues.remove(visitState);
    }

    public void enqueueURL(VisitState visitState, ByteArrayList url) throws IOException {
        byte[] urlBuffer = url.elements();
        int pathQueryStart = BURL.startOfpathAndQuery(urlBuffer);
        this.byteArrayDiskQueues.enqueue(visitState, urlBuffer, pathQueryStart, url.size() - pathQueryStart);
    }

    public void collectIf(double threshold, double targetRatio) throws IOException {
        if (this.byteArrayDiskQueues.ratio() < threshold) {
            LOGGER.info("Starting collection...");
            this.byteArrayDiskQueues.collect(targetRatio);
            LOGGER.info("Completed collection.");
        }
    }

    @Override
    public void close() throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(new File(this.directory, "metadata"))));
        this.byteArrayDiskQueues.close();
        this.writeMetadata(oos);
    }

    public String toString() {
        return "URLs on disk: " + this.byteArrayDiskQueues.size64() + "; fill ratio: " + this.byteArrayDiskQueues.ratio();
    }

    private void writeMetadata(ObjectOutputStream oos) throws IOException {
        oos.writeLong(this.byteArrayDiskQueues.size);
        oos.writeLong(this.byteArrayDiskQueues.appendPointer);
        oos.writeLong(this.byteArrayDiskQueues.used);
        oos.writeLong(this.byteArrayDiskQueues.allocated);
        oos.writeInt(this.byteArrayDiskQueues.buffers.size());
        oos.writeInt(this.byteArrayDiskQueues.key2QueueData.size());
        ObjectIterator fastIterator = this.byteArrayDiskQueues.key2QueueData.reference2ObjectEntrySet().fastIterator();
        int i = this.byteArrayDiskQueues.key2QueueData.size();
        while (i-- != 0) {
            Reference2ObjectMap.Entry next = (Reference2ObjectMap.Entry)fastIterator.next();
            VisitState visitState = (VisitState)next.getKey();
            if (visitState == null) {
                LOGGER.error("Map iterator returned null key");
                continue;
            }
            if (visitState.schemeAuthority == null) {
                LOGGER.error("Map iterator returned visit state with null schemeAuthority");
            } else {
                Util.writeVByte(visitState.schemeAuthority.length, oos);
            }
            oos.write(visitState.schemeAuthority);
            oos.writeObject(next.getValue());
        }
        oos.close();
    }

    public void readMetadata() throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream((InputStream)new FastBufferedInputStream((InputStream)new FileInputStream(new File(this.directory, "metadata"))));
        this.byteArrayDiskQueues.size = ois.readLong();
        this.byteArrayDiskQueues.appendPointer = ois.readLong();
        this.byteArrayDiskQueues.used = ois.readLong();
        this.byteArrayDiskQueues.allocated = ois.readLong();
        int n = ois.readInt();
        this.byteArrayDiskQueues.buffers.size(n);
        this.byteArrayDiskQueues.files.size(n);
        VisitStateSet schemeAuthority2VisitState = this.frontier.distributor.schemeAuthority2VisitState;
        byte[] schemeAuthority = new byte[1024];
        int i = ois.readInt();
        while (i-- != 0) {
            int length = Util.readVByte(ois);
            if (schemeAuthority.length < length) {
                schemeAuthority = new byte[length];
            }
            ois.readFully(schemeAuthority, 0, length);
            VisitState visitState = schemeAuthority2VisitState.get(schemeAuthority, 0, length);
            if (visitState != null) {
                this.byteArrayDiskQueues.key2QueueData.put((Object)visitState, (Object)((ByteArrayDiskQueues.QueueData)ois.readObject()));
                continue;
            }
            LOGGER.error("No visit state found for " + Util.toString(schemeAuthority));
        }
        ois.close();
    }
}

