/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.parser;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import it.unimi.di.law.bubing.parser.Parser;
import it.unimi.di.law.warc.filters.URIResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import org.apache.http.HttpResponse;

public class BinaryParser
implements Parser<Void> {
    private final HashFunction hashFunction;
    private byte[] buffer;
    private boolean crossAuthorityDuplicates;

    public static final HashFunction forName(String messageDigest) throws NoSuchAlgorithmException {
        if ("".equals(messageDigest)) {
            return null;
        }
        if ("MD5".equalsIgnoreCase(messageDigest)) {
            return Hashing.md5();
        }
        if ("MurmurHash3".equalsIgnoreCase(messageDigest)) {
            return Hashing.murmur3_128();
        }
        throw new NoSuchAlgorithmException("Unknown hash function " + messageDigest);
    }

    public BinaryParser(HashFunction hashFunction) {
        this(hashFunction, false);
    }

    public BinaryParser(HashFunction hashFunction, boolean crossAuthorityDuplicates) {
        this.hashFunction = hashFunction;
        this.buffer = new byte[1024];
        this.crossAuthorityDuplicates = crossAuthorityDuplicates;
    }

    public BinaryParser(String messageDigestAlgorithm) throws NoSuchAlgorithmException {
        this(BinaryParser.forName(messageDigestAlgorithm));
    }

    public Hasher init(URI url) {
        Hasher hasher = this.hashFunction.newHasher();
        if (url != null) {
            hasher.putUnencodedChars((CharSequence)url.getHost());
            hasher.putByte((byte)0);
        }
        return hasher;
    }

    @Override
    public byte[] parse(URI uri, HttpResponse httpResponse, Parser.LinkReceiver linkReceiver) throws IOException {
        int length;
        if (this.hashFunction == null) {
            return null;
        }
        InputStream is = httpResponse.getEntity().getContent();
        Hasher hasher = this.init(this.crossAuthorityDuplicates ? null : uri);
        while ((length = is.read(this.buffer, 0, this.buffer.length)) > 0) {
            hasher.putBytes(this.buffer, 0, length);
        }
        return hasher.hash().asBytes();
    }

    public boolean apply(URIResponse response) {
        return true;
    }

    public Object clone() {
        return new BinaryParser(this.hashFunction);
    }

    @Override
    public String guessedCharset() {
        return null;
    }

    @Override
    public BinaryParser copy() {
        return new BinaryParser(this.hashFunction, this.crossAuthorityDuplicates);
    }

    @Override
    public Void result() {
        return null;
    }
}

