/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.parser;

import it.unimi.di.law.bubing.parser.Parser;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.objects.Object2LongFunction;
import it.unimi.dsi.fastutil.shorts.Short2ShortOpenHashMap;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.lang.MutableString;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.commons.io.input.CharSequenceReader;

public final class SpamTextProcessor
implements Parser.TextProcessor<TermCount> {
    private final FastBufferedReader fbr = new FastBufferedReader();
    private final TermCount termCount = new TermCount();
    private final Object2LongFunction<MutableString> termSetOnthology;

    public SpamTextProcessor(Object2LongFunction<MutableString> termSetOnthology) {
        this.termSetOnthology = termSetOnthology;
    }

    public SpamTextProcessor(String termSetOnthologyURI) throws ClassNotFoundException, MalformedURLException, IOException {
        this.termSetOnthology = (Object2LongFunction)BinIO.loadObject((InputStream)new URL(termSetOnthologyURI).openStream());
    }

    private void process() throws IOException {
        MutableString word = new MutableString();
        MutableString nonWord = new MutableString();
        while (this.fbr.next(word, nonWord)) {
            short oldValue;
            short index = (short)this.termSetOnthology.getLong((Object)word.toLowerCase());
            if (index == -1 || (oldValue = this.termCount.get(index)) >= Short.MAX_VALUE) continue;
            this.termCount.put(index, (short)(oldValue + 1));
        }
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        this.fbr.setReader((Reader)new CharSequenceReader(csq));
        this.process();
        return this;
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        this.fbr.setReader((Reader)new CharSequenceReader(csq.subSequence(start, end)));
        this.process();
        return this;
    }

    @Override
    public Appendable append(char c) throws IOException {
        short oldValue;
        short index = (short)this.termSetOnthology.getLong((Object)new MutableString().append(Character.toLowerCase(c)));
        if (index != -1 && (oldValue = this.termCount.get(index)) < Short.MAX_VALUE) {
            this.termCount.put(index, (short)(oldValue + 1));
        }
        return this;
    }

    @Override
    public void init(URI responseUrl) {
        this.termCount.clear();
    }

    @Override
    public TermCount result() {
        return this.termCount;
    }

    public Parser.TextProcessor<TermCount> copy() {
        return new SpamTextProcessor(this.termSetOnthology);
    }

    public static final class TermCount
    extends Short2ShortOpenHashMap {
        private static final long serialVersionUID = 1L;
    }
}

