/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.sieve;

import it.unimi.di.law.bubing.sieve.ByteSerializerDeserializer;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.TransformationStrategies;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.sux4j.mph.AbstractHashFunction;
import it.unimi.dsi.sux4j.mph.Hashes;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.NoSuchElementException;

public abstract class AbstractSieve<K, V>
implements Closeable {
    protected final ByteSerializerDeserializer<K> keySerDeser;
    protected final ByteSerializerDeserializer<V> valueSerDeser;
    protected final AbstractHashFunction<K> hashingStrategy;
    protected final UpdateStrategy<K, V> updateStrategy;
    protected NewFlowReceiver<K> newFlowReceiver;
    public static final AbstractHashFunction<CharSequence> CHAR_SEQUENCE_HASHING_STRATEGY = new CharSequenceHashFunction();

    public AbstractSieve(ByteSerializerDeserializer<K> keySerDeser, ByteSerializerDeserializer<V> valueSerDeser, AbstractHashFunction<K> hashingStrategy, UpdateStrategy<K, V> updateStrategy) {
        this.keySerDeser = keySerDeser;
        this.valueSerDeser = valueSerDeser;
        this.hashingStrategy = hashingStrategy;
        this.updateStrategy = updateStrategy;
    }

    public abstract boolean enqueue(K var1, V var2) throws IOException, InterruptedException;

    @Override
    public abstract void close() throws IOException;

    public void setNewFlowRecevier(NewFlowReceiver<K> newFlowReceiver) {
        this.newFlowReceiver = newFlowReceiver;
    }

    public abstract void flush() throws IOException, InterruptedException;

    public static interface UpdateStrategy<K, V> {
        public V update(K var1, V var2, V var3);
    }

    public static class SieveEntry<K, V> {
        public K key;
        public V value;

        public SieveEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return "<" + this.key + "," + this.value + ">";
        }
    }

    private static final class CharSequenceHashFunction
    extends AbstractHashFunction<CharSequence> {
        private static final long serialVersionUID = -920229826501456017L;
        private static final TransformationStrategy<CharSequence> transf = TransformationStrategies.iso();

        private CharSequenceHashFunction() {
        }

        public long getLong(Object key) {
            return Hashes.murmur((BitVector)transf.toBitVector((Object)((CharSequence)key)), (long)0L);
        }
    }

    public static final class DefaultUpdateStrategy<K, V>
    implements UpdateStrategy<K, V> {
        @Override
        public V update(K key, V newValue, V oldValue) {
            return newValue;
        }
    }

    public static final class DiskNewFlow<T>
    implements NewFlowReceiver<T> {
        private final ByteSerializerDeserializer<T> serializer;
        private final String baseName;
        private long size;
        private long appendSize;
        private DataInputStream input;
        private int inputIndex;
        private DataOutputStream output;
        private int outputIndex;
        private boolean closed;

        public DiskNewFlow(ByteSerializerDeserializer<T> serializer) throws IOException {
            this.serializer = serializer;
            this.baseName = File.createTempFile(DiskNewFlow.class.getSimpleName(), "-tmp").toString();
            this.inputIndex = -1;
            this.outputIndex = 0;
            this.size = 0L;
        }

        public synchronized long size() {
            return this.size;
        }

        @Override
        public synchronized void prepareToAppend() throws IOException {
            if (this.closed) {
                throw new IllegalStateException();
            }
            this.appendSize = 0L;
            this.output = new DataOutputStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(new File(this.baseName + this.outputIndex))));
        }

        @Override
        public synchronized void append(long hash, T key) throws IOException {
            if (this.closed) {
                throw new IllegalStateException();
            }
            this.output.writeLong(hash);
            this.serializer.toStream(key, this.output);
            ++this.appendSize;
        }

        @Override
        public synchronized void finishedAppending() throws IOException {
            if (this.closed) {
                throw new IllegalStateException();
            }
            this.output.close();
            File f = new File(this.baseName + this.outputIndex);
            if (f.length() == 0L) {
                f.delete();
            } else {
                ++this.outputIndex;
            }
            this.size += this.appendSize;
            this.notifyAll();
        }

        @Override
        public synchronized void noMoreAppend() throws IOException {
            this.closed = true;
        }

        public synchronized MutableString dequeueKey() throws NoSuchElementException, IOException, InterruptedException {
            if (this.closed && this.size() == 0L) {
                throw new NoSuchElementException();
            }
            while (!this.closed && this.size() == 0L) {
                this.wait();
                if (!this.closed || this.size() != 0L) continue;
                throw new NoSuchElementException();
            }
            assert (this.size() > 0L) : this.size() + " <= 0";
            while (this.inputIndex == -1 || this.input.available() == 0) {
                if (this.inputIndex != -1) {
                    this.input.close();
                    new File(this.baseName + this.inputIndex).delete();
                }
                File file = new File(this.baseName + ++this.inputIndex);
                file.deleteOnExit();
                this.input = new DataInputStream((InputStream)new FastBufferedInputStream((InputStream)new FileInputStream(file)));
            }
            this.input.readLong();
            --this.size;
            return new MutableString().readSelfDelimUTF8((InputStream)this.input);
        }
    }

    public static interface NewFlowReceiver<K> {
        public void prepareToAppend() throws IOException;

        public void append(long var1, K var3) throws IOException;

        public void finishedAppending() throws IOException;

        public void noMoreAppend() throws IOException;
    }
}

