/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.sieve;

import it.unimi.di.law.bubing.sieve.ByteSerializerDeserializer;
import it.unimi.di.law.bubing.util.Util;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteArrayListByteSerializerDeserializer
implements ByteSerializerDeserializer<ByteArrayList> {
    private final ByteArrayList buffer = new ByteArrayList();

    @Override
    public ByteArrayList fromStream(InputStream is) throws IOException {
        int length = Util.readVByte(is);
        this.buffer.size(length);
        int actual = is.read(this.buffer.elements(), 0, length);
        if (actual != length) {
            throw new IOException("Asked for " + length + " but got " + actual);
        }
        return this.buffer;
    }

    @Override
    public void toStream(ByteArrayList list, OutputStream os) throws IOException {
        int length = list.size();
        Util.writeVByte(length, os);
        os.write(list.elements(), 0, length);
    }

    @Override
    public void skip(FastBufferedInputStream is) throws IOException {
        int length = Util.readVByte((InputStream)is);
        long actual = is.skip((long)length);
        if (actual != (long)length) {
            throw new IOException("Asked for " + length + " but got " + actual);
        }
    }
}

