/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.sieve;

import it.unimi.di.law.bubing.util.Util;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public interface ByteSerializerDeserializer<V> {
    public static final ByteSerializerDeserializer<Void> VOID = new ByteSerializerDeserializer<Void>(){

        @Override
        public Void fromStream(InputStream is) throws IOException {
            return null;
        }

        @Override
        public void toStream(Void v, OutputStream os) throws IOException {
        }

        @Override
        public void skip(FastBufferedInputStream is) throws IOException {
        }
    };
    public static final ByteSerializerDeserializer<Integer> INTEGER = new ByteSerializerDeserializer<Integer>(){

        @Override
        public Integer fromStream(InputStream is) throws IOException {
            return new DataInputStream(is).readInt();
        }

        @Override
        public void toStream(Integer i, OutputStream os) throws IOException {
            new DataOutputStream(os).writeInt(i);
        }

        @Override
        public void skip(FastBufferedInputStream is) throws IOException {
            is.skip(4L);
        }
    };
    public static final ByteSerializerDeserializer<byte[]> BYTE_ARRAY = new ByteSerializerDeserializer<byte[]>(){

        @Override
        public byte[] fromStream(InputStream is) throws IOException {
            int length = Util.readVByte(is);
            byte[] array = new byte[length];
            int actual = is.read(array);
            if (actual != length) {
                throw new IOException("Asked for " + length + " but got " + actual);
            }
            return array;
        }

        @Override
        public void toStream(byte[] array, OutputStream os) throws IOException {
            int length = array.length;
            Util.writeVByte(length, os);
            os.write(array);
        }

        @Override
        public void skip(FastBufferedInputStream is) throws IOException {
            int b;
            int length = 0;
            while ((b = is.read()) >= 128) {
                length |= b & 0x7F;
                length <<= 7;
            }
            if (b == -1) {
                throw new EOFException();
            }
            long actual = is.skip((long)(length |= b));
            if (actual != (long)length) {
                throw new IOException("Asked for " + length + " but got " + actual);
            }
        }
    };

    public V fromStream(InputStream var1) throws IOException;

    public void toStream(V var1, OutputStream var2) throws IOException;

    public void skip(FastBufferedInputStream var1) throws IOException;
}

