/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.sieve;

import it.unimi.di.law.bubing.sieve.AbstractSieve;
import it.unimi.di.law.bubing.sieve.ByteSerializerDeserializer;
import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.sux4j.mph.AbstractHashFunction;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MercatorSieve<K, V>
extends AbstractSieve<K, V> {
    private static Logger LOGGER = LoggerFactory.getLogger(MercatorSieve.class);
    private final Store store;
    private final Bucket<K> bucket;
    private volatile boolean closed;
    private final int[] position;

    public MercatorSieve(boolean sieveIsNew, File sieveDir, int sieveSize, int storeIOBufferSize, int auxFileIOBufferSize, AbstractSieve.NewFlowReceiver<K> newFlowReceiver, ByteSerializerDeserializer<K> keySerDeser, ByteSerializerDeserializer<V> valueSerDeser, AbstractHashFunction<K> hashingStrategy, AbstractSieve.UpdateStrategy<K, V> updateStrategy) throws IOException {
        super(keySerDeser, valueSerDeser, hashingStrategy, updateStrategy);
        LOGGER.info("Creating Mercator sieve of size " + sieveSize + " (" + Util.formatSize2((long)((long)sieveSize * 12L)) + " bytes), store I/O buffer size " + storeIOBufferSize + " and aux-file I/O buffer size " + auxFileIOBufferSize);
        this.setNewFlowRecevier(newFlowReceiver);
        if ((storeIOBufferSize & 7) != 0) {
            throw new IllegalArgumentException("Store I/O buffer size length must be a multiple of 8");
        }
        this.bucket = new Bucket<K>(sieveSize, auxFileIOBufferSize, sieveDir, keySerDeser);
        this.store = new Store(sieveIsNew, sieveDir, "store", storeIOBufferSize);
        this.position = new int[sieveSize];
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.flush();
        this.bucket.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean enqueue(K key, V value) throws IOException, InterruptedException {
        if (this.closed) {
            throw new IllegalStateException();
        }
        long hash = this.hashingStrategy.getLong(key);
        MercatorSieve mercatorSieve = this;
        synchronized (mercatorSieve) {
            this.bucket.append(hash, key);
            if (this.bucket.isFull()) {
                this.flush();
                return true;
            }
            return false;
        }
    }

    public int numberOfItems() {
        return ((Bucket)this.bucket).items;
    }

    @Override
    public synchronized void flush() throws IOException {
        long start = System.nanoTime();
        LOGGER.info("Flush started.");
        if (((Bucket)this.bucket).items == 0) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Nothing to be flushed: returning...");
            }
            return;
        }
        long storeSize = this.store.open();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Store size: " + storeSize);
        }
        this.newFlowReceiver.prepareToAppend();
        long next = -1L;
        long count = 0L;
        long storePosition = 0L;
        long newHashes = 0L;
        if (storeSize != 0L) {
            next = this.store.consume();
        }
        int numberOfItems = ((Bucket)this.bucket).items;
        this.bucket.prepare();
        int[] position = this.position;
        long[] buffer = ((Bucket)this.bucket).buffer;
        int i = numberOfItems;
        while (i-- != 0) {
            position[i] = i;
        }
        LongArrays.parallelRadixSortIndirect((int[])position, (long[])buffer, (int)0, (int)numberOfItems, (boolean)false);
        LongArrays.stabilize((int[])position, (long[])buffer, (int)0, (int)numberOfItems);
        int dups = 0;
        long endBucketSorted = System.nanoTime();
        LOGGER.info("Bucket sorted (" + numberOfItems + " items)");
        block1: for (int j = 0; j < numberOfItems; ++j) {
            long hash = buffer[position[j]];
            int k = j;
            while (j < numberOfItems - 1 && buffer[position[j + 1]] == hash) {
                position[++j] = Integer.MAX_VALUE;
                ++dups;
            }
            while (true) {
                if (storePosition == storeSize || hash < next) {
                    this.store.append(hash);
                    ++newHashes;
                    continue block1;
                }
                if (next == hash) {
                    this.store.append(next);
                    position[k] = Integer.MAX_VALUE;
                    if (storePosition < storeSize - 1L) {
                        next = this.store.consume();
                    }
                    ++storePosition;
                    continue block1;
                }
                if (next >= hash) continue;
                this.store.append(next);
                if (storePosition < storeSize - 1L) {
                    next = this.store.consume();
                }
                ++storePosition;
            }
        }
        long endFusion = System.nanoTime();
        LOGGER.info("Fusion with existing store completed (" + Util.format((long)(storePosition + newHashes)) + " hashes, " + Util.format((double)(1.0E9 * (double)(storePosition + newHashes) / (double)Math.max(endFusion - endBucketSorted, 1L))) + " hashes/s)");
        IntArrays.parallelQuickSort((int[])position, (int)0, (int)numberOfItems);
        long endPositionSorted = System.nanoTime();
        LOGGER.info("Positions sorted");
        int auxInPosition = 0;
        for (int j = 0; j < numberOfItems && position[j] != Integer.MAX_VALUE; ++j) {
            while (auxInPosition < position[j]) {
                this.bucket.skipKey();
                ++auxInPosition;
            }
            this.newFlowReceiver.append(buffer[position[j]], this.bucket.consumeKey());
            ++count;
            ++auxInPosition;
        }
        this.newFlowReceiver.finishedAppending();
        long endFlowReceiverAppending = System.nanoTime();
        this.bucket.clear();
        LOGGER.info("Fill: " + 100.0 * (double)numberOfItems / (double)((Bucket)this.bucket).size + " %");
        LOGGER.info("Unique keys: " + Util.format((double)(100.0 - 100.0 * (double)dups / (double)numberOfItems)) + " %");
        while (storePosition < storeSize) {
            this.store.append(next);
            if (storePosition < storeSize - 1L) {
                next = this.store.consume();
            }
            ++storePosition;
        }
        this.store.close();
        long end = System.nanoTime();
        double duration = Math.max(end - start, 1L);
        LOGGER.info("Flush completed (" + count + " keys appended, " + Util.format((double)((double)(end - start) / 1.0E9)) + "s)");
        LOGGER.info("BucketSorting: " + Util.format((double)(100.0 * (double)Math.max(endBucketSorted - start, 0L) / duration)) + "% Fusion: " + Util.format((double)(100.0 * (double)Math.max(endFusion - endBucketSorted, 0L) / duration)) + "% PositionSorting: " + Util.format((double)(100.0 * (double)Math.max(endPositionSorted - endFusion, 0L) / duration)) + "% FlowReceiverAppending: " + Util.format((double)(100.0 * (double)Math.max(endFlowReceiverAppending - endPositionSorted, 0L) / duration)) + "%");
    }

    private static class Store {
        private final File name;
        private final File outputFile;
        private final ByteBuffer outputBuffer;
        private final ByteBuffer inputBuffer;
        private FileChannel inputChannel;
        private FileChannel outputChannel;

        public Store(boolean sieveIsNew, File sieveDir, String name, int bufferSize) throws IOException {
            this.name = new File(sieveDir, name);
            if (sieveIsNew && !this.name.createNewFile()) {
                throw new IOException("Sieve store " + this.name + " exists");
            }
            if (!sieveIsNew && !this.name.exists()) {
                throw new IOException("Can't find sieve store " + this.name);
            }
            this.inputBuffer = ByteBuffer.allocateDirect(bufferSize & 0xFFFFFFF8).order(ByteOrder.nativeOrder());
            this.outputBuffer = ByteBuffer.allocateDirect(bufferSize & 0xFFFFFFF8).order(ByteOrder.nativeOrder());
            this.outputFile = new File(sieveDir, name + "~");
        }

        public long open() throws IOException {
            this.outputChannel = new FileOutputStream(this.outputFile).getChannel();
            this.inputChannel = new FileInputStream(this.name).getChannel();
            this.outputBuffer.clear();
            this.inputBuffer.clear();
            this.inputBuffer.flip();
            return this.name.length() / 8L;
        }

        public void append(long v) throws IOException {
            this.outputBuffer.putLong(v);
            if (!this.outputBuffer.hasRemaining()) {
                this.outputBuffer.flip();
                this.outputChannel.write(this.outputBuffer);
                this.outputBuffer.clear();
            }
        }

        public long consume() throws IOException {
            if (!this.inputBuffer.hasRemaining()) {
                this.inputBuffer.clear();
                this.inputChannel.read(this.inputBuffer);
                this.inputBuffer.flip();
            }
            return this.inputBuffer.getLong();
        }

        public void close() throws IOException {
            this.outputBuffer.flip();
            this.outputChannel.write(this.outputBuffer);
            this.outputChannel.close();
            this.inputChannel.close();
            if (!this.name.delete()) {
                throw new IOException("Cannot delete store file " + this.name);
            }
            if (!this.outputFile.renameTo(this.name)) {
                throw new IOException("Cannot rename new store file " + this.outputFile + " to " + this.name);
            }
        }
    }

    private static final class Bucket<K>
    implements Closeable {
        private ByteSerializerDeserializer<K> serializer;
        private int items;
        private final int size;
        private final long[] buffer;
        private final File auxFile;
        private FastBufferedInputStream auxFbis;
        private final FastBufferedOutputStream aux;
        private byte[] ioBuffer;

        public Bucket(int bucketSize, int bufferSize, File sieveDir, ByteSerializerDeserializer<K> serializer) throws IOException {
            this.serializer = serializer;
            this.ioBuffer = new byte[bufferSize];
            this.items = 0;
            this.size = bucketSize;
            this.buffer = new long[bucketSize];
            this.auxFile = new File(sieveDir, "aux");
            this.aux = new FastBufferedOutputStream((OutputStream)new FileOutputStream(this.auxFile), this.ioBuffer);
        }

        public void append(long hash, K key) throws IOException {
            this.buffer[this.items++] = hash;
            this.serializer.toStream(key, (OutputStream)this.aux);
        }

        public boolean isFull() {
            return this.items == this.size;
        }

        public void prepare() throws IOException {
            this.aux.flush();
            this.auxFbis = new FastBufferedInputStream((InputStream)new FileInputStream(this.auxFile), this.ioBuffer);
        }

        public K consumeKey() throws IOException {
            if (this.auxFbis == null) {
                throw new IllegalStateException();
            }
            return this.serializer.fromStream((InputStream)this.auxFbis);
        }

        public void skipKey() throws IOException {
            if (this.auxFbis == null) {
                throw new IllegalStateException();
            }
            this.serializer.skip(this.auxFbis);
        }

        public void clear() throws IOException {
            this.items = 0;
            this.auxFbis.close();
            this.auxFbis = null;
            this.aux.position(0L);
        }

        @Override
        public void close() {
            this.auxFile.delete();
        }
    }
}

