/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.store;

import it.unimi.di.law.bubing.RuntimeConfiguration;
import it.unimi.di.law.bubing.store.Store;
import it.unimi.di.law.warc.io.ParallelBufferedWarcWriter;
import it.unimi.di.law.warc.records.HttpResponseWarcRecord;
import it.unimi.di.law.warc.records.WarcHeader;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.message.HeaderGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarcStore
implements Closeable,
Store {
    private static final Logger LOGGER = LoggerFactory.getLogger(WarcStore.class);
    public final int OUTPUT_STREAM_BUFFER_SIZE = 0x100000;
    public static final String STORE_NAME = "store.warc.gz";
    public static final String DIGESTS_NAME = "digests.bloom";
    public static final int NUM_GZ_WARC_RECORDS = 16;
    private final FastBufferedOutputStream outputStream;
    private final ParallelBufferedWarcWriter writer;

    public WarcStore(RuntimeConfiguration rc) throws IOException {
        File file = new File(rc.storeDir, STORE_NAME);
        if (rc.crawlIsNew) {
            if (file.exists() && file.length() != 0L) {
                throw new IOException("Store exists and it is not empty, but the crawl is new; it will not be overwritten: " + file);
            }
            this.outputStream = new FastBufferedOutputStream((OutputStream)new FileOutputStream(file), 0x100000);
        } else {
            if (!file.exists()) {
                throw new IOException("Store does not exist, but the crawl is not new; it will not be created: " + file);
            }
            this.outputStream = new FastBufferedOutputStream((OutputStream)new FileOutputStream(file, true), 0x100000);
        }
        this.writer = new ParallelBufferedWarcWriter((OutputStream)this.outputStream, true);
    }

    @Override
    public void store(URI uri, HttpResponse response, boolean isDuplicate, byte[] contentDigest, String guessedCharset) throws IOException, InterruptedException {
        if (contentDigest == null) {
            throw new NullPointerException("Content digest is null");
        }
        HttpResponseWarcRecord record = new HttpResponseWarcRecord(uri, response);
        HeaderGroup warcHeaders = record.getWarcHeaders();
        warcHeaders.updateHeader((Header)new WarcHeader(WarcHeader.Name.WARC_PAYLOAD_DIGEST, "bubing:" + Hex.encodeHexString((byte[])contentDigest)));
        if (guessedCharset != null) {
            warcHeaders.updateHeader((Header)new WarcHeader(WarcHeader.Name.BUBING_GUESSED_CHARSET, guessedCharset));
        }
        if (isDuplicate) {
            warcHeaders.updateHeader((Header)new WarcHeader(WarcHeader.Name.BUBING_IS_DUPLICATE, "true"));
        }
        this.writer.write(record);
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            this.writer.close();
        }
        catch (IOException shouldntHappen) {
            LOGGER.error("Interrupted while closing parallel output stream");
        }
        this.outputStream.close();
    }
}

