/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.test;

import it.unimi.di.law.bubing.test.NamedGraphServer;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.util.XoRoShiRo128PlusRandomGenerator;
import org.apache.commons.lang.StringUtils;

public class RandomNamedGraphServer
implements NamedGraphServer {
    public static final CharSequence[] EMPTY_CHARSEQUENCE_ARRAY = new CharSequence[0];
    private final int degree;
    private final int maxDepth;
    private final double factor;
    private final long correction;
    private final boolean padding;

    public RandomNamedGraphServer(int sites, int degree, int maxDepth) {
        this(sites, degree, maxDepth, false);
    }

    public RandomNamedGraphServer(int sites, int degree, int maxDepth, boolean padding) {
        this.degree = degree;
        this.maxDepth = maxDepth;
        this.factor = 3.0 * Math.log(sites);
        this.correction = (long)sites * (long)sites;
        this.padding = padding;
    }

    private String paddedByte(int b, XoRoShiRo128PlusRandomGenerator random) {
        return this.padding ? "" + b : StringUtils.repeat((String)"0", (int)random.nextInt(2)) + b;
    }

    private String host(XoRoShiRo128PlusRandomGenerator random) {
        int site = Math.min(0x7FFFFFFE, (int)Math.floor(Math.exp(random.nextDouble() * this.factor) / (double)this.correction)) + 1;
        return "" + (site >>> 24 & 0xFF) + '.' + (site >>> 16 & 0xFF) + '.' + this.paddedByte(site >>> 8 & 0xFF, random) + '.' + this.paddedByte(site & 0xFF, random);
    }

    @Override
    public CharSequence[] successors(CharSequence name) {
        MutableString s = new MutableString(name);
        int startHost = s.indexOf('/', s.indexOf('/') + 1) + 1;
        int endHost = s.indexOf('/', startHost);
        if (endHost == -1) {
            endHost = s.length();
        }
        MutableString host = s.substring(startHost, endHost);
        XoRoShiRo128PlusRandomGenerator random = new XoRoShiRo128PlusRandomGenerator((long)host.hashCode());
        int maxDepth = Math.min(this.maxDepth * 3, (int)Math.floor(Math.exp(random.nextGaussian() / 2.0 + (Math.log(this.maxDepth) - 0.125))));
        int meanDegree = Math.min(this.degree * 3, (int)Math.floor(Math.exp(random.nextGaussian() / 2.0 + (Math.log(this.degree) - 0.125))));
        if (s.length() > 0 && s.charAt(s.length() - 1) == '/') {
            s.append("index.html");
        }
        if (s.substring(s.lastIndexOf('/') + 1).equals("robots.txt")) {
            return EMPTY_CHARSEQUENCE_ARRAY;
        }
        random.setSeed(s.hashCode());
        char[] a = s.array();
        int d = -3;
        int i = s.length();
        while (i-- != 0) {
            if (a[i] != '/') continue;
            ++d;
        }
        if (d > maxDepth) {
            return null;
        }
        if (d == maxDepth) {
            return EMPTY_CHARSEQUENCE_ARRAY;
        }
        int degree = Math.max(0, (int)((double)meanDegree + random.nextGaussian()));
        CharSequence[] result = new CharSequence[degree];
        MutableString u = new MutableString();
        for (int i2 = 0; i2 < degree; ++i2) {
            if (random.nextDouble() < 0.1) {
                int depth = (int)((double)maxDepth * Math.min(1.0, Math.abs(random.nextGaussian())));
                u.length(0);
                u.append("http://").append(this.host(random)).append('/');
                while (depth-- != 0) {
                    u.append(random.nextInt(degree)).append('/');
                }
            } else {
                u.replace(s);
                u.length(u.lastIndexOf('/') + 1);
                if (d > 0 && random.nextDouble() < 0.5) {
                    u.length(u.lastIndexOf('/', u.length() - 2) + 1);
                } else {
                    u.append(random.nextInt(degree)).append('/');
                }
            }
            u.append("index.html");
            result[i2] = u.copy();
        }
        return result;
    }

    public RandomNamedGraphServer copy() {
        return this;
    }
}

