/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.tool;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.big.webgraph.EFGraph;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;
import it.unimi.dsi.util.ByteBufferLongBigList;
import it.unimi.dsi.webgraph.EFGraph;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Properties;

public class CatEFGraphs {
    public static void main(String[] arg) throws IOException, JSAPException {
        SimpleJSAP jsap = new SimpleJSAP(CatEFGraphs.class.getName(), "Concatenates EF graphs with a common upper bound.", new Parameter[]{new Switch("mapped", 'm', "mapped", "Memory-map the input graphs instead of loading them in core memory."), new UnflaggedOption("output", (StringParser)JSAP.STRING_PARSER, true, "The basename of the concatenated EF graph."), new UnflaggedOption("input", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, true, "The basenames of the EF graphs to concatenate.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String output = jsapResult.getString("output");
        boolean mapped = jsapResult.userSpecified("mapped");
        FileChannel outputGraphChannel = new FileOutputStream(output + ".graph").getChannel();
        EFGraph.LongWordOutputBitStream outputGraphStream = new EFGraph.LongWordOutputBitStream((WritableByteChannel)outputGraphChannel, ByteOrder.nativeOrder());
        OutputBitStream outputOffsets = new OutputBitStream(output + ".offsets");
        boolean first = true;
        Properties properties = new Properties();
        long numNodes = 0L;
        long numArcs = 0L;
        long upperBound = -1L;
        for (String input : jsapResult.getStringArray("input")) {
            long i;
            long ub;
            ByteOrder byteOrder;
            FileInputStream propertyFile = new FileInputStream(input + ".properties");
            properties = new Properties();
            properties.load(propertyFile);
            propertyFile.close();
            if (properties.get("byteorder").equals(ByteOrder.BIG_ENDIAN.toString())) {
                byteOrder = ByteOrder.BIG_ENDIAN;
            } else if (properties.get("byteorder").equals(ByteOrder.LITTLE_ENDIAN.toString())) {
                byteOrder = ByteOrder.LITTLE_ENDIAN;
            } else {
                throw new IllegalArgumentException("Unknown byte order " + properties.get("byteorder"));
            }
            long n = Long.parseLong(properties.getProperty("nodes"));
            numNodes += n;
            numArcs += Long.parseLong(properties.getProperty("arcs"));
            long l = ub = properties.containsKey("upperbound") ? Long.parseLong(properties.getProperty("upperbound")) : n;
            if (upperBound < 0L) {
                upperBound = ub;
            } else if (upperBound != ub) {
                throw new IllegalArgumentException(input + " upper bound " + ub + " != " + upperBound);
            }
            InputBitStream inputOffsets = new InputBitStream(input + ".offsets");
            if (!first) {
                inputOffsets.readDelta();
            }
            long length = 0L;
            long l2 = i = first ? 0L : 1L;
            while (i <= n) {
                long delta = inputOffsets.readLongDelta();
                outputOffsets.writeLongDelta(delta);
                length += delta;
                ++i;
            }
            inputOffsets.close();
            if (mapped) {
                FileInputStream inputStream = new FileInputStream(input + ".graph");
                outputGraphStream.append((LongBigList)ByteBufferLongBigList.map((FileChannel)inputStream.getChannel(), (ByteOrder)byteOrder), length);
                inputStream.close();
            } else {
                outputGraphStream.append((LongBigList)EFGraph.loadLongBigList((CharSequence)(input + ".graph"), (ByteOrder)byteOrder), length);
            }
            first = false;
        }
        properties.setProperty("nodes", Long.toString(numNodes));
        properties.setProperty("arcs", Long.toString(numArcs));
        properties.setProperty("byteorder", ByteOrder.nativeOrder().toString());
        FileOutputStream outputProperties = new FileOutputStream(output + ".properties");
        properties.store(outputProperties, "EFGraph properties");
        outputProperties.close();
        outputOffsets.close();
        outputGraphStream.close();
    }
}

