/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.util;

import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.io.ByteDiskQueue;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public class ByteArrayDiskQueue
implements Closeable,
Size64 {
    private final ByteDiskQueue byteDiskQueue;
    private long size;
    private ByteArrayList buffer;

    protected ByteArrayDiskQueue(ByteDiskQueue byteDiskQueue) {
        this.byteDiskQueue = byteDiskQueue;
        this.buffer = new ByteArrayList(1024);
    }

    public static ByteArrayDiskQueue createNew(File file, int bufferSize, boolean direct) throws IOException {
        return new ByteArrayDiskQueue(ByteDiskQueue.createNew((File)file, (int)bufferSize, (boolean)direct));
    }

    public static ByteArrayDiskQueue createFromFile(long size, File file, int bufferSize, boolean direct) throws IOException {
        ByteArrayDiskQueue byteArrayDiskQueue = new ByteArrayDiskQueue(ByteDiskQueue.createFromFile((File)file, (int)bufferSize, (boolean)direct));
        byteArrayDiskQueue.size = size;
        return byteArrayDiskQueue;
    }

    public synchronized void enqueue(byte[] array) throws IOException {
        assert (array != null);
        this.byteDiskQueue.enqueueInt(array.length);
        this.byteDiskQueue.enqueue(array);
        ++this.size;
    }

    public synchronized void enqueue(byte[] array, int offset, int length) throws IOException {
        assert (array != null);
        this.byteDiskQueue.enqueueInt(length);
        this.byteDiskQueue.enqueue(array, offset, length);
        ++this.size;
    }

    public synchronized void dequeue() throws IOException {
        int length = this.byteDiskQueue.dequeueInt();
        this.buffer.size(length);
        this.byteDiskQueue.dequeue(this.buffer.elements(), 0, length);
        --this.size;
    }

    public ByteArrayList buffer() {
        return this.buffer;
    }

    @Deprecated
    public synchronized int size() {
        throw new UnsupportedOperationException();
    }

    public synchronized long size64() {
        return this.size;
    }

    public synchronized boolean isEmpty() {
        return this.size == 0L;
    }

    @Override
    public synchronized void close() throws IOException {
        this.byteDiskQueue.close();
    }

    public synchronized void freeze() throws IOException {
        this.byteDiskQueue.freeze();
    }

    public synchronized void clear() {
        this.byteDiskQueue.clear();
        this.size = 0L;
    }

    public synchronized void trim() throws IOException {
        this.byteDiskQueue.trim();
    }

    public synchronized void suspend() throws IOException {
        this.byteDiskQueue.suspend();
    }

    public synchronized void enlargeBuffer(int newBufferSize) {
        this.byteDiskQueue.enlargeBuffer(newBufferSize);
    }
}

