/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.util;

import it.unimi.di.law.bubing.util.MurmurHash3;
import it.unimi.di.law.bubing.util.Util;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.fastutil.Hash;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ConcurrentCountingMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Stripe[] stripe;
    private final ReentrantReadWriteLock[] lock;
    private final int shift;

    public ConcurrentCountingMap() {
        this(Runtime.getRuntime().availableProcessors());
    }

    public ConcurrentCountingMap(int concurrencyLevel) {
        this.stripe = new Stripe[Math.max(2, Integer.highestOneBit(concurrencyLevel))];
        this.lock = new ReentrantReadWriteLock[this.stripe.length];
        int i = this.stripe.length;
        while (i-- != 0) {
            this.stripe[i] = new Stripe();
            this.lock[i] = new ReentrantReadWriteLock();
        }
        this.shift = 64 - Fast.mostSignificantBit((int)this.stripe.length);
    }

    public int get(byte[] array) {
        return this.get(array, 0, array.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get(byte[] array, int offset, int length) {
        long hash = MurmurHash3.hash(array, offset, length);
        ReentrantReadWriteLock.ReadLock readLock = this.lock[(int)(hash >>> this.shift)].readLock();
        try {
            readLock.lock();
            int n = this.stripe[(int)(hash >>> this.shift)].get(array, offset, length, hash);
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    public int addTo(byte[] array, int delta) {
        return this.addTo(array, 0, array.length, delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addTo(byte[] array, int offset, int length, int delta) {
        long hash = MurmurHash3.hash(array, offset, length);
        ReentrantReadWriteLock.WriteLock writeLock = this.lock[(int)(hash >>> this.shift)].writeLock();
        try {
            writeLock.lock();
            int n = this.stripe[(int)(hash >>> this.shift)].addTo(array, offset, length, hash, delta);
            return n;
        }
        finally {
            writeLock.unlock();
        }
    }

    public int put(byte[] array, int value) {
        return this.put(array, 0, array.length, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int put(byte[] array, int offset, int length, int value) {
        long hash = MurmurHash3.hash(array, offset, length);
        ReentrantReadWriteLock.WriteLock writeLock = this.lock[(int)(hash >>> this.shift)].writeLock();
        try {
            writeLock.lock();
            int n = this.stripe[(int)(hash >>> this.shift)].put(array, offset, length, hash, value);
            return n;
        }
        finally {
            writeLock.unlock();
        }
    }

    public LockedMap lock() {
        return new LockedMap(this);
    }

    protected static final class Stripe
    implements Serializable,
    Cloneable,
    Hash {
        private static final long serialVersionUID = 0L;
        protected transient byte[][] key;
        protected transient int[] value;
        protected int n = 1024;
        protected int maxFill;
        protected transient int mask = this.n - 1;
        protected int size;

        protected Stripe() {
            this.maxFill = 3 * (this.n / 4);
            this.key = new byte[this.n][];
            this.value = new int[this.n];
        }

        private static final boolean equals(byte[] a, byte[] b, int offset, int length) {
            while (length-- != 0) {
                if (a[length] == b[offset + length]) continue;
                return false;
            }
            return true;
        }

        public int put(byte[] array, int offset, int length, long hash, int v) {
            int pos = (int)(hash & (long)this.mask);
            while (this.key[pos] != null) {
                if (this.key[pos].length == length && Stripe.equals(this.key[pos], array, offset, length)) {
                    int oldValue = this.value[pos];
                    this.value[pos] = v;
                    return oldValue;
                }
                pos = pos + 1 & this.mask;
            }
            this.key[pos] = Arrays.copyOfRange(array, offset, offset + length);
            this.value[pos] = v;
            if (++this.size >= this.maxFill) {
                this.rehash(this.n * 2);
            }
            return 0;
        }

        public int addTo(byte[] array, int offset, int length, long hash, int incr) {
            int pos = (int)(hash & (long)this.mask);
            while (this.key[pos] != null) {
                if (this.key[pos].length == length && Stripe.equals(this.key[pos], array, offset, length)) {
                    int oldValue = this.value[pos];
                    int n = pos;
                    this.value[n] = this.value[n] + incr;
                    return oldValue;
                }
                pos = pos + 1 & this.mask;
            }
            this.key[pos] = Arrays.copyOfRange(array, offset, offset + length);
            this.value[pos] = incr;
            if (++this.size >= this.maxFill) {
                this.rehash(this.n * 2);
            }
            return 0;
        }

        protected final int shiftKeys(int pos) {
            int last;
            while (true) {
                last = pos;
                pos = last + 1 & this.mask;
                while (this.key[pos] != null) {
                    int slot = (int)(MurmurHash3.hash(this.key[pos]) & (long)this.mask);
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & this.mask;
                }
                if (this.key[pos] == null) break;
                this.key[last] = this.key[pos];
                this.value[last] = this.value[pos];
            }
            this.key[last] = null;
            return last;
        }

        public int remove(byte[] array, int offset, int length, long hash) {
            int pos = (int)(hash & (long)this.mask);
            while (this.key[pos] != null) {
                if (this.key[pos].length == length && Stripe.equals(this.key[pos], array, offset, length)) {
                    --this.size;
                    int v = this.value[pos];
                    this.shiftKeys(pos);
                    return v;
                }
                pos = pos + 1 & this.mask;
            }
            return 0;
        }

        public int get(byte[] array, int offset, int length, long hash) {
            int pos = (int)(hash & (long)this.mask);
            while (this.key[pos] != null) {
                if (this.key[pos].length == length && Stripe.equals(this.key[pos], array, offset, length)) {
                    return this.value[pos];
                }
                pos = pos + 1 & this.mask;
            }
            return 0;
        }

        protected void rehash(int newN) {
            int i = 0;
            byte[][] key = this.key;
            int[] value = this.value;
            int mask = newN - 1;
            byte[][] newKey = new byte[newN][];
            int[] newValue = new int[newN];
            int j = this.size;
            while (j-- != 0) {
                while (key[i] == null) {
                    ++i;
                }
                byte[] k = key[i];
                int pos = (int)(MurmurHash3.hash(k) & (long)mask);
                while (newKey[pos] != null) {
                    pos = pos + 1 & mask;
                }
                newKey[pos] = k;
                newValue[pos] = value[i];
                ++i;
            }
            this.n = newN;
            this.mask = mask;
            this.maxFill = 3 * (this.n / 4);
            this.key = newKey;
            this.value = newValue;
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            byte[][] key = this.key;
            int[] value = this.value;
            s.defaultWriteObject();
            int j = this.size;
            int i = 0;
            while (j-- != 0) {
                while (key[i] == null) {
                    ++i;
                }
                Util.writeVByte(key[i].length, s);
                s.write(key[i]);
                s.writeInt(value[i]);
                ++i;
            }
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            this.mask = this.n - 1;
            byte[][] byArrayArray = new byte[this.n][];
            this.key = byArrayArray;
            byte[][] key = byArrayArray;
            this.value = new int[this.n];
            int[] value = this.value;
            int i = this.size;
            while (i-- != 0) {
                int length = Util.readVByte(s);
                byte[] k = new byte[length];
                s.readFully(k);
                int v = s.readInt();
                int pos = (int)(MurmurHash3.hash(k) & (long)this.mask);
                while (key[pos] != null) {
                    pos = pos + 1 & this.mask;
                }
                key[pos] = k;
                value[pos] = v;
            }
        }
    }

    public static final class LockedMap {
        private boolean released;
        private final Stripe[] stripe;
        private final ReentrantReadWriteLock.WriteLock[] writeLock;
        private final int shift;

        public LockedMap(ConcurrentCountingMap concurrentCountingMap) {
            this.stripe = concurrentCountingMap.stripe;
            this.writeLock = new ReentrantReadWriteLock.WriteLock[concurrentCountingMap.stripe.length];
            this.shift = concurrentCountingMap.shift;
            int i = this.writeLock.length;
            while (i-- != 0) {
                this.writeLock[i] = concurrentCountingMap.lock[i].writeLock();
                this.writeLock[i].lock();
            }
        }

        public void unlock() {
            for (ReentrantReadWriteLock.WriteLock w : this.writeLock) {
                w.unlock();
            }
            this.released = true;
        }

        public int get(byte[] array) {
            return this.get(array, 0, array.length);
        }

        public int get(byte[] array, int offset, int length) {
            if (this.released) {
                throw new IllegalStateException();
            }
            long hash = MurmurHash3.hash(array, offset, length);
            return this.stripe[(int)(hash >>> this.shift)].get(array, offset, length, hash);
        }

        public int addTo(byte[] array, int delta) {
            return this.addTo(array, 0, array.length, delta);
        }

        public int addTo(byte[] array, int offset, int length, int delta) {
            if (this.released) {
                throw new IllegalStateException();
            }
            long hash = MurmurHash3.hash(array, offset, length);
            return this.stripe[(int)(hash >>> this.shift)].addTo(array, offset, length, hash, delta);
        }

        public int put(byte[] array, int value) {
            return this.put(array, 0, array.length, value);
        }

        public int put(byte[] array, int offset, int length, int value) {
            if (this.released) {
                throw new IllegalStateException();
            }
            long hash = MurmurHash3.hash(array, offset, length);
            return this.stripe[(int)(hash >>> this.shift)].put(array, offset, length, hash, value);
        }
    }
}

