/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.util;

import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;

public class ConcurrentSummaryStats
implements Size64 {
    private double a;
    private double q;
    private double min = Double.POSITIVE_INFINITY;
    private double max = Double.NEGATIVE_INFINITY;
    private long size;

    public synchronized void add(double x) {
        double oldA = this.a;
        this.a += (x - this.a) / (double)(++this.size);
        this.q += (x - this.a) * (x - oldA);
        this.min = Math.min(this.min, x);
        this.max = Math.max(this.max, x);
    }

    public void addAll(double[] a) {
        for (double x : a) {
            this.add(x);
        }
    }

    public void addAll(DoubleList l) {
        DoubleListIterator doubleListIterator = l.iterator();
        while (doubleListIterator.hasNext()) {
            double x = (Double)doubleListIterator.next();
            this.add(x);
        }
    }

    public double mean() {
        return this.a;
    }

    public double sum() {
        return this.a * (double)this.size;
    }

    public double sampleVariance() {
        return this.q / (double)(this.size - 1L);
    }

    public double variance() {
        return this.q / (double)this.size;
    }

    public double sampleStandardDeviation() {
        return Math.sqrt(this.sampleVariance());
    }

    public double standardDeviation() {
        return Math.sqrt(this.variance());
    }

    public double sampleRelativeStandardDeviation() {
        return Math.sqrt(this.sampleVariance()) / this.mean();
    }

    public double relativeStandardDeviation() {
        return Math.sqrt(this.variance()) / this.mean();
    }

    public double min() {
        return this.min;
    }

    public double max() {
        return this.max;
    }

    public long size64() {
        return this.size;
    }

    @Deprecated
    public int size() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "[size: " + Util.format((long)this.size) + " min: " + this.min + " max: " + this.max + " \u03bc: " + this.mean() + " \u03c3: " + this.sampleStandardDeviation() + " (" + Util.format((double)(100.0 * this.sampleRelativeStandardDeviation())) + " %)]";
    }

    public static void main(String[] args) {
        final ConcurrentSummaryStats css = new ConcurrentSummaryStats();
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < Integer.parseInt(args[0]); ++i) {
            Thread tmp = new Thread(){

                @Override
                public void run() {
                    while (true) {
                        double rr = Math.random();
                        css.add(rr);
                    }
                }
            };
            tmp.start();
            if (i % 100 != 0) continue;
            System.out.println("i: " + i + " " + css.toString());
        }
        System.out.println("Starting to sleep");
        try {
            Thread.sleep(100000L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        System.out.println(css.toString());
        System.out.println(System.currentTimeMillis() - startTime);
    }
}

