/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.util;

import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import java.util.concurrent.atomic.AtomicLong;

public class FastApproximateByteArrayCache {
    private static final int BYTES_PER_TABLE_CELL = 32;
    private final Stripe[] stripe;
    private final int mask;
    private final AtomicLong hits = new AtomicLong();
    private final AtomicLong misses = new AtomicLong();

    public FastApproximateByteArrayCache(long byteSize) {
        this(byteSize, Runtime.getRuntime().availableProcessors());
    }

    public FastApproximateByteArrayCache(long byteSize, int concurrencyLevel) {
        this.stripe = new Stripe[Integer.highestOneBit(concurrencyLevel)];
        long stripeSize = byteSize / (long)this.stripe.length;
        if (stripeSize >= 64L) {
            int i = this.stripe.length;
            while (i-- != 0) {
                this.stripe[i] = new Stripe(stripeSize, 0.75f);
            }
            this.mask = this.stripe.length - 1;
        } else {
            this.mask = -1;
        }
    }

    private static long getblock(byte[] key, int i) {
        return ((long)key[i + 0] & 0xFFL) << 0 | ((long)key[i + 1] & 0xFFL) << 8 | ((long)key[i + 2] & 0xFFL) << 16 | ((long)key[i + 3] & 0xFFL) << 24 | ((long)key[i + 4] & 0xFFL) << 32 | ((long)key[i + 5] & 0xFFL) << 40 | ((long)key[i + 6] & 0xFFL) << 48 | ((long)key[i + 7] & 0xFFL) << 56;
    }

    private static long fmix(long k) {
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }

    public boolean add(byte[] key) {
        return this.add(key, 0, key.length);
    }

    public boolean add(ByteArrayList key) {
        return this.add(key.elements(), 0, key.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(byte[] key, int offset, int length) {
        boolean result;
        Stripe s;
        if (this.mask == -1) {
            this.misses.incrementAndGet();
            return true;
        }
        long h1 = -7824752305899900300L;
        long h2 = 6371974587529090045L;
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        long k1 = 0L;
        long k2 = 0L;
        for (int i = 0; i < length / 16; ++i) {
            k1 = FastApproximateByteArrayCache.getblock(key, offset + i * 2 * 8);
            k2 = FastApproximateByteArrayCache.getblock(key, offset + (i * 2 + 1) * 8);
            k1 *= c1;
            k1 = k1 << 23 | k1 >>> 41;
            h1 ^= (k1 *= c2);
            h1 += h2;
            h2 = h2 << 41 | h2 >>> 23;
            k2 *= c2;
            k2 = k2 << 23 | k2 >>> 41;
            h2 ^= (k2 *= c1);
            h2 += h1;
            h1 = h1 * 3L + 1390208809L;
            h2 = h2 * 3L + 944331445L;
            c1 = c1 * 5L + 2071795100L;
            c2 = c2 * 5L + 1808688022L;
        }
        k1 = 0L;
        k2 = 0L;
        int tail = offset + (length >>> 4 << 4);
        switch (length & 0xF) {
            case 15: {
                k2 ^= (long)key[tail + 14] << 48;
            }
            case 14: {
                k2 ^= (long)key[tail + 13] << 40;
            }
            case 13: {
                k2 ^= (long)key[tail + 12] << 32;
            }
            case 12: {
                k2 ^= (long)key[tail + 11] << 24;
            }
            case 11: {
                k2 ^= (long)key[tail + 10] << 16;
            }
            case 10: {
                k2 ^= (long)key[tail + 9] << 8;
            }
            case 9: {
                k2 ^= (long)key[tail + 8] << 0;
            }
            case 8: {
                k1 ^= (long)key[tail + 7] << 56;
            }
            case 7: {
                k1 ^= (long)key[tail + 6] << 48;
            }
            case 6: {
                k1 ^= (long)key[tail + 5] << 40;
            }
            case 5: {
                k1 ^= (long)key[tail + 4] << 32;
            }
            case 4: {
                k1 ^= (long)key[tail + 3] << 24;
            }
            case 3: {
                k1 ^= (long)key[tail + 2] << 16;
            }
            case 2: {
                k1 ^= (long)key[tail + 1] << 8;
            }
            case 1: {
                k1 ^= (long)key[tail + 0] << 0;
                k1 *= c1;
                k1 = k1 << 23 | k1 >>> 41;
                h1 ^= (k1 *= c2);
                h1 += h2;
                h2 = h2 << 41 | h2 >>> 23;
                k2 *= c2;
                k2 = k2 << 23 | k2 >>> 41;
                h2 ^= (k2 *= c1);
                h2 += h1;
                h1 = h1 * 3L + 1390208809L;
                h2 = h2 * 3L + 944331445L;
                c1 = c1 * 5L + 2071795100L;
                c2 = c2 * 5L + 1808688022L;
            }
        }
        h1 += (h2 ^= (long)length);
        h2 += h1;
        h1 = FastApproximateByteArrayCache.fmix(h1);
        h2 = FastApproximateByteArrayCache.fmix(h2);
        h1 += h2;
        if (h1 == 0L && (h2 += h1) == 0L) {
            h1 = -1L;
        }
        Stripe stripe = s = this.stripe[(int)(h1 & (long)this.mask)];
        synchronized (stripe) {
            result = s.add(h1, h2);
        }
        if (result) {
            this.misses.incrementAndGet();
        } else {
            this.hits.incrementAndGet();
        }
        return result;
    }

    public long hits() {
        return this.hits.get();
    }

    public long misses() {
        return this.misses.get();
    }

    protected static final class Stripe {
        private final long[] key;
        private final int[] link;
        private final int maxFill;
        private final int mask;
        private int size;
        private int first = -1;
        private int last = -1;

        public Stripe(long byteSize, float f) {
            if (Long.highestOneBit(byteSize / 16L) >= 0x40000000L) {
                throw new IllegalArgumentException();
            }
            int n = (int)Long.highestOneBit(byteSize / 32L);
            this.maxFill = (int)((float)n * f);
            this.mask = n * 2 - 2;
            this.key = new long[n * 2];
            this.link = new int[n * 2];
        }

        public boolean add(long lowerBitsKey, long upperBitsKey) {
            int pos = (int)(upperBitsKey & (long)this.mask);
            while (this.key[pos] != 0L || this.key[pos + 1] != 0L) {
                if (this.key[pos] == upperBitsKey && this.key[pos + 1] == lowerBitsKey) {
                    return false;
                }
                pos = pos + 2 & this.mask;
            }
            this.key[pos] = upperBitsKey;
            this.key[pos + 1] = lowerBitsKey;
            if (this.size == 0) {
                this.first = this.last = pos;
                this.link[pos] = -1;
                this.link[pos + 1] = -1;
            } else {
                this.link[this.last + 1] = pos;
                this.link[pos] = this.last;
                this.link[pos + 1] = -1;
                this.last = pos;
            }
            if (++this.size >= this.maxFill) {
                this.removeLastRecentlyUsed();
            }
            return true;
        }

        private void removeLastRecentlyUsed() {
            --this.size;
            int pos = this.first;
            this.first = this.link[pos + 1];
            if (0 <= this.first) {
                this.link[this.first] = -1;
            }
            this.shiftKeys(pos);
        }

        private final int shiftKeys(int pos) {
            int last;
            while (true) {
                last = pos;
                pos = last + 2 & this.mask;
                while (this.key[pos] != 0L || this.key[pos + 1] != 0L) {
                    int slot = (int)(this.key[pos] & (long)this.mask);
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 2 & this.mask;
                }
                if (this.key[pos] == 0L && this.key[pos + 1] == 0L) break;
                this.key[last] = this.key[pos];
                this.key[last + 1] = this.key[pos + 1];
                this.fixPointers(pos, last);
            }
            this.key[last] = 0L;
            this.key[last + 1] = 0L;
            return last;
        }

        private void fixPointers(int s, int d) {
            if (this.size == 1) {
                this.first = this.last = d;
                this.link[d] = -1;
                this.link[d + 1] = -1;
                return;
            }
            if (this.first == s) {
                this.first = d;
                this.link[this.link[s + 1]] = d;
                this.link[d] = -1;
                this.link[d + 1] = this.link[s + 1];
                return;
            }
            if (this.last == s) {
                this.last = d;
                this.link[this.link[s] + 1] = d;
                this.link[d] = this.link[s];
                this.link[d + 1] = -1;
                return;
            }
            int prev = this.link[s];
            int next = this.link[s + 1];
            this.link[prev + 1] = d;
            this.link[next] = d;
            this.link[d] = prev;
            this.link[d + 1] = next;
        }
    }
}

