/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.util;

import it.unimi.dsi.fastutil.bytes.ByteArrayList;

public class MurmurHash3 {
    private static final long getblock(byte[] key, int i) {
        return ((long)key[i + 0] & 0xFFL) << 0 | ((long)key[i + 1] & 0xFFL) << 8 | ((long)key[i + 2] & 0xFFL) << 16 | ((long)key[i + 3] & 0xFFL) << 24 | ((long)key[i + 4] & 0xFFL) << 32 | ((long)key[i + 5] & 0xFFL) << 40 | ((long)key[i + 6] & 0xFFL) << 48 | ((long)key[i + 7] & 0xFFL) << 56;
    }

    private static final long fmix(long k) {
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }

    public static final long hash(ByteArrayList list) {
        return MurmurHash3.hash(list.elements(), 0, list.size());
    }

    public static final long hash(byte[] array) {
        return MurmurHash3.hash(array, 0, array.length);
    }

    public static final long hash(byte[] array, int offset, int length) {
        return MurmurHash3.hash(array, offset, length, 0L);
    }

    public static final long hash(byte[] array, int offset, int length, long seed) {
        long h1 = 0x9368E53C2F6AF274L ^ seed;
        long h2 = 0x586DCD208F7CD3FDL ^ seed;
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        long k1 = 0L;
        long k2 = 0L;
        for (int i = 0; i < length / 16; ++i) {
            k1 = MurmurHash3.getblock(array, offset + i * 2 * 8);
            k2 = MurmurHash3.getblock(array, offset + (i * 2 + 1) * 8);
            k1 *= c1;
            k1 = k1 << 23 | k1 >>> 41;
            h1 ^= (k1 *= c2);
            h1 += h2;
            h2 = h2 << 41 | h2 >>> 23;
            k2 *= c2;
            k2 = k2 << 23 | k2 >>> 41;
            h2 ^= (k2 *= c1);
            h2 += h1;
            h1 = h1 * 3L + 1390208809L;
            h2 = h2 * 3L + 944331445L;
            c1 = c1 * 5L + 2071795100L;
            c2 = c2 * 5L + 1808688022L;
        }
        k1 = 0L;
        k2 = 0L;
        int tail = offset + (length >>> 4 << 4);
        switch (length & 0xF) {
            case 15: {
                k2 ^= (long)array[tail + 14] << 48;
            }
            case 14: {
                k2 ^= (long)array[tail + 13] << 40;
            }
            case 13: {
                k2 ^= (long)array[tail + 12] << 32;
            }
            case 12: {
                k2 ^= (long)array[tail + 11] << 24;
            }
            case 11: {
                k2 ^= (long)array[tail + 10] << 16;
            }
            case 10: {
                k2 ^= (long)array[tail + 9] << 8;
            }
            case 9: {
                k2 ^= (long)array[tail + 8] << 0;
            }
            case 8: {
                k1 ^= (long)array[tail + 7] << 56;
            }
            case 7: {
                k1 ^= (long)array[tail + 6] << 48;
            }
            case 6: {
                k1 ^= (long)array[tail + 5] << 40;
            }
            case 5: {
                k1 ^= (long)array[tail + 4] << 32;
            }
            case 4: {
                k1 ^= (long)array[tail + 3] << 24;
            }
            case 3: {
                k1 ^= (long)array[tail + 2] << 16;
            }
            case 2: {
                k1 ^= (long)array[tail + 1] << 8;
            }
            case 1: {
                k1 ^= (long)array[tail + 0] << 0;
                k1 *= c1;
                k1 = k1 << 23 | k1 >>> 41;
                h1 ^= (k1 *= c2);
                h1 += h2;
                h2 = h2 << 41 | h2 >>> 23;
                k2 *= c2;
                k2 = k2 << 23 | k2 >>> 41;
                h2 ^= (k2 *= c1);
                h2 += h1;
                h1 = h1 * 3L + 1390208809L;
                h2 = h2 * 3L + 944331445L;
                c1 = c1 * 5L + 2071795100L;
                c2 = c2 * 5L + 1808688022L;
            }
        }
        h1 += (h2 ^= (long)length);
        h2 += h1;
        h1 = MurmurHash3.fmix(h1);
        h2 = MurmurHash3.fmix(h2);
        return h1 += h2;
    }
}

