/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.filters;

import it.unimi.di.law.warc.filters.AbstractFilter;
import it.unimi.di.law.warc.filters.Filter;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public class ContentTypeStartsWith
extends AbstractFilter<HttpResponse> {
    private final String prefix;

    public ContentTypeStartsWith(String prefix) {
        this.prefix = prefix;
    }

    public boolean apply(HttpResponse x) {
        Header header = x.getFirstHeader("Content-Type");
        return header != null && header.getValue().startsWith(this.prefix);
    }

    public static ContentTypeStartsWith valueOf(String spec) {
        return new ContentTypeStartsWith(spec);
    }

    public String toString() {
        return this.toString(this.prefix);
    }

    public boolean equals(Object x) {
        return x instanceof ContentTypeStartsWith && ((ContentTypeStartsWith)x).prefix.equals(this.prefix);
    }

    public Filter<HttpResponse> copy() {
        return this;
    }

    public int hashCode() {
        return this.prefix.hashCode() ^ ContentTypeStartsWith.class.hashCode();
    }
}

